/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.TilesetAnimationMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TilesetGroupAnimationMap {
    private static final Logger LOGGER = Logger.getLogger(TilesetGroupAnimationMap.class);
    private Map<String, TilesetAnimationMap> tilesets = new HashMap<String, TilesetAnimationMap>();

    private TilesetAnimationMap acquire(String string) {
        TilesetAnimationMap tilesetAnimationMap = this.tilesets.get(string);
        if (tilesetAnimationMap == null) {
            tilesetAnimationMap = new TilesetAnimationMap();
            this.tilesets.put(string, tilesetAnimationMap);
        }
        return tilesetAnimationMap;
    }

    private void add(String string, int n, int[] nArray, int[] nArray2) {
        this.acquire(string).add(n, nArray, nArray2);
    }

    private void add(String string, int[] nArray, int[] nArray2) {
        this.acquire(string).add(nArray, nArray2);
    }

    private void addConfig(String string) {
        int n;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (!stringTokenizer.hasMoreTokens()) {
            LOGGER.warn((Object)("Invalid map entry: " + string));
            return;
        }
        String string3 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            LOGGER.error((Object)("Invalid map entry: " + string));
            return;
        }
        String string4 = stringTokenizer.nextToken();
        int n2 = string4.indexOf(64);
        if (n2 != -1) {
            string2 = string4.substring(n2 + 1);
            string4 = string4.substring(0, n2);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error((Object)("Invalid default delay: " + string2));
                return;
            }
        } else {
            n = 500;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            LOGGER.error((Object)("Invalid map entry: " + string));
            return;
        }
        string2 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2, ":");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            String string5 = stringTokenizer.nextToken();
            n2 = string5.indexOf(64);
            if (n2 != -1) {
                String string6 = string5.substring(n2 + 1);
                string5 = string5.substring(0, n2);
                try {
                    nArray2[i] = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error((Object)("Invalid delay #" + (i + 1) + " <" + string6 + ">: " + string));
                    return;
                }
            } else {
                nArray2[i] = n;
            }
            try {
                nArray[i] = Integer.parseInt(string5);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error((Object)("Invalid frame #" + (i + 1) + " <" + string5 + ">: " + string));
                return;
            }
        }
        if (string4.equals("*")) {
            this.add(string3, nArray, nArray2);
        } else {
            try {
                this.add(string3, Integer.parseInt(string4), nArray, nArray2);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error((Object)("Invalid tile index: " + string));
                return;
            }
        }
    }

    public TilesetAnimationMap get(String string) {
        return this.tilesets.get(string);
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.charAt(0) == '#') continue;
            this.addConfig(string);
        }
    }
}

