/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import games.stendhal.common.CollisionMap;
import games.stendhal.common.tiled.LayerDefinition;
import java.awt.geom.Rectangle2D;

public class CollisionDetection {
    private CollisionMap map;
    private int width;
    private int height;

    public void clear() {
        if (this.map == null) {
            this.map = new CollisionMap(this.width, this.height);
        }
    }

    public void init(int n, int n2) {
        if (this.width != n || this.height != n2) {
            this.map = null;
        } else if (this.map != null) {
            this.map.clear();
        }
        this.width = n;
        this.height = n2;
        this.clear();
    }

    public void setCollide(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return;
        }
        this.map.set(n, n2);
    }

    public void setCollisionData(LayerDefinition layerDefinition) {
        layerDefinition.build();
        this.init(layerDefinition.getWidth(), layerDefinition.getHeight());
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                boolean bl;
                boolean bl2 = bl = layerDefinition.getTileAt(j, i) != 0;
                if (!bl) continue;
                this.map.set(j, i);
            }
        }
    }

    public void printaround(int n, int n2, int n3) {
        for (int i = n2 - n3; i < n2 + n3; ++i) {
            for (int j = n - n3; j < n + n3; ++j) {
                if (i < 0 || i >= this.height || j < 0 || j >= this.width) continue;
                if (i == n2 && j == n) {
                    System.out.print("O");
                    continue;
                }
                if (this.map.get(j, i)) {
                    System.out.print("X");
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    public boolean leavesZone(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        return d < 0.0 || d + d3 > (double)this.width || d2 < 0.0 || d2 + d4 > (double)this.height;
    }

    public boolean collides(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        return this.collides(d, d2, d3, d4);
    }

    public boolean collides(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d + d3 > (double)this.width) {
            return true;
        }
        if (d2 < 0.0 || d2 + d4 > (double)this.height) {
            return true;
        }
        int n = (int)Math.ceil(Math.ceil(d2 + d4) - d2);
        int n2 = (int)Math.ceil(Math.ceil(d + d3) - d);
        return this.map.collides((int)d, (int)d2, n2, n);
    }

    public boolean collides(int n, int n2) {
        if (n < 0 || n >= this.width) {
            return true;
        }
        if (n2 < 0 || n2 >= this.height) {
            return true;
        }
        return this.map.get(n, n2);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

