/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import games.stendhal.common.tiled.LayerDefinition;
import java.awt.geom.Rectangle2D;
import java.util.BitSet;

public class CollisionMap {
    private final int width;
    private final int height;
    private final BitSet[] colls;

    public CollisionMap(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.colls = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            this.colls[i] = new BitSet();
        }
    }

    public CollisionMap(LayerDefinition layerDefinition) {
        this(layerDefinition.getWidth(), layerDefinition.getHeight());
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (layerDefinition.getTileAt(i, j) == 0) continue;
                this.set(i, j);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean get(int n, int n2) {
        return this.colls[n].get(n2);
    }

    public void set(int n, int n2) {
        this.colls[n].set(n2);
    }

    public boolean collides(int n, int n2, int n3, int n4) {
        if (n < 0 || n - 1 + n3 >= this.width) {
            return true;
        }
        if (n2 < 0 || n2 - 1 + n4 >= this.height) {
            return true;
        }
        BitSet bitSet = new BitSet();
        for (int i = n; i < n + n3; ++i) {
            bitSet.or(this.colls[i]);
        }
        return !bitSet.get(n2, n2 + n4).isEmpty();
    }

    public void clear() {
        for (int i = 0; i < this.width; ++i) {
            this.colls[i].clear();
        }
    }

    public static CollisionMap create(LayerDefinition layerDefinition) {
        CollisionMap collisionMap = new CollisionMap(layerDefinition.getWidth(), layerDefinition.getHeight());
        for (int i = 0; i < layerDefinition.getWidth(); ++i) {
            for (int j = 0; j < layerDefinition.getHeight(); ++j) {
                if (layerDefinition.getTileAt(i, j) == 0) continue;
                collisionMap.set(i, j);
            }
        }
        return collisionMap;
    }

    public void unset(int n, int n2) {
        this.colls[n].clear(n2);
    }

    public void set(Rectangle2D rectangle2D) {
        int n = (int)rectangle2D.getY();
        int n2 = (int)rectangle2D.getX();
        while ((double)n2 < rectangle2D.getX() + rectangle2D.getWidth()) {
            this.colls[n2].set(n, (int)((double)n + rectangle2D.getHeight()));
            ++n2;
        }
    }
}

