/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import games.stendhal.common.ErrorDrain;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Vector;

public class CommandlineParser {
    protected final CharacterIterator ci;

    public CommandlineParser(String string) {
        this.ci = new StringCharacterIterator(string);
    }

    public void skipWhitespace() {
        while (Character.isWhitespace(this.ci.current())) {
            this.ci.next();
        }
    }

    public String getNextParameter(ErrorDrain errorDrain) {
        this.skipWhitespace();
        char c = this.ci.current();
        StringBuilder stringBuilder = null;
        char c2 = '\uffff';
        while (c != '\uffff') {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (c == c2) {
                c2 = '\uffff';
            } else if (c2 != '\uffff') {
                stringBuilder.append(c);
            } else if (c == '\"' || c == '\'') {
                c2 = c;
            } else {
                if (Character.isWhitespace(c)) break;
                stringBuilder.append(c);
            }
            c = this.ci.next();
        }
        if (c2 != '\uffff') {
            errorDrain.setError("Unterminated quote");
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return null;
    }

    public List<String> readAllParameters(ErrorDrain errorDrain) {
        Vector<String> vector = new Vector<String>();
        do {
            this.skipWhitespace();
            String string = this.getNextParameter(errorDrain);
            if (string == null) break;
            vector.add(string);
        } while (!errorDrain.hasError());
        return vector;
    }
}

