/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

public class MathHelper {
    public static final long MILLISECONDS_IN_ONE_MINUTE = 60000L;
    public static final long MILLISECONDS_IN_ONE_HOUR = 3600000L;
    public static final long MILLISECONDS_IN_ONE_DAY = 86400000L;
    public static final long MILLISECONDS_IN_ONE_WEEK = 604800000L;
    public static final int SECONDS_IN_ONE_MINUTE = 60;
    public static final int SECONDS_IN_ONE_HOUR = 3600;
    public static final int SECONDS_IN_ONE_DAY = 86400;
    public static final int SECONDS_IN_ONE_WEEK = 604800;
    public static final int MINUTES_IN_ONE_HOUR = 60;
    public static final int MINUTES_IN_ONE_DAY = 1440;
    public static final int MINUTES_IN_ONE_WEEK = 10080;

    public static double parseDoubleDefault(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static double parseDouble(String string) {
        return MathHelper.parseDoubleDefault(string, 0.0);
    }

    public static int parseIntDefault(String string, int n) {
        int n2;
        if (string == null) {
            return n;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    public static int parseInt(String string) {
        return MathHelper.parseIntDefault(string, 0);
    }

    public static long parseLongDefault(String string, long l) {
        long l2;
        if (string == null) {
            return l;
        }
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public static long parseLong(String string) {
        return MathHelper.parseLongDefault(string, 0L);
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n, n3));
    }

    public static float clamp(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f, f3));
    }
}

