/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.grammar;

import games.stendhal.common.grammar.PrefixExtractor;
import games.stendhal.common.grammar.PrefixManager;
import games.stendhal.common.parser.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Grammar {
    private static final Logger logger = Logger.getLogger(Grammar.class);
    private static final String of = " of ";

    public static String itthem(int n) {
        if (n == 1) {
            return "it";
        }
        return "them";
    }

    public static String makeUpperCaseWord(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                stringBuilder.append(string.substring(1));
            }
        }
        return stringBuilder.toString();
    }

    public static String ItThem(int n) {
        return Grammar.makeUpperCaseWord(Grammar.itthem(n));
    }

    public static String itthey(int n) {
        if (n == 1) {
            return "it";
        }
        return "they";
    }

    public static String ItThey(int n) {
        return Grammar.makeUpperCaseWord(Grammar.itthey(n));
    }

    public static String isare(int n) {
        if (n == 1) {
            return "is";
        }
        return "are";
    }

    public static String IsAre(int n) {
        return Grammar.makeUpperCaseWord(Grammar.isare(n));
    }

    public static String hashave(int n) {
        if (n == 1) {
            return "has";
        }
        return "have";
    }

    public static String HasHave(int n) {
        return Grammar.makeUpperCaseWord(Grammar.hashave(n));
    }

    public static String thatthose(int n) {
        if (n == 1) {
            return "that";
        }
        return "those";
    }

    public static String ThatThose(int n) {
        return Grammar.makeUpperCaseWord(Grammar.thatthose(n));
    }

    public static String thisthese(int n) {
        if (n == 1) {
            return "this";
        }
        return "these";
    }

    public static String ThisThese(int n) {
        return Grammar.makeUpperCaseWord(Grammar.thisthese(n));
    }

    public static String article_noun(String string, boolean bl) {
        if (bl) {
            return "the " + string;
        }
        return Grammar.a_noun(string);
    }

    public static String a_noun(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Grammar.fullForm(string);
        return Grammar.a_an(string2) + string2;
    }

    public static String a_nounCreature(String string) {
        if (string.equals("chicken")) {
            return "a chicken";
        }
        return Grammar.a_noun(string);
    }

    private static String a_an(String string) {
        String string2 = string.toLowerCase();
        if (string2.length() == 0) {
            return "a ";
        }
        char c = string2.charAt(0);
        if (string2.length() == 1) {
            if (Grammar.isVowel(c) && c != 'u') {
                return "an ";
            }
            return "a ";
        }
        if ("eu".equals(string2.substring(0, 2))) {
            return "a ";
        }
        if (Grammar.isVowel(c)) {
            return "an ";
        }
        if (c == 'y' && Grammar.isConsonant(string2.charAt(1))) {
            return "an ";
        }
        return "a ";
    }

    static String addPrefixIfNotAlreadyThere(String string, String string2, String string3) {
        if (string.startsWith(string2)) {
            return string;
        }
        if (string.startsWith(string3)) {
            return string;
        }
        return string2 + string;
    }

    public static String fullForm(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string2.replace("#", "");
        string3 = string3.startsWith("book ") ? string3.substring(5) + " book" : (string3.indexOf(" armor") > -1 ? Grammar.addPrefixIfNotAlreadyThere(string2, "suit of ", "suits of ") : Grammar.replaceInternalByDisplayNames(PrefixManager.s_instance.fullForm(string3, string2)));
        return string3;
    }

    public static String replaceInternalByDisplayNames(String string) {
        return string.replace("icecream", "ice cream");
    }

    public static Expression mergeCompoundNoun(Expression expression, Expression expression2) {
        if (expression.getMainWord().equals("ice") && expression2.getMainWord().equals("cream") || expression.getMainWord().equals("teddy") && expression2.getMainWord().equals("bear")) {
            if (expression.getMainWord().equals("ice")) {
                expression.setNormalized("icecream");
            }
            return expression;
        }
        expression2.mergeLeft(expression, true);
        return expression2;
    }

    public static String extractNoun(String string) {
        String string2;
        if (string == null) {
            string2 = null;
        } else {
            boolean bl;
            PrefixExtractor prefixExtractor = new PrefixExtractor(string);
            do {
                bl = false;
                if (prefixExtractor.extractNounSingular()) {
                    bl = true;
                }
                if (!prefixExtractor.extractNounPlural()) continue;
                bl = true;
            } while (bl);
            string2 = prefixExtractor.toString();
        }
        return string2;
    }

    public static boolean isNormalized(String string) {
        PrefixExtractor prefixExtractor;
        boolean bl = string == null ? true : !(prefixExtractor = new PrefixExtractor(string)).extractNounSingular() && !prefixExtractor.extractNounPlural();
        return bl;
    }

    public static String A_noun(String string) {
        return Grammar.makeUpperCaseWord(Grammar.a_noun(string));
    }

    public static String suffix_s(String string) {
        char c = Character.toLowerCase(string.charAt(string.length() - 1));
        if (c == 's') {
            return string + "'";
        }
        return string + "'s";
    }

    public static String plural(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Grammar.fullForm(string);
        String string3 = "";
        int n = string2.indexOf(43);
        if (n != -1) {
            if (string2.charAt(n - 1) == ' ') {
                string3 = string2.substring(n - 1);
                string2 = string2.substring(0, n - 1);
            } else {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
        }
        if (string2.indexOf(of) > -1) {
            return Grammar.plural(string2.substring(0, string2.indexOf(of))) + string2.substring(string2.indexOf(of)) + string3;
        }
        if (string2.endsWith("money") || string2.endsWith("dice") || string2.endsWith("sheep") || string2.equals("deer") || string2.equals("moose") || string2.equals("magic")) {
            return string2 + string3;
        }
        if (string2.endsWith("staff") || string2.endsWith("chief")) {
            return string2 + "s" + string3;
        }
        if (string2.length() > 2 && string2.endsWith("f") && "aeiourl".indexOf(string2.charAt(string2.length() - 2)) > -1) {
            return string2.substring(0, string2.length() - 1) + "ves" + string3;
        }
        if (string2.endsWith("fe")) {
            return string2.substring(0, string2.length() - 2) + "ves" + string3;
        }
        if (string2.length() >= 4 && string2.endsWith("ouse") && "mMlL".indexOf(string2.charAt(string2.length() - 5)) > -1) {
            return string2.substring(0, string2.length() - 4) + "ice" + string3;
        }
        if (string2.endsWith("oose") && !string2.endsWith("caboose") && !string2.endsWith("noose")) {
            return string2.substring(0, string2.length() - 4) + "eese" + string3;
        }
        if (string2.endsWith("ooth")) {
            return string2.substring(0, string2.length() - 4) + "eeth" + string3;
        }
        if (string2.endsWith("foot")) {
            return string2.substring(0, string2.length() - 4) + "feet" + string3;
        }
        if (string2.endsWith("child")) {
            return string2 + "ren" + string3;
        }
        if (string2.endsWith("eau")) {
            return string2 + "x" + string3;
        }
        if (string2.endsWith("ato")) {
            return string2 + "es" + string3;
        }
        if (string2.endsWith("ium")) {
            return string2.substring(0, string2.length() - 2) + "a" + string3;
        }
        if (string2.endsWith("alga") || string2.endsWith("hypha") || string2.endsWith("larva")) {
            return string2 + "e" + string3;
        }
        if (string2.length() > 3 && string2.endsWith("us") && !string2.endsWith("lotus") && !string2.endsWith("wumpus")) {
            return string2.substring(0, string2.length() - 2) + "i" + string3;
        }
        if (string2.equals("oni")) {
            return string2;
        }
        if (string2.endsWith("man") && !string2.endsWith("shaman") && !string2.endsWith("human")) {
            return string2.substring(0, string2.length() - 3) + "men" + string3;
        }
        if (string2.endsWith("rtex") || string2.endsWith("index")) {
            return string2.substring(0, string2.length() - 2) + "ices" + string3;
        }
        if (string2.endsWith("trix")) {
            return string2.substring(0, string2.length() - 1) + "ces" + string3;
        }
        if (string2.endsWith("sis")) {
            return string2.substring(0, string2.length() - 2) + "es" + string3;
        }
        if (string2.endsWith("erinys")) {
            return string2.substring(0, string2.length() - 1) + "es" + string3;
        }
        if (string2.endsWith("mumak")) {
            return string2 + "il" + string3;
        }
        if (string2.endsWith("djinni") || string2.endsWith("efreeti")) {
            return string2.substring(0, string2.length() - 1) + string3;
        }
        if (string2.endsWith("porcini") || string2.endsWith("porcino")) {
            return string2.substring(0, string2.length() - 1) + "i" + string3;
        }
        if (string2.length() > 2 && string2.endsWith("y") && Grammar.isConsonant(string2.charAt(string2.length() - 2))) {
            return string2.substring(0, string2.length() - 1) + "ies" + string3;
        }
        if (!Grammar.singular(string2).equals(string2)) {
            return string2 + string3;
        }
        if (string2.endsWith("ch") || string2.endsWith("sh") || string2.length() > 1 && "sxz".indexOf(string2.charAt(string2.length() - 1)) > -1) {
            return string2 + "es" + string3;
        }
        if (string2.equals("gl\u00fcck") || string2.equals("gl\u00fccke")) {
            return "gl\u00fccke";
        }
        return string2 + "s" + string3;
    }

    public static String pluralCreature(String string) {
        if (string.equals("chicken")) {
            return "chickens";
        }
        return Grammar.plural(string);
    }

    public static String singular(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n = string.indexOf(43);
        if (n != -1) {
            string2 = string.substring(n - 1);
            string = string.substring(0, n - 1);
        }
        if (string.indexOf(of) > -1) {
            return Grammar.singular(string.substring(0, string.indexOf(of))) + string.substring(string.indexOf(of)) + string2;
        }
        if (string.endsWith("money") || string.endsWith("dice") || string.endsWith("sheep") || string.endsWith("legs") || string.endsWith("boots") || string.equals("deer") || string.equals("moose") || string.equals("magic")) {
            return string + string2;
        }
        if (string.endsWith("staffs") || string.endsWith("chiefs")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.length() > 4 && string.endsWith("ves") && "aeiourl".indexOf(string.charAt(string.length() - 4)) > -1 && !string.endsWith("knives")) {
            return string.substring(0, string.length() - 3) + "f" + string2;
        }
        if (string.endsWith("ves")) {
            return string.substring(0, string.length() - 3) + "fe" + string2;
        }
        if (string.endsWith("houses")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.length() > 3 && string.endsWith("ice") && "mMlL".indexOf(string.charAt(string.length() - 4)) > -1) {
            return string.substring(0, string.length() - 3) + "ouse" + string2;
        }
        if (string.endsWith("eese") && !string.endsWith("cabeese") && !string.endsWith("cheese")) {
            return string.substring(0, string.length() - 4) + "oose" + string2;
        }
        if (string.endsWith("eeth")) {
            return string.substring(0, string.length() - 4) + "ooth" + string2;
        }
        if (string.endsWith("feet")) {
            return string.substring(0, string.length() - 4) + "foot" + string2;
        }
        if (string.endsWith("children")) {
            return string.substring(0, string.length() - 3) + string2;
        }
        if (string.endsWith("eaux")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.endsWith("atoes")) {
            return string.substring(0, string.length() - 2) + string2;
        }
        if (string.endsWith("helia") || string.endsWith("sodia")) {
            return string.substring(0, string.length() - 1) + "um" + string2;
        }
        if (string.endsWith("algae") || string.endsWith("hyphae") || string.endsWith("larvae")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.length() > 2 && string.endsWith("ei")) {
            return string.substring(0, string.length() - 1) + "us" + string2;
        }
        if (string.endsWith("men")) {
            return string.substring(0, string.length() - 3) + "man" + string2;
        }
        if (string.endsWith("matrices")) {
            return string.substring(0, string.length() - 4) + "ix" + string2;
        }
        if (string.endsWith("ices")) {
            return string.substring(0, string.length() - 4) + "ex" + string2;
        }
        if (string.endsWith("erinyes")) {
            return string.substring(0, string.length() - 2) + "s" + string2;
        }
        if (string.endsWith("erinys") || string.endsWith("cyclops")) {
            return string + string2;
        }
        if (string.endsWith("mumakil")) {
            return string.substring(0, string.length() - 2) + string2;
        }
        if (string.endsWith("djin")) {
            return string + "ni" + string2;
        }
        if (string.endsWith("djinn") || string.endsWith("efreet")) {
            return string + "i" + string2;
        }
        if (string.endsWith("porcini") || string.endsWith("porcino")) {
            return string.substring(0, string.length() - 1) + "o" + string2;
        }
        if (string.endsWith("lotus") || string.endsWith("wumpus") || string.endsWith("deus")) {
            return string + string2;
        }
        if (string.endsWith("cabooses")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.endsWith("yses") || string.endsWith("ysis")) {
            return string.substring(0, string.length() - 2) + "is" + string2;
        }
        if (string.length() > 3 && string.endsWith("es") && ("zxs".indexOf(string.charAt(string.length() - 3)) > -1 || string.endsWith("ches") || string.endsWith("shes")) && !string.endsWith("axes") && !string.endsWith("bardiches") && !string.endsWith("nooses")) {
            return string.substring(0, string.length() - 2) + string2;
        }
        if (string.length() > 4 && string.endsWith("ies") && Grammar.isConsonant(string.charAt(string.length() - 4)) && !string.endsWith("zombies")) {
            return string.substring(0, string.length() - 3) + "y" + string2;
        }
        if (string.endsWith("s") && !string.endsWith("ss")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.equals("gl\u00fcck") || string.equals("gl\u00fccke")) {
            return "gl\u00fcck";
        }
        return string + string2;
    }

    public static String plnoun(int n, String string) {
        String string2 = Grammar.fullForm(string);
        if (n == 1) {
            return Grammar.singular(string2);
        }
        return Grammar.plural(string);
    }

    public static String plnounCreature(int n, String string) {
        if (string.equals("chicken")) {
            if (n == 1) {
                return "chicken";
            }
            return "chickens";
        }
        return Grammar.plnoun(n, string);
    }

    public static String quantityplnoun(int n, String string) {
        String string2 = Grammar.plnoun(n, string);
        return Integer.toString(n) + " " + string2;
    }

    public static String quantityplnounCreature(int n, String string) {
        if (string.equals("chicken")) {
            String string2 = Grammar.plnounCreature(n, string);
            return Integer.toString(n) + " " + string2;
        }
        return Grammar.quantityplnoun(n, string);
    }

    public static String quantityplnoun(int n, String string, String string2) {
        String string3 = Grammar.plnoun(n, string);
        if (n == 1) {
            if (string2.equals("a")) {
                return Grammar.a_noun(string3);
            }
            if (string2.equals("A")) {
                return Grammar.A_noun(string3);
            }
            if (string2.equals("")) {
                return string3;
            }
            return string2 + " " + string3;
        }
        return Integer.toString(n) + " " + Grammar.plural(string);
    }

    public static String quantityplnounWithHash(int n, String string) {
        return Grammar.quantityplnounWithMarker(n, string, '#');
    }

    public static String quantityplnounWithMarker(int n, String string, char c) {
        String string2 = Grammar.plnoun(n, string);
        String string3 = n == 1 ? Grammar.a_an(string2) : Integer.toString(n) + " ";
        StringBuilder stringBuilder = new StringBuilder(string3);
        if (string2.indexOf(32) == -1) {
            stringBuilder.append(c);
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(c);
            stringBuilder.append("'" + string2 + "'");
        }
        return stringBuilder.toString();
    }

    public static String quantityNumberStrNoun(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (n) {
            case 0: {
                stringBuilder.append("0 ");
                break;
            }
            case 1: {
                break;
            }
            default: {
                stringBuilder.append(Grammar.numberString(n)).append(' ');
            }
        }
        stringBuilder.append(Grammar.plnoun(n, string));
        return stringBuilder.toString();
    }

    protected static boolean isVowel(char c) {
        char c2 = Character.toLowerCase(c);
        return c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u';
    }

    protected static boolean isConsonant(char c) {
        return !Grammar.isVowel(c);
    }

    public static String ordered(int n) {
        switch (n) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
            case 6: {
                return "sixth";
            }
            case 7: {
                return "seventh";
            }
            case 8: {
                return "eighth";
            }
            case 9: {
                return "ninth";
            }
            case 10: {
                return "tenth";
            }
        }
        if (n > 0) {
            return n + Grammar.ordinalSuffix(n);
        }
        logger.error((Object)("Grammar.ordered not implemented for: " + n));
        return Integer.toString(n);
    }

    private static String ordinalSuffix(int n) {
        int n2 = n % 100 / 10;
        if (n2 == 1) {
            return "th";
        }
        int n3 = n % 10;
        if (n3 == 1) {
            return "st";
        }
        if (n3 == 2) {
            return "nd";
        }
        if (n3 == 3) {
            return "rd";
        }
        return "th";
    }

    public static String enumerateCollection(Collection<String> collection) {
        String string;
        if (collection == null) {
            return "";
        }
        String[] stringArray = collection.toArray(new String[collection.size()]);
        if (stringArray.length == 0) {
            string = "";
        } else if (stringArray.length == 1) {
            string = Grammar.quoteHash(stringArray[0]);
        } else if (stringArray.length == 2) {
            string = Grammar.quoteHash(stringArray[0]) + " and " + Grammar.quoteHash(stringArray[1]);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(Grammar.quoteHash(stringArray[i]) + ", ");
            }
            stringBuilder.append("and " + Grammar.quoteHash(stringArray[stringArray.length - 1]));
            string = stringBuilder.toString();
        }
        return Grammar.replaceInternalByDisplayNames(string);
    }

    public static String enumerateCollectionWithHash(Collection<String> collection) {
        if (collection == null) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add("#" + string);
        }
        return Grammar.enumerateCollection(arrayList);
    }

    public static String quoteHash(String string) {
        int n;
        if (string != null && (n = string.indexOf(35)) != -1 && string.indexOf(32, n) != -1 && string.charAt(n + 1) != '\'') {
            return string.substring(0, n) + "#'" + string.substring(n + 1) + '\'';
        }
        return string;
    }

    public static String numberString(int n) {
        switch (n) {
            case 0: {
                return "no";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "three";
            }
            case 4: {
                return "four";
            }
            case 5: {
                return "five";
            }
            case 6: {
                return "six";
            }
            case 7: {
                return "seven";
            }
            case 8: {
                return "eight";
            }
            case 9: {
                return "nine";
            }
            case 10: {
                return "ten";
            }
            case 11: {
                return "eleven";
            }
            case 12: {
                return "twelve";
            }
        }
        return Integer.toString(n);
    }

    public static Integer number(String string) {
        if (string.equals("no") || string.equals("zero")) {
            return 0;
        }
        if (string.equals("a") || string.equals("an")) {
            return 1;
        }
        if (string.equals("one")) {
            return 1;
        }
        if (string.equals("two")) {
            return 2;
        }
        if (string.equals("three")) {
            return 3;
        }
        if (string.equals("four")) {
            return 4;
        }
        if (string.equals("five")) {
            return 5;
        }
        if (string.equals("six")) {
            return 6;
        }
        if (string.equals("seven")) {
            return 7;
        }
        if (string.equals("eight")) {
            return 8;
        }
        if (string.equals("nine")) {
            return 9;
        }
        if (string.equals("ten")) {
            return 10;
        }
        if (string.equals("eleven")) {
            return 11;
        }
        if (string.equals("twelve")) {
            return 12;
        }
        return null;
    }

    public static Verb normalizeRegularVerb(String string) {
        Verb verb = null;
        if (string.length() > 4 && (string.endsWith("ed") || string.endsWith("es"))) {
            verb = string.charAt(string.length() - 4) == string.charAt(string.length() - 3) ? new Verb(string.substring(0, string.length() - 3)) : new Verb(string.substring(0, string.length() - 2));
            if (string.endsWith("ed")) {
                verb.isPast = true;
            }
        } else if (string.length() > 3 && string.endsWith("s") && !Grammar.isVowel(string.charAt(string.length() - 2))) {
            verb = new Verb(string.substring(0, string.length() - 1));
        } else if (Grammar.isGerund(string)) {
            verb = new Verb(string.substring(0, string.length() - 3));
            verb.isGerund = true;
        }
        return verb;
    }

    public static boolean isGerund(String string) {
        if (string.length() > 4 && string.endsWith("ing")) {
            int n = string.length() - 3;
            while (--n >= 0) {
                if (!Grammar.isVowel(string.charAt(n))) continue;
                return true;
            }
        }
        return false;
    }

    public static String gerundForm(String string) {
        if (string.length() > 2) {
            char c = string.charAt(string.length() - 1);
            if (c == 'y' || c == 'w') {
                return string + "ing";
            }
            if (Grammar.isVowel(c)) {
                return string.substring(0, string.length() - 1) + "ing";
            }
            if (Grammar.isVowel(string.charAt(string.length() - 2))) {
                return string + string.charAt(string.length() - 1) + "ing";
            }
        }
        return string + "ing";
    }

    public static boolean isDerivedAdjective(String string) {
        if (string.length() > 4) {
            if (string.endsWith("al") || string.endsWith("ic")) {
                return true;
            }
            if (string.endsWith("ed")) {
                return true;
            }
        }
        return false;
    }

    public static String normalizeDerivedAdjective(String string) {
        if (Grammar.isDerivedAdjective(string)) {
            return string.substring(0, string.length() - 2);
        }
        return null;
    }

    public static boolean isAmbiguousNounVerb(String string) {
        return string.equals("mill") || string.equals("fish") || string.equals("esacpe");
    }

    public static String enumerateCollectionPlural(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(Grammar.plural(string));
        }
        return Grammar.enumerateCollection(arrayList);
    }

    public static class Verb {
        public String word;
        public boolean isGerund;
        public boolean isPast;

        public Verb(String string) {
            this.word = string;
            this.isGerund = false;
            this.isPast = false;
        }

        public Verb(Verb verb) {
            this.word = verb.word;
            this.isGerund = verb.isGerund;
            this.isPast = verb.isPast;
        }
    }
}

