/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.grammar;

import games.stendhal.common.grammar.Grammar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class PrefixManager {
    public static PrefixManager s_instance = new PrefixManager();
    private Collection<String> pluralPrefixes = new HashSet<String>();
    private Collection<PrefixEntry> prefixEndList = new ArrayList<PrefixEntry>();
    private Map<String, PrefixEntry> prefixMap = new HashMap<String, PrefixEntry>();
    private Collection<String> singularPrefixes = new HashSet<String>();

    public PrefixManager() {
        this.register("piece of ", "pieces of ", "meat");
        this.register("piece of ", "pieces of ", "ham");
        this.register("piece of ", "pieces of ", "cheese");
        this.register("piece of ", "pieces of ", "wood");
        this.register("piece of ", "pieces of ", "paper");
        this.register("piece of ", "pieces of ", "iron");
        this.register("piece of ", "pieces of ", "chicken");
        this.register("piece of ", "pieces of ", "coal");
        this.register("piece of ", "pieces of ", "beeswax");
        this.register("sack of ", "sacks of ", "flour");
        this.register("sack of ", "sacks of ", "sugar");
        this.register("sheaf of ", "sheaves of ", "grain");
        this.register("loaf of ", "loaves of ", "bread");
        this.register("stick of ", "sticks of ", "butter");
        this.register("bulb of ", "bulbs of ", "garlic");
        this.register("jar of ", "jars of ", "honey");
        this.register("glass of ", "glasses of ", "wine");
        this.register("cup of ", "cups of ", "tea");
        this.register("sprig of ", "sprigs of ", "arandula");
        this.register("root of ", "roots of ", "mandragora");
        this.register("bunch of ", "bunches of ", "daisies");
        this.register("bunch of ", "bunches of ", "grapes");
        this.register("can of ", "cans of ", "oil");
        this.register("bottle of ", "bottles of ", "beer");
        this.register("bottle of ", "bottles of ", "water");
        this.register("bottle of ", "bottles of ", "fierywater");
        this.register("bottle of ", "bottles of ", "milk");
        this.register("bottle of ", "bottles of ", "holy water");
        this.registerEnd("bottle of ", "bottles of ", "potion");
        this.registerEnd("bottle of ", "bottles of ", "poison");
        this.registerEnd("bottle of ", "bottles of ", "antidote");
        this.registerEnd("nugget of ", "nuggets of ", " ore");
        this.registerEnd("pair of ", "pairs of ", " legs");
        this.registerEnd("pair of ", "pairs of ", " boots");
        this.registerEnd("spool of ", "spools of ", " thread");
        this.registerPrefix("suit of ", "suits of ");
    }

    public String fullForm(String string, String string2) {
        String string3 = string2;
        PrefixEntry prefixEntry = this.prefixMap.get(string);
        if (prefixEntry != null) {
            string3 = prefixEntry.prefixSingular + string3;
        } else {
            for (PrefixEntry prefixEntry2 : this.prefixEndList) {
                if (!string.endsWith(prefixEntry2.keyword)) continue;
                string3 = Grammar.addPrefixIfNotAlreadyThere(string3, prefixEntry2.prefixSingular, prefixEntry2.prefixPlural);
                break;
            }
        }
        return string3;
    }

    public Collection<String> getPluralPrefixes() {
        return this.pluralPrefixes;
    }

    public Collection<String> getSingularPrefixes() {
        return this.singularPrefixes;
    }

    private void register(String string, String string2, String string3) {
        this.prefixMap.put(string3, new PrefixEntry(string3, string, string2));
        this.registerPrefix(string, string2);
    }

    private void registerEnd(String string, String string2, String string3) {
        this.prefixEndList.add(new PrefixEntry(string3, string, string2));
        this.registerPrefix(string, string2);
    }

    private void registerPrefix(String string, String string2) {
        this.singularPrefixes.add(string);
        this.pluralPrefixes.add(string2);
    }

    private static class PrefixEntry {
        public final String keyword;
        public final String prefixPlural;
        public final String prefixSingular;

        public PrefixEntry(String string, String string2, String string3) {
            this.keyword = string;
            this.prefixSingular = string2;
            this.prefixPlural = string3;
        }
    }
}

