/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.parser.ExpressionMatcher;

public class SimilarExprMatcher
extends ExpressionMatcher {
    public SimilarExprMatcher() {
        this.similarMatching = true;
    }

    public static boolean isSimilar(String string, String string2, double d) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        int n = string.length();
        int n2 = string2.length();
        if (n == 0 || n2 == 0) {
            return n == n2;
        }
        int n3 = Math.min(n, n2);
        int n4 = (int)(((double)n3 * d * (double)n3 + (double)(n3 - 1)) / (double)n3);
        return SimilarExprMatcher.compareLevenshtein(string, string2, n4);
    }

    private static boolean compareLevenshtein(String string, String string2, int n) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (n < 1) {
            return false;
        }
        int n2 = SimilarExprMatcher.limitedLevenshtein(string.toLowerCase(), string2.toLowerCase(), 0, 0, n);
        return n2 <= n;
    }

    private static int limitedLevenshtein(String string, String string2, int n, int n2, int n3) {
        while (n != string.length()) {
            if (n2 == string2.length()) {
                return string.length() - n;
            }
            if (string.charAt(n) != string2.charAt(n2)) {
                if (n3 < 1) {
                    return 1;
                }
                return 1 + SimilarExprMatcher.bestLimLev(string, string2, n, n2, n3 - 1);
            }
            ++n;
            ++n2;
        }
        return string2.length() - n2;
    }

    private static int bestLimLev(String string, String string2, int n, int n2, int n3) {
        int n4 = SimilarExprMatcher.limitedLevenshtein(string, string2, n + 1, n2 + 1, n3);
        if (n4 == 0) {
            return 0;
        }
        int n5 = SimilarExprMatcher.limitedLevenshtein(string, string2, n + 1, n2, n3);
        if (n5 == 0) {
            return 0;
        }
        int n6 = SimilarExprMatcher.limitedLevenshtein(string, string2, n, n2 + 1, n3);
        return SimilarExprMatcher.min(n4, n5, n6);
    }

    private static int min(int n, int n2, int n3) {
        int n4 = n;
        if (n2 < n4) {
            n4 = n2;
        }
        if (n3 < n4) {
            n4 = n3;
        }
        return n4;
    }
}

