/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.grammar.Grammar;
import games.stendhal.common.parser.ArrayLengthDescSorter;
import games.stendhal.common.parser.CompoundName;
import games.stendhal.common.parser.ConversationContext;
import games.stendhal.common.parser.ConversationParser;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.ExpressionType;
import games.stendhal.common.parser.Sentence;
import games.stendhal.common.parser.WordEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import marauroa.common.Log4J;
import marauroa.common.io.UnicodeSupportingInputStreamReader;
import org.apache.log4j.Logger;

public final class WordList {
    private static final Logger logger = Logger.getLogger(WordList.class);
    public static final String SUBJECT_NAME_DYNAMIC = "SUB-NAM-DYN";
    public static final String VERB_DYNAMIC = "VER-DYN";
    public static final String WORDS_FILENAME = "words.txt";
    private Map<String, WordEntry> words = new TreeMap<String, WordEntry>();
    private Map<String, Set<CompoundName>> compoundNames = new HashMap<String, Set<CompoundName>>();
    private Map<String, Integer> subjectRefCount = new HashMap<String, Integer>();
    private static WordList instance;

    private static void initInstance() {
        instance = new WordList();
        instance.readFromResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromResources() {
        InputStream inputStream = WordList.class.getResourceAsStream(WORDS_FILENAME);
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader((Reader)new UnicodeSupportingInputStreamReader(inputStream, "UTF-8"));
                try {
                    this.read(bufferedReader, null);
                }
                catch (IOException iOException) {
                    logger.error((Object)"error while reading resource file 'words.txt'", (Throwable)iOException);
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        logger.error((Object)"error while closing reader stream for 'words.txt'", (Throwable)iOException);
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn((Object)"exception on closing resource stream", (Throwable)iOException);
                }
            }
        } else {
            logger.error((Object)"unable to locate resource file 'words.txt'");
        }
    }

    public static WordList getInstance() {
        return instance;
    }

    public void read(BufferedReader bufferedReader, List<String> list) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) {
                if (list == null) continue;
                list.add(string);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            string2 = WordList.trimWord(string2);
            WordEntry wordEntry = new WordEntry();
            wordEntry.setNormalized(string2);
            this.readEntryLine(string2, stringTokenizer, wordEntry);
            this.addEntry(string2, wordEntry);
        }
    }

    private void readEntryLine(String string, StringTokenizer stringTokenizer, WordEntry wordEntry) {
        if (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            wordEntry.setType(new ExpressionType(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.charAt(0) == '=') {
                    wordEntry.setNormalized(WordList.trimWord(string3.substring(1)));
                    string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                }
                if (string3 != null) {
                    if (wordEntry.isNumeral()) {
                        wordEntry.setValue(Integer.valueOf(string3));
                    } else {
                        wordEntry.setPlurSing(string3);
                    }
                }
            }
            string3 = wordEntry.getNormalized();
            if (Character.isLowerCase(wordEntry.getTypeString().charAt(0))) {
                wordEntry.setType(new ExpressionType("OBJ"));
                wordEntry.setPlurSing(WordList.trimWord(wordEntry.getTypeString()));
            } else if (wordEntry.getPlurSing() == null && wordEntry.isObject()) {
                string2 = Grammar.plural(string3);
                if (string2.indexOf(32) == -1) {
                    wordEntry.setPlurSing(string2);
                }
            } else if (!(wordEntry.getPlurSing() == null || wordEntry.isPronoun() || wordEntry.isObsessional() || string3.equals("is") || (string2 = Grammar.plural(string)).indexOf(32) != -1 || string2.equals(wordEntry.getPlurSing()) || (string2 = Grammar.plural(string3)).indexOf(32) != -1 || string2.equals(wordEntry.getPlurSing()))) {
                logger.warn((Object)String.format("suspicious plural: %s -> %s (%s?)", string, wordEntry.getPlurSing(), string2));
            }
            while (stringTokenizer.hasMoreTokens()) {
                logger.warn((Object)("superfluous trailing word in words.txt: " + stringTokenizer.nextToken()));
            }
        }
    }

    private void addEntry(String string, WordEntry wordEntry) {
        this.words.put(WordList.trimWord(string), wordEntry);
        if (wordEntry.getPlurSing() != null && !wordEntry.getPlurSing().equals(wordEntry.getNormalized())) {
            WordEntry wordEntry2 = new WordEntry();
            wordEntry2.setNormalized(wordEntry.getPlurSing());
            wordEntry2.setType(new ExpressionType(wordEntry.getTypeString() + "-PLU"));
            wordEntry2.setPlurSing(wordEntry.getNormalized());
            wordEntry2.setValue(wordEntry.getValue());
            WordEntry wordEntry3 = this.words.put(wordEntry.getPlurSing(), wordEntry2);
            if (wordEntry3 != null) {
                logger.debug((Object)String.format("ambiguous plural: %s/%s -> %s", wordEntry2.getPlurSing(), wordEntry3.getPlurSing(), wordEntry.getPlurSing()));
                wordEntry2.setPlurSing(null);
                wordEntry3.setPlurSing(null);
            }
        }
    }

    public void printWordType(PrintWriter printWriter, String string) {
        for (Map.Entry<String, WordEntry> entry : this.words.entrySet()) {
            boolean bl;
            WordEntry wordEntry = entry.getValue();
            if (string == null) {
                bl = wordEntry.getType() == null;
            } else {
                boolean bl2 = bl = wordEntry.getTypeString().startsWith(string) && !wordEntry.isPlural();
            }
            if (!bl) continue;
            wordEntry.print(printWriter, entry.getKey());
            printWriter.println();
        }
    }

    public static String trimWord(String string) {
        char c;
        String string2 = string.toLowerCase();
        while (string2.length() > 0 && (c = string2.charAt(0)) == '\'') {
            string2 = string2.substring(1);
        }
        while (string2.length() > 0 && (c = string2.charAt(string2.length() - 1)) == '\'') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public WordEntry find(String string) {
        WordEntry wordEntry = this.words.get(WordList.trimWord(string));
        return wordEntry;
    }

    public String plural(String string) {
        WordEntry wordEntry = this.words.get(WordList.trimWord(string));
        if (wordEntry != null) {
            if (wordEntry.getType() != null && !wordEntry.getType().isPlural()) {
                return wordEntry.getPlurSing();
            }
            return wordEntry.getNormalized();
        }
        return Grammar.plural(string);
    }

    public String singular(String string) {
        WordEntry wordEntry = this.words.get(WordList.trimWord(string));
        if (wordEntry != null) {
            if (wordEntry.isPlural()) {
                return wordEntry.getPlurSing();
            }
            return wordEntry.getNormalized();
        }
        return Grammar.singular(string);
    }

    Verb normalizeVerb(String string) {
        String string2 = WordList.trimWord(string);
        Grammar.Verb verb = Grammar.normalizeRegularVerb(string2);
        if (verb != null) {
            WordEntry wordEntry = this.words.get(verb.word);
            if (wordEntry == null && string2.endsWith("e") && !verb.word.endsWith("e")) {
                wordEntry = this.words.get(verb.word + "e");
            }
            if (wordEntry != null) {
                return new Verb(verb, wordEntry);
            }
        }
        return null;
    }

    WordEntry normalizeAdjective(String string) {
        String string2 = WordList.trimWord(string);
        String string3 = Grammar.normalizeDerivedAdjective(string2);
        if (string3 != null) {
            WordEntry wordEntry = this.words.get(string3);
            return wordEntry;
        }
        return null;
    }

    public void registerSubjectName(String string) {
        this.registerSubjectName(string, "SUB-NAM");
    }

    public void registerSubjectName(String string, String string2) {
        String string3 = WordList.trimWord(string);
        Integer n = this.subjectRefCount.get(string3);
        if (n != null && n > 0) {
            n = n + 1;
            this.subjectRefCount.put(string3, n);
            return;
        }
        if (n == null) {
            this.registerName(string, string2);
            this.subjectRefCount.put(string3, 1);
        }
    }

    public void unregisterSubjectName(String string) {
        Integer n;
        String string2 = WordList.trimWord(string);
        WordEntry wordEntry = this.words.get(string2);
        if (wordEntry != null && wordEntry.isName() && wordEntry.isDynamic() && (n = this.subjectRefCount.get(string2)) != null) {
            n = n - 1;
            this.subjectRefCount.put(string2, n);
            if (n == 0) {
                this.subjectRefCount.remove(string2);
                this.unregisterName(string);
            }
        }
    }

    public void registerName(String string, String string2) {
        Set<CompoundName> set;
        ConversationContext conversationContext = new ConversationContext();
        conversationContext.setMergeExpressions(false);
        Sentence sentence = ConversationParser.parse(string, conversationContext);
        Object object = null;
        boolean bl = false;
        for (Object object2 : sentence) {
            if (((Expression)object2).getType() == null || ((Expression)object2).getType().isEmpty()) {
                set = this.words.get(((Expression)object2).getNormalized());
                ExpressionType expressionType = new ExpressionType(string2 + "-DYN");
                ((WordEntry)((Object)set)).setType(expressionType);
                ((Expression)object2).setType(expressionType);
            } else if (((Expression)object2).isQuestion()) {
                logger.warn((Object)("name already registered with incompatible expression type while registering name '" + string + "': " + ((Expression)object2).getNormalizedWithTypeString() + " expected type: " + string2));
            }
            if (((Expression)object2).isPreposition()) {
                bl = true;
                continue;
            }
            if (bl) continue;
            object = object2;
        }
        if (object != null && !WordList.isNameCompatibleLastType(object, string2) && !string2.startsWith("SUB")) {
            logger.warn((Object)("last word of name '" + string + "' has an unexpected type: " + ((Expression)object).getNormalizedWithTypeString() + " expected type: " + string2));
        }
        if (sentence.getExpressions().size() > 1) {
            Object object2;
            Expression expression = sentence.expressions.get(0);
            object2 = expression.getOriginal().toLowerCase();
            set = this.compoundNames.get(object2);
            if (set == null) {
                set = new HashSet<CompoundName>();
                this.compoundNames.put((String)object2, set);
            }
            set.add(new CompoundName(sentence, string2));
        }
    }

    public CompoundName searchCompoundName(AbstractList<Expression> abstractList, int n) {
        Expression expression = abstractList.get(n);
        Set<CompoundName> set = this.compoundNames.get(expression.getOriginal().toLowerCase());
        if (set != null) {
            TreeSet treeSet = new TreeSet(new ArrayLengthDescSorter());
            treeSet.addAll(set);
            for (CompoundName compoundName : treeSet) {
                if (!compoundName.matches(abstractList, n)) continue;
                return compoundName;
            }
        }
        return null;
    }

    private void unregisterName(String string) {
        Object object;
        String object22;
        Set<CompoundName> set;
        ConversationContext conversationContext = new ConversationContext();
        conversationContext.setMergeExpressions(false);
        Sentence sentence = ConversationParser.parse(string, conversationContext);
        if (sentence.expressions.size() > 1 && (set = this.compoundNames.get(object22 = ((Expression)(object = sentence.expressions.get(0))).getOriginal().toLowerCase())) != null) {
            for (CompoundName compoundName : set) {
                if (!compoundName.matches(sentence.expressions, 0)) continue;
                set.remove(compoundName);
                if (!set.isEmpty()) break;
                this.compoundNames.remove(object22);
                break;
            }
        }
        for (Expression expression : sentence.expressions) {
            if (!expression.isDynamic()) continue;
            this.words.remove(expression.getNormalized());
        }
    }

    private static boolean isNameCompatibleLastType(Expression expression, String string) {
        ExpressionType expressionType = expression.getType();
        if (expressionType.getTypeString().startsWith(string)) {
            return true;
        }
        if (string.startsWith(expressionType.getTypeString())) {
            return true;
        }
        if (expressionType.isNumeral()) {
            return true;
        }
        if (expressionType.isDynamic()) {
            return true;
        }
        if (expressionType.isObject() && string.startsWith("SUB")) {
            return true;
        }
        if (expressionType.isSubject() && string.startsWith("OBJ")) {
            return true;
        }
        if (Grammar.isAmbiguousNounVerb(expression.getNormalized())) {
            if (expressionType.isVerb() && string.equals("OBJ")) {
                return true;
            }
            if (expressionType.isObject() && string.equals("VER")) {
                return true;
            }
        }
        return false;
    }

    public void registerVerb(String string) {
        String string2 = WordList.trimWord(string);
        WordEntry wordEntry = this.words.get(string2);
        if (wordEntry == null || wordEntry.getType() == null || wordEntry.getType().isEmpty()) {
            WordEntry wordEntry2 = new WordEntry();
            wordEntry2.setNormalized(string2);
            wordEntry2.setType(new ExpressionType(VERB_DYNAMIC));
            this.words.put(string2, wordEntry2);
        }
    }

    public WordEntry addNewWord(String string) {
        String string2 = WordList.trimWord(string);
        WordEntry wordEntry = this.words.get(string2);
        if (wordEntry == null) {
            wordEntry = new WordEntry();
            wordEntry.setType(new ExpressionType(""));
            wordEntry.setNormalized(string2);
            this.words.put(string2, wordEntry);
        } else {
            logger.warn((Object)("word already known: " + string + " -> " + wordEntry.getNormalized()));
        }
        return wordEntry;
    }

    public int getWordCount() {
        return this.words.size();
    }

    static {
        Log4J.init();
        WordList.initInstance();
    }

    static class Verb
    extends Grammar.Verb {
        public WordEntry entry;

        public Verb(Grammar.Verb verb, WordEntry wordEntry) {
            super(verb);
            assert (wordEntry != null);
            this.entry = wordEntry;
        }
    }
}

