/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.report;

import edu.xtec.jclic.report.ActivityData;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SessionData
implements Serializable {
    public String id;
    public Date date;
    public String project;
    public int numActs;
    public int actsSolved;
    public int totalPrec;
    public int totalTime;
    public int sessionCount;
    public Set<String> users;
    public List<ActivityData> actData;

    public SessionData(String id, String usr, String project, Date date, int numActs, int actsSolved, int totalPrec, int totalTime) {
        this.id = id != null ? id.trim() : null;
        this.users = new HashSet<String>(1);
        this.users.add(usr != null ? usr.trim() : null);
        this.project = project != null ? project.trim() : null;
        this.date = date;
        this.numActs = numActs;
        this.actsSolved = actsSolved;
        this.totalPrec = totalPrec;
        this.totalTime = Math.max(0, totalTime);
        this.sessionCount = 1;
    }

    public void acumula(SessionData d) {
        this.actsSolved += d.actsSolved;
        this.totalPrec += d.totalPrec;
        this.numActs += d.numActs;
        this.totalTime += d.totalTime;
        this.users.addAll(d.users);
        if (this.project != null && !this.project.equals(d.project)) {
            this.project = "";
        }
        this.id = "";
        this.sessionCount += d.sessionCount;
        if (this.actData == null) {
            this.actData = d.actData;
        } else if (d.actData != null) {
            this.actData.addAll(d.actData);
        }
    }

    public boolean sameDate(SessionData d) {
        return this.date != null && d != null && this.date.equals(d.date);
    }

    public int percentSolved() {
        return this.numActs > 0 ? 100 * this.actsSolved / this.numActs : 0;
    }

    public int percentPrec() {
        return this.numActs > 0 ? this.totalPrec / this.numActs : 0;
    }

    public String getUsr() {
        String result = "";
        if (this.users.size() > 1) {
            result = "*";
        } else {
            Iterator<String> it = this.users.iterator();
            if (it.hasNext()) {
                result = it.next();
            }
        }
        return result;
    }
}

