/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.servlet;

import edu.xtec.jclic.report.ReportUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public abstract class RequestProcessor {
    public static final String REDIRECT = "REDIRECT";
    public static final String CONTENT_TYPE = "CONTENT_TYPE";
    public static final String CONTENT_LENGTH = "CONTENT_LENGTH";
    public static final String COOKIE = "COOKIE";
    public static final String EXTRA = "EXTRA";
    public static final String ERROR = "ERROR";
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final String CHARSET = "ISO-8859-1";
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, Object> cookies = new HashMap<String, Object>();
    private Map<String, Object> headers = new HashMap<String, Object>();
    private InputStream inputStream = null;
    public int errCode = -1;
    public String errMsg = null;
    private static boolean DIRECT_RESOURCES;
    protected static Map<String, Object> properties;
    private static SimpleDateFormat HTTP_DF;

    public static void config(Map<String, Object> prop) {
        if (prop != null) {
            properties.putAll(prop);
        }
    }

    public boolean init() throws Exception {
        return true;
    }

    public boolean usesWriter() {
        return true;
    }

    public boolean noCache() {
        return true;
    }

    public void process(OutputStream out) throws Exception {
    }

    public void process(PrintWriter out) throws Exception {
        this.startHead(out);
        this.head(out);
        this.endHead(out);
        this.startBody(out);
        this.body(out);
        this.endBody(out);
    }

    public void header(List<String[]> v) {
        if (this.cookies.size() > 0) {
            for (String key : this.cookies.keySet()) {
                String value = (String)this.cookies.get(key);
                v.add(new String[]{COOKIE, key, value});
            }
        }
    }

    public void end() {
    }

    public boolean wantsInputStream() {
        return false;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public int getIntParam(String name, int defaultValue) {
        int result = defaultValue;
        String s = this.getParam(name);
        if (s != null) {
            try {
                result = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public Date getDateParam(String name, Date defaultValue, boolean atMidnight) {
        Date result = defaultValue;
        String s = this.getParam(name);
        if (s != null) {
            try {
                result = ReportUtils.strToDate(s, atMidnight);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public String getParamNotNull(String name) {
        String result = this.getParam(name, 0);
        if (result == null) {
            result = "";
        }
        return result.trim();
    }

    public String getParam(String name) {
        return this.getParam(name, 0);
    }

    public Object[] getParams(String name) {
        return (Object[])this.params.get(name);
    }

    public String getParam(String name, int index) {
        String result = null;
        Object[] array = (Object[])this.params.get(name);
        if (index >= 0 && array != null && array.length > index) {
            result = (String)array[index];
        }
        return result;
    }

    public void setParam(String name, String value) {
        this.params.put(name, new String[]{value});
    }

    public void setParam(String name, String[] value) {
        this.params.put(name, value);
    }

    public void setParams(Map<String, Object> map) {
        if (map != null) {
            for (String s : map.keySet()) {
                Object val = map.get(s);
                if (s == null) continue;
                if (val instanceof String) {
                    this.setParam(s.toString(), (String)val);
                    continue;
                }
                if (!(val instanceof String[])) continue;
                this.setParam(s.toString(), (String[])val);
            }
        }
    }

    public String getCookie(String name) {
        return (String)this.cookies.get(name);
    }

    public void setCookie(String name, String value) {
        this.cookies.put(name, value);
    }

    public void setCookies(Map<String, Object> map) {
        this.cookies.putAll(map);
    }

    public void setHeaders(Map<String, Object> map) {
        this.headers.putAll(map);
    }

    public Vector getHeaders(String headerName) {
        return (Vector)this.headers.get(headerName.toLowerCase());
    }

    public String getHeader(String headerName) {
        String result = null;
        Vector v = this.getHeaders(headerName);
        if (v != null && !v.isEmpty()) {
            result = (String)v.get(0);
        }
        return result;
    }

    protected void startHead(PrintWriter out) {
        out.println("<html>");
        out.println("<head>");
        out.print("<meta http-equiv=\"Content-Type\" content=\"text/html; ");
        out.print(CHARSET);
        out.println("\">");
    }

    protected void head(PrintWriter out) throws Exception {
    }

    protected void endHead(PrintWriter out) {
        out.println("</head>");
    }

    protected void linkStyle(String fileScreen, String filePrint, PrintWriter out) {
        StringBuilder sb = new StringBuilder();
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        sb.append(fileScreen);
        if (filePrint != null) {
            sb.append("\" media=\"screen\">\n");
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            sb.append(filePrint).append("\" media=\"print\">");
        } else {
            sb.append("\">");
        }
        out.println(sb.substring(0));
    }

    protected void linkScript(String file, PrintWriter out) {
        out.print("<script language=\"JavaScript\" src=\"");
        out.print(file);
        out.println("\" type=\"text/javascript\"></script>");
    }

    protected void writeScript(String text, PrintWriter out) {
        out.println("<script language=\"JavaScript\" type=\"text/javascript\">");
        out.println("<!--");
        out.println(text);
        out.println("// -->");
        out.println("</script>");
    }

    protected void title(String prefix, String title, PrintWriter out) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("<title>");
        if (prefix != null) {
            sb.append(RequestProcessor.filter(prefix)).append(" - ");
        }
        sb.append(RequestProcessor.filter(title));
        sb.append("</title>");
        out.println(sb.substring(0));
    }

    protected void startBody(PrintWriter out) {
        out.println("<body>");
    }

    protected void body(PrintWriter out) throws Exception {
    }

    protected void endBody(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    public static String filter(String input) {
        String result;
        String string = result = input == null ? "" : input;
        if (input != null && input.length() > 0) {
            StringBuilder filtered = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                String s = null;
                switch (c) {
                    case '<': {
                        s = "&lt;";
                        break;
                    }
                    case '>': {
                        s = "&gt;";
                        break;
                    }
                    case '\"': {
                        s = "&quot;";
                        break;
                    }
                    case '&': {
                        s = "&amp;";
                    }
                }
                if (s != null) {
                    filtered.append(s);
                    continue;
                }
                filtered.append(c);
            }
            result = filtered.substring(0);
        }
        return result;
    }

    public static String escape(String input) {
        String result = input;
        if (input != null && input.length() > 0) {
            StringBuilder filtered = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                String s = null;
                switch (c) {
                    case '\'': {
                        s = "\\'";
                        break;
                    }
                    case '\\': {
                        s = "\\\\";
                    }
                }
                if (s != null) {
                    filtered.append(s);
                    continue;
                }
                filtered.append(c);
            }
            result = filtered.substring(0);
        }
        return result;
    }

    public static String toNbsp(String src) {
        StringTokenizer st;
        StringBuilder sb = new StringBuilder(src == null ? 0 : src.length() * 2);
        if (src != null && (st = new StringTokenizer(src)).hasMoreTokens()) {
            while (true) {
                sb.append(st.nextToken());
                if (!st.hasMoreTokens()) break;
                sb.append("&nbsp;");
            }
        }
        return sb.substring(0);
    }

    public static void setDirectResources(boolean v) {
        DIRECT_RESOURCES = v;
    }

    protected static String resourceUrl(String resource) {
        String result = resource;
        if (!DIRECT_RESOURCES) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("resource?id=").append(resource);
            result = sb.substring(0);
        }
        return result;
    }

    public static String httpDate(Date date) {
        if (HTTP_DF == null) {
            HTTP_DF = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            HTTP_DF.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return HTTP_DF.format(date);
    }

    static {
        properties = new HashMap<String, Object>();
    }
}

