/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.Order;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OrderTypePanel
extends JPanel {
    Options options;
    protected static final Map<Options, OrderTypePanel> panels = new HashMap<Options, OrderTypePanel>(1);
    private JRadioButton orderWordsBtn;
    private JCheckBox amongstParChk;
    private ButtonGroup bGroup;
    private JRadioButton orderParagraphsBtn;

    public OrderTypePanel(Options options) {
        this.options = options;
        this.initComponents();
    }

    private void initComponents() {
        this.bGroup = new ButtonGroup();
        this.orderParagraphsBtn = new JRadioButton();
        this.orderWordsBtn = new JRadioButton();
        this.amongstParChk = new JCheckBox();
        this.setLayout(new BoxLayout(this, 1));
        this.orderParagraphsBtn.setText(this.options.getMsg("edit_text_act_orderParagraphs"));
        this.bGroup.add(this.orderParagraphsBtn);
        this.orderParagraphsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderTypePanel.this.orderParagraphsBtnActionPerformed(evt);
            }
        });
        this.add(this.orderParagraphsBtn);
        this.orderWordsBtn.setText(this.options.getMsg("edit_text_act_orderWords"));
        this.bGroup.add(this.orderWordsBtn);
        this.orderWordsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderTypePanel.this.orderWordsBtnActionPerformed(evt);
            }
        });
        this.add(this.orderWordsBtn);
        this.amongstParChk.setText(this.options.getMsg("edit_text_act_order_amongstPar"));
        this.amongstParChk.setEnabled(false);
        this.add(this.amongstParChk);
    }

    private void orderParagraphsBtnActionPerformed(ActionEvent evt) {
        this.amongstParChk.setEnabled(!this.orderParagraphsBtn.isSelected());
    }

    private void orderWordsBtnActionPerformed(ActionEvent evt) {
        this.amongstParChk.setEnabled(this.orderWordsBtn.isSelected());
    }

    public static boolean editOrder(Order ord, Options options, Component parent) {
        OrderTypePanel otp = panels.get(options);
        if (otp == null) {
            otp = new OrderTypePanel(options);
            panels.put(options, otp);
        }
        boolean p = ord.type == 1;
        otp.orderParagraphsBtn.setSelected(p);
        otp.orderWordsBtn.setSelected(!p);
        otp.amongstParChk.setSelected(ord.amongParagraphs);
        otp.amongstParChk.setEnabled(!p);
        boolean result = options.getMessages().showInputDlg(parent, otp, "edit_text_act_type_title");
        if (result) {
            ord.type = otp.orderParagraphsBtn.isSelected() ? 1 : 0;
            ord.amongParagraphs = otp.amongstParChk.isSelected();
        }
        return result;
    }
}

