/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.text;

import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Options;
import edu.xtec.util.StreamIO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextStyleEditorPanel
extends JPanel
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    Options options;
    StyleContext sc;
    private static StyleContext emptySc;
    private ColorButton bgColorBtn;
    private JToggleButton boldBtn;
    private ColorButton errorBgColor;
    private ColorButton errorFgColor;
    private JComboBox fontFaceCombo;
    private JComboBox fontSizeCombo;
    private JToggleButton italicBtn;
    private JTextPane previewPanel;
    private JSlider tabSlider;
    private ColorButton targetBgColor;
    private ColorButton targetFgColor;
    private ColorButton textColorBtn;
    private JToggleButton underlineBtn;
    private static Map<Options, TextStyleEditorPanel> panels;

    public TextStyleEditorPanel(Options options, StyleContext sc) {
        this.options = options;
        this.initComponents();
        this.setStyleContext(sc);
    }

    private void initComponents() {
        JLabel mainLb = new JLabel();
        this.fontFaceCombo = new JComboBox<String>(FontCheck.getFontList(false));
        this.fontSizeCombo = new JComboBox<String>(FontCheck.fontSizes);
        this.boldBtn = new JToggleButton();
        this.italicBtn = new JToggleButton();
        this.underlineBtn = new JToggleButton();
        JLabel colorsLb = new JLabel();
        JLabel textColorLb = new JLabel();
        this.textColorBtn = new ColorButton();
        this.textColorBtn.setOptions(this.options);
        JLabel bgColorLb = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        JLabel tabLb = new JLabel();
        this.tabSlider = new JSlider();
        JLabel targetLb = new JLabel();
        JLabel targetFgLb = new JLabel();
        this.targetFgColor = new ColorButton();
        this.targetFgColor.setOptions(this.options);
        JLabel targetBgLb = new JLabel();
        this.targetBgColor = new ColorButton();
        this.targetBgColor.setOptions(this.options);
        JLabel errorLb = new JLabel();
        JLabel errorFgLb = new JLabel();
        this.errorFgColor = new ColorButton();
        this.errorFgColor.setOptions(this.options);
        JLabel errorBgLb = new JLabel();
        this.errorBgColor = new ColorButton();
        this.errorBgColor.setOptions(this.options);
        JPanel previewFrame = new JPanel();
        JScrollPane previewScroll = new JScrollPane();
        this.previewPanel = new JTextPane();
        this.setLayout(new GridBagLayout());
        mainLb.setText(this.options.getMsg("edit_text_act_mainStyle"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)mainLb, gridBagConstraints);
        this.fontFaceCombo.setEditable(true);
        this.fontFaceCombo.setPreferredSize(new Dimension(125, this.fontFaceCombo.getPreferredSize().height));
        this.fontFaceCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fontFaceCombo, gridBagConstraints);
        this.fontSizeCombo.setEditable(true);
        this.fontSizeCombo.setPreferredSize(new Dimension(50, this.fontSizeCombo.getPreferredSize().height));
        this.fontSizeCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.boldBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        this.boldBtn.setToolTipText(this.options.getMsg("edit_font_bold"));
        this.boldBtn.setPreferredSize(new Dimension(27, 27));
        this.boldBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)this.boldBtn, gridBagConstraints);
        this.italicBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        this.italicBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.italicBtn.setPreferredSize(new Dimension(27, 27));
        this.italicBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.italicBtn, gridBagConstraints);
        this.underlineBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_underline.gif")));
        this.underlineBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.underlineBtn.setPreferredSize(new Dimension(27, 27));
        this.underlineBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.underlineBtn, gridBagConstraints);
        colorsLb.setText(this.options.getMsg("edit_text_act_colors"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)colorsLb, gridBagConstraints);
        textColorLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        textColorLb.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)textColorLb, gridBagConstraints);
        this.textColorBtn.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.textColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textColorBtn, gridBagConstraints);
        bgColorLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        bgColorLb.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)bgColorLb, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.bgColorBtn, gridBagConstraints);
        tabLb.setText(this.options.getMsg("edit_text_act_tabSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)tabLb, gridBagConstraints);
        this.tabSlider.setMinorTickSpacing(5);
        this.tabSlider.setPaintLabels(true);
        this.tabSlider.setPaintTicks(true);
        this.tabSlider.setMajorTickSpacing(10);
        this.tabSlider.setMaximum(50);
        this.tabSlider.setValue(12);
        this.tabSlider.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.tabSlider, gridBagConstraints);
        targetLb.setText(this.options.getMsg("edit_text_act_targetStyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)targetLb, gridBagConstraints);
        targetFgLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        targetFgLb.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)targetFgLb, gridBagConstraints);
        this.targetFgColor.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.targetFgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.targetFgColor, gridBagConstraints);
        targetBgLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        targetBgLb.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)targetBgLb, gridBagConstraints);
        this.targetBgColor.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.targetBgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.targetBgColor, gridBagConstraints);
        errorLb.setText(this.options.getMsg("edit_text_act_errorStyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)errorLb, gridBagConstraints);
        errorFgLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/fg.gif")));
        errorFgLb.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)errorFgLb, gridBagConstraints);
        this.errorFgColor.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.errorFgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.errorFgColor, gridBagConstraints);
        errorBgLb.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/bg.gif")));
        errorBgLb.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.add((Component)errorBgLb, gridBagConstraints);
        this.errorBgColor.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.errorBgColor.addPropertyChangeListener("color", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.add((Component)this.errorBgColor, gridBagConstraints);
        previewFrame.setLayout(new BorderLayout());
        previewFrame.setBorder(new TitledBorder(this.options.getMsg("edit_text_act_preview")));
        previewScroll.setPreferredSize(new Dimension(300, 100));
        this.previewPanel.setEditable(false);
        previewScroll.setViewportView(this.previewPanel);
        previewFrame.add((Component)previewScroll, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)previewFrame, gridBagConstraints);
    }

    private static StyleContext getEmptySc() {
        if (emptySc == null) {
            emptySc = new StyleContext();
            TextActivityDocument.checkStyleContext(emptySc);
        }
        return emptySc;
    }

    public final void setStyleContext(StyleContext styleContext) {
        this.sc = styleContext == null ? TextStyleEditorPanel.getEmptySc() : styleContext;
        TextActivityDocument.checkStyleContext(this.sc);
        Style defaultStyle = this.sc.getStyle("default");
        this.fontFaceCombo.setSelectedItem(StyleConstants.getFontFamily(defaultStyle));
        this.fontSizeCombo.setSelectedItem(Integer.toString(StyleConstants.getFontSize(defaultStyle)));
        this.boldBtn.setSelected(StyleConstants.isBold(defaultStyle));
        this.italicBtn.setSelected(StyleConstants.isItalic(defaultStyle));
        this.underlineBtn.setSelected(StyleConstants.isUnderline(defaultStyle));
        this.bgColorBtn.setColor(StyleConstants.getBackground(defaultStyle));
        this.textColorBtn.setColor(StyleConstants.getForeground(defaultStyle));
        int tabSpc = 12;
        Object o = defaultStyle.getAttribute("tabWidth");
        if (o != null) {
            try {
                tabSpc = Math.max(1, Math.min(Integer.parseInt(o.toString()), 50));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tabSlider.setValue(tabSpc);
        Style targetStyle = this.sc.getStyle("target");
        this.targetBgColor.setColor(StyleConstants.getBackground(targetStyle));
        this.targetFgColor.setColor(StyleConstants.getForeground(targetStyle));
        Style errorStyle = this.sc.getStyle("targetError");
        this.errorBgColor.setColor(StyleConstants.getBackground(errorStyle));
        this.errorFgColor.setColor(StyleConstants.getForeground(errorStyle));
        this.updatePreview(null);
    }

    public StyleContext getStyleContext(EventObject evt) {
        Color c;
        Color c2;
        String tabSpc;
        Color c3;
        boolean underline;
        boolean italic;
        boolean bold;
        String fontSize;
        String fontFace;
        Object src = evt == null ? null : evt.getSource();
        Style defaultStyle = this.sc.getStyle("default");
        if (!(src != null && src != this.fontFaceCombo || (fontFace = (String)this.fontFaceCombo.getSelectedItem()) == null || fontFace.length() <= 0 || fontFace.equals(StyleConstants.getFontFamily(defaultStyle)))) {
            StyleConstants.setFontFamily(defaultStyle, fontFace);
        }
        if ((src == null || src == this.fontSizeCombo) && (fontSize = (String)this.fontSizeCombo.getSelectedItem()) != null && fontSize.length() > 0) {
            try {
                int fs = Integer.parseInt(fontSize);
                if (fs != StyleConstants.getFontSize(defaultStyle)) {
                    StyleConstants.setFontSize(defaultStyle, fs);
                }
            }
            catch (Exception fs) {
                // empty catch block
            }
        }
        if ((src == null || src == this.boldBtn) && (bold = this.boldBtn.isSelected()) != StyleConstants.isBold(defaultStyle)) {
            StyleConstants.setBold(defaultStyle, bold);
        }
        if ((src == null || src == this.italicBtn) && (italic = this.italicBtn.isSelected()) != StyleConstants.isItalic(defaultStyle)) {
            StyleConstants.setItalic(defaultStyle, italic);
        }
        if ((src == null || src == this.underlineBtn) && (underline = this.underlineBtn.isSelected()) != StyleConstants.isUnderline(defaultStyle)) {
            StyleConstants.setUnderline(defaultStyle, underline);
        }
        if (!(src != null && src != this.bgColorBtn || (c3 = this.bgColorBtn.getColor()).equals(StyleConstants.getBackground(defaultStyle)))) {
            StyleConstants.setBackground(defaultStyle, c3);
        }
        if (!(src != null && src != this.textColorBtn || (c = this.textColorBtn.getColor()).equals(StyleConstants.getForeground(defaultStyle)))) {
            StyleConstants.setForeground(defaultStyle, c);
        }
        if (!(src != null && src != this.tabSlider || (tabSpc = Integer.toString(Math.max(1, this.tabSlider.getValue()))).equals(defaultStyle.getAttribute("tabWidth")))) {
            defaultStyle.removeAttribute("tabWidth");
            defaultStyle.addAttribute("tabWidth", tabSpc);
        }
        Style targetStyle = this.sc.getStyle("target");
        if (!(src != null && src != this.targetFgColor || (c2 = this.targetFgColor.getColor()).equals(StyleConstants.getForeground(targetStyle)))) {
            StyleConstants.setForeground(targetStyle, c2);
        }
        if (!(src != null && src != this.targetBgColor || (c = this.targetBgColor.getColor()).equals(StyleConstants.getBackground(targetStyle)))) {
            StyleConstants.setBackground(targetStyle, c);
        }
        Style errorStyle = this.sc.getStyle("targetError");
        if (!(src != null && src != this.errorFgColor || (c = this.errorFgColor.getColor()).equals(StyleConstants.getForeground(errorStyle)))) {
            StyleConstants.setForeground(errorStyle, c);
        }
        if (!(src != null && src != this.errorBgColor || (c = this.errorBgColor.getColor()).equals(StyleConstants.getBackground(errorStyle)))) {
            StyleConstants.setBackground(errorStyle, c);
        }
        return this.sc;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.updatePreview(evt);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updatePreview(evt);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt != null && evt.getSource() == this.tabSlider && !this.tabSlider.getValueIsAdjusting()) {
            this.updatePreview(evt);
        }
    }

    private void updatePreview(EventObject evt) {
        if (evt != null) {
            this.getStyleContext(evt);
        }
        try {
            int i;
            Style defaultStyle = this.sc.getStyle("default");
            DefaultStyledDocument dsd = new DefaultStyledDocument((StyleContext)StreamIO.cloneObject(this.sc));
            Object tabObj = defaultStyle.getAttribute("tabWidth");
            if (tabObj != null) {
                int tabSpc = Math.max(1, Integer.parseInt(tabObj.toString()));
                TextActivityDocument.setStyledDocumentTabSpc(tabSpc, dsd, this.sc);
            }
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < 5; ++i) {
                sb.append("T").append(i).append("\t");
            }
            dsd.insertString(0, sb.append("\n").toString(), defaultStyle);
            for (i = 0; i < 2; ++i) {
                sb.setLength(0);
                sb.append(this.options.getMsg("edit_text_act_styleSample_default_start")).append(" ");
                dsd.insertString(dsd.getLength(), sb.toString(), defaultStyle);
                sb.setLength(0);
                sb.append(this.options.getMsg("edit_text_act_styleSample_target"));
                dsd.insertString(dsd.getLength(), sb.toString(), this.sc.getStyle("target"));
                sb.setLength(0);
                sb.append(" ").append(this.options.getMsg("edit_text_act_styleSample_default_fill")).append(" ");
                dsd.insertString(dsd.getLength(), sb.toString(), defaultStyle);
                sb.setLength(0);
                sb.append(this.options.getMsg("edit_text_act_styleSample_error"));
                dsd.insertString(dsd.getLength(), sb.toString(), this.sc.getStyle("targetError"));
                sb.setLength(0);
                sb.append(" ").append(this.options.getMsg("edit_text_act_styleSample_default_end")).append("\n");
                dsd.insertString(dsd.getLength(), sb.toString(), defaultStyle);
            }
            this.previewPanel.setStyledDocument(dsd);
            this.previewPanel.setBackground(StyleConstants.getBackground(defaultStyle));
        }
        catch (Exception ex) {
            System.err.println("Internal error:\n" + ex);
        }
    }

    public static StyleContext editStyleContext(Options options, StyleContext sc, Component parent) {
        TextStyleEditorPanel tsep;
        StyleContext result = null;
        StyleContext clon = null;
        if (sc != null) {
            try {
                clon = (StyleContext)StreamIO.cloneObject(sc);
            }
            catch (Exception ex) {
                System.err.println("Internal error: cannot clone object: " + sc + "\n" + ex);
            }
        }
        if ((tsep = panels.get(options)) == null) {
            tsep = new TextStyleEditorPanel(options, clon);
            panels.put(options, tsep);
        } else {
            tsep.setStyleContext(clon);
        }
        if (options.getMessages().showInputDlg(parent, tsep, "edit_style_title")) {
            result = tsep.getStyleContext(null);
        }
        return result;
    }

    static {
        panels = new HashMap<Options, TextStyleEditorPanel>(1);
    }
}

