/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.arith;

import edu.xtec.jclic.automation.AutoContentProviderEditor;
import edu.xtec.jclic.automation.arith.Arith;
import edu.xtec.jclic.automation.arith.ArithEditor;
import edu.xtec.jclic.automation.arith.Operator;
import edu.xtec.jclic.automation.arith.OperatorEditorPanel;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class ArithEditorPanel
extends EditorPanel {
    private String[] ORD_LIST = new String[3];
    private OperatorEditorPanel firstOpPanel;
    private OperatorEditorPanel secondOpPanel;
    private JRadioButton agbOpt;
    private JRadioButton albOpt;
    private JCheckBox avoidDupChk;
    private JCheckBox chkDivide;
    private JCheckBox chkMinus;
    private JCheckBox chkMultiply;
    private JCheckBox chkPlus;
    private JCheckBox chk_aobx;
    private JCheckBox chk_aoxr;
    private JCheckBox chk_axbr;
    private JCheckBox chk_invert;
    private JCheckBox chk_xobr;
    private ButtonGroup condGrp;
    private JPanel condPanel;
    private JPanel firstOpPanelX;
    private JComboBox fromCombo;
    private JRadioButton indOpt;
    private JCheckBox notCarryChk;
    private JPanel operationsPanel;
    private JComboBox orderCombo;
    private JPanel resultPanel;
    private JPanel rightPanel;
    private JPanel secondOpPanelX;
    private JLabel sepright;
    private JLabel sepright1;
    private JComboBox toCombo;
    private JPanel unknownPanel;

    public ArithEditorPanel(Options options) {
        super(options);
        this.ORD_LIST[0] = options.getMsg("edit_arith_result_random");
        this.ORD_LIST[1] = options.getMsg("edit_arith_result_asc");
        this.ORD_LIST[2] = options.getMsg("edit_arith_result_desc");
        this.initComponents();
        this.firstOpPanel = (OperatorEditorPanel)this.firstOpPanelX;
        this.secondOpPanel = (OperatorEditorPanel)this.secondOpPanelX;
        this.postInit(250, false, false);
    }

    private void initComponents() {
        this.condGrp = new ButtonGroup();
        JPanel leftPanel = new JPanel();
        this.operationsPanel = new JPanel();
        this.chkPlus = new JCheckBox();
        this.chkMinus = new JCheckBox();
        this.chkMultiply = new JCheckBox();
        this.chkDivide = new JCheckBox();
        this.unknownPanel = new JPanel();
        this.chk_aobx = new JCheckBox();
        this.chk_aoxr = new JCheckBox();
        this.chk_xobr = new JCheckBox();
        this.chk_axbr = new JCheckBox();
        JSeparator sep = new JSeparator();
        this.chk_invert = new JCheckBox();
        JLabel sepleft = new JLabel();
        this.rightPanel = new JPanel();
        this.firstOpPanelX = new OperatorEditorPanel(this.options);
        this.secondOpPanelX = new OperatorEditorPanel(this.options);
        this.resultPanel = new JPanel();
        JLabel fromLb = new JLabel();
        this.fromCombo = new JComboBox<Integer>(OperatorEditorPanel.LIST_OF_VALUES);
        JLabel toLb = new JLabel();
        this.toCombo = new JComboBox<Integer>(OperatorEditorPanel.LIST_OF_VALUES);
        this.notCarryChk = new JCheckBox();
        JLabel orderLb = new JLabel();
        this.orderCombo = new JComboBox<String>(this.ORD_LIST);
        this.avoidDupChk = new JCheckBox();
        this.condPanel = new JPanel();
        this.indOpt = new JRadioButton();
        this.agbOpt = new JRadioButton();
        this.albOpt = new JRadioButton();
        this.sepright1 = new JLabel();
        this.sepright = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setToolTipText(this.options.getMsg("edit_act_descriptionTab_tooltip"));
        leftPanel.setLayout(new GridBagLayout());
        this.operationsPanel.setLayout(new GridBagLayout());
        this.operationsPanel.setBorder(new TitledBorder(this.options.getMsg("edit_arith_operations")));
        this.operationsPanel.setToolTipText(this.options.getMsg("edit_arith_operations_tooltip"));
        this.chkPlus.setText(this.options.getMsg("edit_arith_operations_plus"));
        this.chkPlus.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.operationsPanel.add((Component)this.chkPlus, gridBagConstraints);
        this.chkMinus.setText(this.options.getMsg("edit_arith_operations_minus"));
        this.chkMinus.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.operationsPanel.add((Component)this.chkMinus, gridBagConstraints);
        this.chkMultiply.setText(this.options.getMsg("edit_arith_operations_multiply"));
        this.chkMultiply.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.operationsPanel.add((Component)this.chkMultiply, gridBagConstraints);
        this.chkDivide.setText(this.options.getMsg("edit_arith_operations_divide"));
        this.chkDivide.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.operationsPanel.add((Component)this.chkDivide, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        leftPanel.add((Component)this.operationsPanel, gridBagConstraints);
        this.unknownPanel.setLayout(new GridBagLayout());
        this.unknownPanel.setBorder(new TitledBorder(this.options.getMsg("edit_arith_unknown")));
        this.unknownPanel.setToolTipText(this.options.getMsg("edit_arith_unknown_tooltip"));
        this.chk_aobx.setToolTipText(this.options.getMsg("edit_arith_unknown_aobx"));
        this.chk_aobx.setText("A @ B = ?");
        this.chk_aobx.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.unknownPanel.add((Component)this.chk_aobx, gridBagConstraints);
        this.chk_aoxr.setToolTipText(this.options.getMsg("edit_arith_unknown_aoxr"));
        this.chk_aoxr.setText("A @ ? = C");
        this.chk_aoxr.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.unknownPanel.add((Component)this.chk_aoxr, gridBagConstraints);
        this.chk_xobr.setToolTipText(this.options.getMsg("edit_arith_unknown_xobr"));
        this.chk_xobr.setText("? @ B = C");
        this.chk_xobr.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.unknownPanel.add((Component)this.chk_xobr, gridBagConstraints);
        this.chk_axbr.setToolTipText(this.options.getMsg("edit_arith_unknown_axbr"));
        this.chk_axbr.setText("A ? B = C");
        this.chk_axbr.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.unknownPanel.add((Component)this.chk_axbr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.unknownPanel.add((Component)sep, gridBagConstraints);
        this.chk_invert.setToolTipText(this.options.getMsg("edit_arith_unknown_invert"));
        this.chk_invert.setText("C = A @ B");
        this.chk_invert.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.unknownPanel.add((Component)this.chk_invert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        leftPanel.add((Component)this.unknownPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        leftPanel.add((Component)sepleft, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)leftPanel, gridBagConstraints);
        this.rightPanel.setLayout(new GridBagLayout());
        this.firstOpPanelX.setBorder(new TitledBorder(this.options.getMsg("edit_arith_firstOp")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.rightPanel.add((Component)this.firstOpPanelX, gridBagConstraints);
        this.secondOpPanelX.setBorder(new TitledBorder(this.options.getMsg("edit_arith_secondOp")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.rightPanel.add((Component)this.secondOpPanelX, gridBagConstraints);
        this.resultPanel.setLayout(new GridBagLayout());
        this.resultPanel.setBorder(new TitledBorder(this.options.getMsg("edit_arith_result")));
        fromLb.setLabelFor(this.fromCombo);
        fromLb.setText(this.options.getMsg("edit_arith_op_from"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.resultPanel.add((Component)fromLb, gridBagConstraints);
        this.fromCombo.setToolTipText(this.options.getMsg("edit_arith_op_from_tooltip"));
        this.fromCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.resultPanel.add((Component)this.fromCombo, gridBagConstraints);
        toLb.setLabelFor(this.toCombo);
        toLb.setText(this.options.getMsg("edit_arith_op_to"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.resultPanel.add((Component)toLb, gridBagConstraints);
        this.toCombo.setToolTipText(this.options.getMsg("edit_arith_op_to_tooltip"));
        this.toCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.resultPanel.add((Component)this.toCombo, gridBagConstraints);
        this.notCarryChk.setText(this.options.getMsg("edit_arith_result_notCarry"));
        this.notCarryChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.resultPanel.add((Component)this.notCarryChk, gridBagConstraints);
        orderLb.setText(this.options.getMsg("edit_arith_result_order"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.resultPanel.add((Component)orderLb, gridBagConstraints);
        this.orderCombo.setToolTipText(this.options.getMsg("edit_arith_op_to_tooltip"));
        this.orderCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.resultPanel.add((Component)this.orderCombo, gridBagConstraints);
        this.avoidDupChk.setText(this.options.getMsg("edit_arith_result_avoidDup"));
        this.avoidDupChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.resultPanel.add((Component)this.avoidDupChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.rightPanel.add((Component)this.resultPanel, gridBagConstraints);
        this.condPanel.setLayout(new GridBagLayout());
        this.condPanel.setBorder(new TitledBorder(this.options.getMsg("edit_arith_cond")));
        this.condPanel.setToolTipText(this.options.getMsg("edit_arith_cond_tooltip"));
        this.indOpt.setText(this.options.getMsg("edit_arith_cond_ind"));
        this.condGrp.add(this.indOpt);
        this.indOpt.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.condPanel.add((Component)this.indOpt, gridBagConstraints);
        this.agbOpt.setToolTipText(this.options.getMsg("edit_arith_cond_agb"));
        this.agbOpt.setText("A > B");
        this.condGrp.add(this.agbOpt);
        this.agbOpt.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.condPanel.add((Component)this.agbOpt, gridBagConstraints);
        this.albOpt.setToolTipText(this.options.getMsg("edit_arith_cond_alb"));
        this.albOpt.setText("A < B");
        this.condGrp.add(this.albOpt);
        this.albOpt.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.condPanel.add((Component)this.albOpt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.rightPanel.add((Component)this.condPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.rightPanel.add((Component)this.sepright1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.rightPanel.add((Component)this.sepright, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.rightPanel, gridBagConstraints);
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ArithEditor;
    }

    public ArithEditor getArithEditor() {
        return (ArithEditor)this.getEditor();
    }

    public Arith getArith() {
        ArithEditor aed = this.getArithEditor();
        return aed == null ? null : (Arith)aed.getAutoContentProvider();
    }

    @Override
    public void fillData() {
        Arith a = this.getArith();
        this.chkPlus.setSelected(a == null ? true : a.use_add);
        this.chkMinus.setSelected(a == null ? false : a.use_subst);
        this.chkMultiply.setSelected(a == null ? false : a.use_mult);
        this.chkDivide.setSelected(a == null ? false : a.use_div);
        this.chk_aobx.setSelected(a == null ? true : a.exp_abx);
        this.chk_aoxr.setSelected(a == null ? false : a.exp_axc);
        this.chk_xobr.setSelected(a == null ? false : a.exp_xbc);
        this.chk_axbr.setSelected(a == null ? false : a.exp_axbc);
        this.chk_invert.setSelected(a == null ? false : a.exp_caxb);
        this.firstOpPanel.setOperator(a == null ? new Operator() : a.opA);
        this.secondOpPanel.setOperator(a == null ? new Operator() : a.opB);
        this.fromCombo.setSelectedIndex(a == null ? 1 : a.resultLimInf);
        this.toCombo.setSelectedIndex(a == null ? Operator.LIMITS.length - 1 : a.resultLimSup);
        this.notCarryChk.setSelected(a == null ? false : a.resultCarry);
        this.avoidDupChk.setSelected(a == null ? false : a.resultNoDup);
        this.orderCombo.setSelectedIndex(a == null ? 0 : a.resultOrder);
        int cond = a == null ? 0 : a.opCond;
        this.indOpt.setSelected(cond == 0);
        this.agbOpt.setSelected(cond == 1);
        this.albOpt.setSelected(cond == 2);
        this.setModified(false);
    }

    @Override
    public void saveData() {
        Arith a = this.getArith();
        if (a != null) {
            a.use_add = this.chkPlus.isSelected();
            a.use_subst = this.chkMinus.isSelected();
            a.use_mult = this.chkMultiply.isSelected();
            a.use_div = this.chkDivide.isSelected();
            a.exp_abx = this.chk_aobx.isSelected();
            a.exp_axc = this.chk_aoxr.isSelected();
            a.exp_xbc = this.chk_xobr.isSelected();
            a.exp_axbc = this.chk_axbr.isSelected();
            a.exp_caxb = this.chk_invert.isSelected();
            a.opA = this.firstOpPanel.getOperator();
            a.opB = this.secondOpPanel.getOperator();
            a.resultLimInf = this.fromCombo.getSelectedIndex();
            a.resultLimSup = this.toCombo.getSelectedIndex();
            a.resultCarry = this.notCarryChk.isSelected();
            a.resultNoDup = this.avoidDupChk.isSelected();
            a.resultOrder = this.orderCombo.getSelectedIndex();
            a.opCond = this.agbOpt.isSelected() ? 1 : (this.albOpt.isSelected() ? 2 : 0);
        }
    }

    @Override
    protected Icon getIcon() {
        return AutoContentProviderEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("edit_arith_title");
    }
}

