/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.beans;

import edu.xtec.jclic.beans.NullableObject;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.BoxBaseEditor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JButton;

public class BoxBaseButton
extends NullableObject {
    public static final String PROP_BOX_BASE = "boxBase";
    public static final String SAMPLE_STR = "abc";
    AbstractBox preview;

    @Override
    protected String getObjectType() {
        return PROP_BOX_BASE;
    }

    public BoxBase getBoxBase() {
        return (BoxBase)this.getObject();
    }

    public void setBoxBase(BoxBase bb) {
        this.setObject(bb);
    }

    @Override
    public void setObject(Object value) {
        super.setObject(value);
    }

    @Override
    protected AbstractButton buildButton() {
        return new JButton(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                BoxBase bb = BoxBaseButton.this.getBoxBase();
                if (bb != null) {
                    Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    r.grow(-3, -3);
                    g.setColor(bb.backColor);
                    g.fillRect(r.x, r.y, r.width, r.height);
                    g.setColor(bb.textColor);
                    FontMetrics fm = g.getFontMetrics();
                    int y = r.y + r.height - (r.height - fm.getAscent()) / 2 - fm.getDescent();
                    int x = r.x + (r.width - fm.stringWidth(BoxBaseButton.SAMPLE_STR)) / 2;
                    g.drawString(BoxBaseButton.SAMPLE_STR, x, y);
                }
            }
        };
    }

    public void setPreview(AbstractBox preview) {
        this.preview = preview;
    }

    @Override
    protected Object createObject() {
        return new BoxBase();
    }

    @Override
    protected Object editObject(Object o) {
        BoxBase bb = (BoxBase)(o == null ? this.createObject() : o);
        return BoxBaseEditor.getBoxBase(bb, this, this.options, this.preview);
    }
}

