/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.GradientButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoxBaseEditor
extends JPanel {
    Options options;
    BoxBase bb;
    public static final String PROP_BOX_BASE = "boxBase";
    ActionListener cfListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            BoxBase oldBb = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.createFont();
            BoxBaseEditor.this.checkAndFirePropertyChange(oldBb);
        }
    };
    PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BoxBase oldBb = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.bb.backColor = BoxBaseEditor.this.bgColorBtn.getColor();
            BoxBaseEditor.this.bb.bgGradient = BoxBaseEditor.this.gradientButton.getGradient();
            BoxBaseEditor.this.bb.textColor = BoxBaseEditor.this.textColorBtn.getColor();
            BoxBaseEditor.this.bb.shadowColor = BoxBaseEditor.this.shadowColorBtn.getColor();
            BoxBaseEditor.this.bb.shadow = BoxBaseEditor.this.shadowChk.isSelected();
            BoxBaseEditor.this.bb.transparent = BoxBaseEditor.this.transparentChk.isSelected();
            BoxBaseEditor.this.bb.borderColor = BoxBaseEditor.this.borderColorBtn.getColor();
            BoxBaseEditor.this.bb.inactiveColor = BoxBaseEditor.this.inactiveColorBtn.getColor();
            BoxBaseEditor.this.bb.alternativeColor = BoxBaseEditor.this.altColorBtn.getColor();
            BoxBaseEditor.this.bb.textMargin = BoxBaseEditor.this.textMarginInt.getValue();
            BoxBaseEditor.this.checkAndFirePropertyChange(oldBb);
        }
    };
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            BoxBase oldBb = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.bb.shadow = BoxBaseEditor.this.shadowChk.isSelected();
            BoxBaseEditor.this.bb.transparent = BoxBaseEditor.this.transparentChk.isSelected();
            BoxBaseEditor.this.checkAndFirePropertyChange(oldBb);
        }
    };
    ChangeListener borderListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            BoxBase oldBb = BoxBaseEditor.this.getBoxBaseClone();
            BoxBaseEditor.this.bb.borderStroke = new BasicStroke((float)BoxBaseEditor.this.borderWidthSlider.getValue() / 10.0f);
            BoxBaseEditor.this.bb.markerStroke = new BasicStroke((float)BoxBaseEditor.this.markerWidthSlider.getValue() / 10.0f);
            BoxBaseEditor.this.checkAndFirePropertyChange(oldBb);
        }
    };
    private static Map<Options, BoxBaseEditor> panels = new HashMap<Options, BoxBaseEditor>(1);
    private ColorButton altColorBtn;
    private ColorButton bgColorBtn;
    private JToggleButton boldBtn;
    private ColorButton borderColorBtn;
    private JSlider borderWidthSlider;
    private JComboBox fontFaceCombo;
    private JComboBox fontSizeCombo;
    private GradientButton gradientButton;
    private ColorButton inactiveColorBtn;
    private JToggleButton italicBtn;
    private JSlider markerWidthSlider;
    private JCheckBox shadowChk;
    private ColorButton shadowColorBtn;
    private ColorButton textColorBtn;
    private SmallIntEditor textMarginInt;
    private JCheckBox transparentChk;
    private JPanel typefacePanel;

    public BoxBaseEditor(Options options, BoxBase bb) {
        this.options = options;
        this.initComponents();
        this.setBoxBase(bb);
    }

    private void initComponents() {
        JLabel bgColorLb = new JLabel();
        this.bgColorBtn = new ColorButton();
        this.bgColorBtn.setOptions(this.options);
        JLabel gradientLb = new JLabel();
        this.gradientButton = new GradientButton();
        this.gradientButton.setOptions(this.options);
        this.transparentChk = new JCheckBox();
        JSeparator sep1 = new JSeparator();
        JLabel fontLb = new JLabel();
        this.typefacePanel = new JPanel();
        this.fontFaceCombo = new JComboBox<String>(FontCheck.getFontList(false));
        JLabel sizeLb = new JLabel();
        this.fontSizeCombo = new JComboBox<String>(FontCheck.fontSizes);
        this.boldBtn = new JToggleButton();
        this.italicBtn = new JToggleButton();
        JSeparator sep2 = new JSeparator();
        JLabel textColorLb = new JLabel();
        this.textColorBtn = new ColorButton();
        this.textColorBtn.setOptions(this.options);
        JLabel altColorLb = new JLabel();
        this.altColorBtn = new ColorButton();
        this.altColorBtn.setOptions(this.options);
        JLabel textMarginLb = new JLabel();
        this.textMarginInt = new SmallIntEditor();
        this.shadowChk = new JCheckBox();
        JLabel shadowColorLb = new JLabel();
        this.shadowColorBtn = new ColorButton();
        this.shadowColorBtn.setOptions(this.options);
        JLabel borderColorLb = new JLabel();
        this.borderColorBtn = new ColorButton();
        this.borderColorBtn.setOptions(this.options);
        JLabel borderWidthLb = new JLabel();
        this.borderWidthSlider = new JSlider();
        JLabel inactiveColorLb = new JLabel();
        this.inactiveColorBtn = new ColorButton();
        this.inactiveColorBtn.setOptions(this.options);
        JLabel markerWidthLb = new JLabel();
        this.markerWidthSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        bgColorLb.setLabelFor(this.bgColorBtn);
        bgColorLb.setText(this.options.getMsg("edit_act_bgColor"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)bgColorLb, gridBagConstraints);
        this.bgColorBtn.setToolTipText(this.options.getMsg("edit_act_bgColor_tooltip"));
        this.bgColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.bgColorBtn, gridBagConstraints);
        gradientLb.setText(this.options.getMsg("edit_act_gradient"));
        gradientLb.setLabelFor(this.gradientButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)gradientLb, gridBagConstraints);
        this.gradientButton.setToolTipText(this.options.getMsg("edit_act_gradient_tooltip"));
        this.gradientButton.addPropertyChangeListener("gradient", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.gradientButton, gridBagConstraints);
        this.transparentChk.setToolTipText(this.options.getMsg("edit_act_transparent_tooltip"));
        this.transparentChk.setText(this.options.getMsg("edit_act_transparent"));
        this.transparentChk.addActionListener(this.actionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.transparentChk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)sep1, gridBagConstraints);
        fontLb.setLabelFor(this.fontFaceCombo);
        fontLb.setText(this.options.getMsg("edit_font_face"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)fontLb, gridBagConstraints);
        this.typefacePanel.setLayout(new GridBagLayout());
        this.fontFaceCombo.setEditable(true);
        this.fontFaceCombo.setPreferredSize(new Dimension(125, this.fontFaceCombo.getPreferredSize().height));
        this.fontFaceCombo.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.fontFaceCombo, gridBagConstraints);
        sizeLb.setText(this.options.getMsg("edit_font_size"));
        sizeLb.setLabelFor(this.fontSizeCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)sizeLb, gridBagConstraints);
        this.fontSizeCombo.setEditable(true);
        this.fontSizeCombo.setPreferredSize(new Dimension(50, this.fontSizeCombo.getPreferredSize().height));
        this.fontSizeCombo.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.boldBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_bold.gif")));
        this.boldBtn.setToolTipText(this.options.getMsg("edit_font_bold"));
        this.boldBtn.setPreferredSize(new Dimension(27, 27));
        this.boldBtn.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.boldBtn, gridBagConstraints);
        this.italicBtn.setIcon(new ImageIcon(this.getClass().getResource("/edu/xtec/resources/icons/font_italic.gif")));
        this.italicBtn.setToolTipText(this.options.getMsg("edit_font_italic"));
        this.italicBtn.setPreferredSize(new Dimension(27, 27));
        this.italicBtn.addActionListener(this.cfListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.typefacePanel.add((Component)this.italicBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.typefacePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)sep2, gridBagConstraints);
        textColorLb.setText(this.options.getMsg("edit_act_textColor"));
        textColorLb.setLabelFor(this.textColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)textColorLb, gridBagConstraints);
        this.textColorBtn.setToolTipText(this.options.getMsg("edit_act_textColor_tooltip"));
        this.textColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.textColorBtn, gridBagConstraints);
        altColorLb.setText(this.options.getMsg("edit_act_altColor"));
        altColorLb.setLabelFor(this.altColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)altColorLb, gridBagConstraints);
        this.altColorBtn.setToolTipText(this.options.getMsg("edit_act_altColor_tooltip"));
        this.altColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.altColorBtn, gridBagConstraints);
        textMarginLb.setLabelFor(this.textMarginInt);
        textMarginLb.setText(this.options.getMsg("edit_cell_textMargin"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)textMarginLb, gridBagConstraints);
        this.textMarginInt.setToolTipText(this.options.getMsg("edit_cell_textMargin_tooltip"));
        this.textMarginInt.setMax(50);
        this.textMarginInt.addPropertyChangeListener("value", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.textMarginInt, gridBagConstraints);
        this.shadowChk.setToolTipText(this.options.getMsg("edit_act_shadow_tooltip"));
        this.shadowChk.setText(this.options.getMsg("edit_act_shadow"));
        this.shadowChk.addActionListener(this.actionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shadowChk, gridBagConstraints);
        shadowColorLb.setText(this.options.getMsg("edit_act_shadowColor"));
        shadowColorLb.setLabelFor(this.shadowColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)shadowColorLb, gridBagConstraints);
        this.shadowColorBtn.setToolTipText(this.options.getMsg("edit_act_shadowColor_tooltip"));
        this.shadowColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.shadowColorBtn, gridBagConstraints);
        borderColorLb.setText(this.options.getMsg("edit_act_borderColor"));
        borderColorLb.setLabelFor(this.borderColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)borderColorLb, gridBagConstraints);
        this.borderColorBtn.setToolTipText(this.options.getMsg("edit_act_borderColor_tooltip"));
        this.borderColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.borderColorBtn, gridBagConstraints);
        borderWidthLb.setText(this.options.getMsg("edit_cell_borderWidth"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)borderWidthLb, gridBagConstraints);
        this.borderWidthSlider.setMinorTickSpacing(10);
        this.borderWidthSlider.setPaintTicks(true);
        this.borderWidthSlider.setMajorTickSpacing(50);
        this.borderWidthSlider.setToolTipText(this.options.getMsg("edit_cell_borderWidth_tooltip"));
        this.borderWidthSlider.setPreferredSize(new Dimension(100, 27));
        this.borderWidthSlider.addChangeListener(this.borderListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.borderWidthSlider, gridBagConstraints);
        inactiveColorLb.setText(this.options.getMsg("edit_act_inactiveColor"));
        inactiveColorLb.setLabelFor(this.inactiveColorBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)inactiveColorLb, gridBagConstraints);
        this.inactiveColorBtn.setToolTipText(this.options.getMsg("edit_act_inactiveColor_tooltip"));
        this.inactiveColorBtn.addPropertyChangeListener("color", this.propListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.inactiveColorBtn, gridBagConstraints);
        markerWidthLb.setText(this.options.getMsg("edit_cell_markerWidth"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)markerWidthLb, gridBagConstraints);
        this.markerWidthSlider.setMinorTickSpacing(10);
        this.markerWidthSlider.setPaintTicks(true);
        this.markerWidthSlider.setMajorTickSpacing(50);
        this.markerWidthSlider.setToolTipText(this.options.getMsg("edit_cell_markerWidth_tooltip"));
        this.markerWidthSlider.setPreferredSize(new Dimension(100, 27));
        this.borderWidthSlider.addChangeListener(this.borderListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.markerWidthSlider, gridBagConstraints);
    }

    public void setBoxBase(BoxBase b) {
        if (b == null) {
            b = new BoxBase();
        }
        this.bb = (BoxBase)b.clone();
        Font f = this.bb.getOriginalFont();
        this.fontFaceCombo.setSelectedItem(f.getFamily());
        this.fontSizeCombo.setSelectedItem(Integer.toString(f.getSize()));
        this.boldBtn.setSelected(f.isBold());
        this.italicBtn.setSelected(f.isItalic());
        this.bgColorBtn.setColor(b.backColor);
        this.gradientButton.setGradient(b.bgGradient);
        this.textColorBtn.setColor(b.textColor);
        this.shadowColorBtn.setColor(b.shadowColor);
        this.shadowChk.setSelected(b.shadow);
        this.transparentChk.setSelected(b.transparent);
        this.borderColorBtn.setColor(b.borderColor);
        this.inactiveColorBtn.setColor(b.inactiveColor);
        this.altColorBtn.setColor(b.alternativeColor);
        this.textMarginInt.setValue(b.textMargin);
        this.borderWidthSlider.setValue((int)(b.borderStroke.getLineWidth() * 10.0f));
        this.markerWidthSlider.setValue((int)(b.markerStroke.getLineWidth() * 10.0f));
    }

    protected void createFont() {
        int s;
        Font f = this.bb.getFont();
        try {
            s = Integer.parseInt((String)this.fontSizeCombo.getSelectedItem());
        }
        catch (Exception ex) {
            s = f.getSize();
        }
        s = Math.min(Math.max(s, 6), 140);
        int style = 0;
        if (this.boldBtn.isSelected()) {
            style |= 1;
        }
        if (this.italicBtn.isSelected()) {
            style |= 2;
        }
        this.bb.setFont(new Font((String)this.fontFaceCombo.getSelectedItem(), style, s));
    }

    private void checkAndFirePropertyChange(BoxBase oldBb) {
        boolean eq;
        BoxBase currentBb = this.getBoxBase();
        boolean bl = eq = oldBb == null && currentBb == null || oldBb != null && oldBb.equals(currentBb);
        if (!eq) {
            this.firePropertyChange(PROP_BOX_BASE, oldBb, currentBb);
        }
    }

    public BoxBase getBoxBase() {
        return this.bb;
    }

    public BoxBase getBoxBaseClone() {
        if (this.bb != null) {
            return (BoxBase)this.bb.clone();
        }
        return null;
    }

    public static BoxBase getBoxBase(BoxBase initialBoxBase, Component parent, Options options, final AbstractBox preview) {
        Messages msg = options.getMessages();
        BoxBaseEditor bbe = panels.get(options);
        if (bbe == null) {
            bbe = new BoxBaseEditor(options, initialBoxBase);
            panels.put(options, bbe);
        } else {
            bbe.setBoxBase(initialBoxBase);
        }
        PropertyChangeListener lst = null;
        final BoxBaseEditor bb_ed = bbe;
        if (preview != null) {
            lst = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    if (preview != null) {
                        preview.setBoxBase(bb_ed.getBoxBase());
                    }
                }
            };
            bbe.addPropertyChangeListener(PROP_BOX_BASE, lst);
        }
        BoxBase bbBackup = preview != null ? bbe.getBoxBaseClone() : null;
        boolean b = msg.showInputDlg(parent, bbe, "edit_style_title");
        if (lst != null) {
            bbe.removePropertyChangeListener(PROP_BOX_BASE, lst);
        }
        if (!b && preview != null) {
            preview.setBoxBase(bbBackup);
        }
        return b ? bbe.bb : null;
    }
}

