/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBagEditor;
import edu.xtec.jclic.bags.MediaBagSelector;
import edu.xtec.jclic.beans.MediaContentButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.jclic.media.MediaContent;
import edu.xtec.util.CtrlPanel;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

public class MediaContentEditor
extends CtrlPanel {
    MediaContent mc;
    Options options;
    MediaBagEditor mbe;
    public static final String PROP_MC = "mediaContent";
    private static final String[] LOCATION_FROM_MSG_CODES = new String[]{"box", "window", "frame"};
    List<String> locationFromNames;
    private JTextField[] textFields;
    private JCheckBox autostartChk;
    private JCheckBox catchMouseChk;
    private JTextField externalTxt;
    private JPanel filePanel;
    private JTextField fileTxt;
    private JButton findFileBtn;
    private JPanel fragmentPanel;
    private JTextField fromTxt;
    private JLabel lbExternal;
    private JLabel lbFile;
    private JLabel lbFrom;
    private JLabel lbLength;
    private JLabel lbLevel;
    private JLabel lbLocFrom;
    private JLabel lbRecbuffer;
    private JLabel lbTo;
    private JLabel lbX;
    private JLabel lbY;
    private SmallIntEditor lengthEditor;
    private SmallIntEditor levelEditor;
    private JComboBox locFromCombo;
    private JPanel locationPanel;
    private JCheckBox loopChk;
    private JPanel mainPanel;
    private JPanel mediaTypePanel;
    private ButtonGroup mediaTypes;
    private JRadioButton posAbsoluteRadio;
    private JRadioButton posCellRadio;
    private ButtonGroup posTypes;
    private JRadioButton posWindowRadio;
    private SmallIntEditor recBufferEditor;
    private JCheckBox stretchChk;
    private JTextField toTxt;
    private JToggleButton toggleType01;
    private JToggleButton toggleType02;
    private JToggleButton toggleType03;
    private JToggleButton toggleType04;
    private JToggleButton toggleType05;
    private JToggleButton toggleType06;
    private JToggleButton toggleType07;
    private JToggleButton toggleType08;
    private JToggleButton toggleType09;
    private JToggleButton toggleType10;
    private JToggleButton toggleType11;
    private JToggleButton toggleType12;
    private JTextField xTxt;
    private JTextField yTxt;
    private static Map<Options, MediaContentEditor> panels = new HashMap<Options, MediaContentEditor>();

    public MediaContentEditor(Options options, MediaContent mc, MediaBagEditor mbe) {
        this.options = options;
        this.pre_init();
        this.initComponents();
        this.post_init();
        this.setMediaBagEditor(mbe);
        this.setMediaContent(mc);
    }

    private void pre_init() {
        this.locationFromNames = new ArrayList<String>();
        for (String code : LOCATION_FROM_MSG_CODES) {
            this.locationFromNames.add(this.options.getMsg("edit_mc_location_from_" + code));
        }
    }

    private void post_init() {
        this.textFields = new JTextField[]{this.fileTxt, this.externalTxt, this.fromTxt, this.toTxt, this.xTxt, this.yTxt};
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].getDocument().addDocumentListener(this);
        }
        Enumeration<AbstractButton> en = this.mediaTypes.getElements();
        while (en.hasMoreElements()) {
            JToggleButton rb = (JToggleButton)en.nextElement();
            rb.addActionListener(this);
        }
    }

    public void setMediaBagEditor(MediaBagEditor mbe) {
        this.mbe = mbe;
    }

    private void checkAndFirePropertyChange(MediaContent oldMc) {
        boolean eq;
        MediaContent currentMc = this.getMc();
        boolean bl = eq = oldMc == null && currentMc == null || oldMc != null && oldMc.equals(currentMc);
        if (!eq) {
            this.firePropertyChange(PROP_MC, oldMc, currentMc);
        }
    }

    public void setMediaContent(MediaContent c) {
        if (c == null) {
            c = new MediaContent();
        }
        this.setInitializing(true);
        this.mc = (MediaContent)c.clone();
        Enumeration<AbstractButton> en = this.mediaTypes.getElements();
        JToggleButton rb = (JToggleButton)en.nextElement();
        for (int i = 0; i < this.mc.mediaType; ++i) {
            rb = (JToggleButton)en.nextElement();
        }
        rb.setSelected(true);
        this.levelEditor.setValue(this.mc.level);
        this.recBufferEditor.setValue(this.mc.recBuffer);
        this.fileTxt.setText(this.mc.mediaFileName);
        this.externalTxt.setText(this.mc.externalParam);
        this.fromTxt.setText(Integer.toString(this.mc.from));
        this.toTxt.setText(Integer.toString(this.mc.to));
        this.lengthEditor.setValue(this.mc.length);
        this.stretchChk.setSelected(this.mc.stretch);
        if (this.mc.absLocation != null) {
            this.posAbsoluteRadio.setSelected(true);
        } else if (this.mc.free) {
            this.posWindowRadio.setSelected(true);
        } else {
            this.posCellRadio.setSelected(true);
        }
        this.syncPointValues();
        this.loopChk.setSelected(this.mc.loop);
        this.autostartChk.setSelected(this.mc.autoStart);
        this.catchMouseChk.setSelected(this.mc.catchMouseEvents);
        this.checkEnabled();
        this.setInitializing(false);
    }

    public boolean check(Component parent) {
        boolean result = false;
        switch (this.mc.mediaType) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                result = StrUtils.nullableString(this.mc.mediaFileName) != null;
                break;
            }
            case 5: 
            case 6: {
                result = this.mc.recBuffer >= 0 && this.mc.recBuffer < 10;
                break;
            }
            case 8: {
                result = StrUtils.nullableString(this.mc.mediaFileName) != null || StrUtils.nullableString(this.mc.externalParam) != null;
                break;
            }
            case 11: 
            case 12: {
                result = true;
            }
        }
        if (!result) {
            this.options.getMessages().showAlert(parent, "edit_mc_err_nullContent");
        }
        return result;
    }

    public MediaContent getMc() {
        return this.mc;
    }

    public MediaContent getMcClone() {
        return this.mc == null ? null : (MediaContent)this.mc.clone();
    }

    private void initComponents() {
        this.mediaTypes = new ButtonGroup();
        this.posTypes = new ButtonGroup();
        this.mediaTypePanel = new JPanel();
        JToggleButton toggleType00 = new JToggleButton();
        this.toggleType01 = new JToggleButton();
        this.toggleType02 = new JToggleButton();
        this.toggleType03 = new JToggleButton();
        this.toggleType04 = new JToggleButton();
        this.toggleType05 = new JToggleButton();
        this.toggleType06 = new JToggleButton();
        this.toggleType07 = new JToggleButton();
        this.toggleType08 = new JToggleButton();
        this.toggleType09 = new JToggleButton();
        this.toggleType10 = new JToggleButton();
        this.toggleType11 = new JToggleButton();
        this.toggleType12 = new JToggleButton();
        this.mainPanel = new JPanel();
        this.lbLevel = new JLabel();
        this.levelEditor = new SmallIntEditor();
        this.loopChk = new JCheckBox();
        this.autostartChk = new JCheckBox();
        this.filePanel = new JPanel();
        JPanel filePanelCard0 = new JPanel();
        JPanel filePanelCard1 = new JPanel();
        this.lbFile = new JLabel();
        this.fileTxt = new JTextField();
        this.findFileBtn = new JButton();
        JPanel filePanelCard2 = new JPanel();
        this.lbRecbuffer = new JLabel();
        this.recBufferEditor = new SmallIntEditor();
        this.lbLength = new JLabel();
        this.lengthEditor = new SmallIntEditor();
        this.fragmentPanel = new JPanel();
        JPanel fragmentPanelCard0 = new JPanel();
        JPanel fragmentPanelCard1 = new JPanel();
        this.lbFrom = new JLabel();
        this.fromTxt = new JTextField();
        this.lbTo = new JLabel();
        this.toTxt = new JTextField();
        JPanel fragmentPanelCard2 = new JPanel();
        this.lbExternal = new JLabel();
        this.externalTxt = new JTextField();
        this.locationPanel = new JPanel();
        JPanel locationPanelCard0 = new JPanel();
        JPanel locationPanelCard1 = new JPanel();
        JPanel lpanel = new JPanel();
        this.posCellRadio = new JRadioButton();
        this.posWindowRadio = new JRadioButton();
        this.posAbsoluteRadio = new JRadioButton();
        this.lbX = new JLabel();
        this.xTxt = new JTextField();
        this.lbY = new JLabel();
        this.yTxt = new JTextField();
        this.lbLocFrom = new JLabel();
        this.locFromCombo = new JComboBox<Object>(this.locationFromNames.toArray());
        this.catchMouseChk = new JCheckBox();
        this.stretchChk = new JCheckBox();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.mediaTypePanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_mc_type")));
        this.mediaTypePanel.setLayout(new GridBagLayout());
        this.mediaTypes.add(toggleType00);
        toggleType00.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[0]));
        toggleType00.setText(this.options.getMsg("edit_mc_type_unknown"));
        toggleType00.setToolTipText(this.options.getMsg("edit_mc_type_unknown"));
        toggleType00.setHorizontalAlignment(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)toggleType00, gridBagConstraints);
        this.mediaTypes.add(this.toggleType01);
        this.toggleType01.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[1]));
        this.toggleType01.setText(this.options.getMsg("edit_mc_type_sound"));
        this.toggleType01.setToolTipText(this.options.getMsg("edit_mc_type_sound"));
        this.toggleType01.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType01, gridBagConstraints);
        this.mediaTypes.add(this.toggleType02);
        this.toggleType02.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[2]));
        this.toggleType02.setText(this.options.getMsg("edit_mc_type_video"));
        this.toggleType02.setToolTipText(this.options.getMsg("edit_mc_type_video"));
        this.toggleType02.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType02, gridBagConstraints);
        this.mediaTypes.add(this.toggleType03);
        this.toggleType03.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[3]));
        this.toggleType03.setText(this.options.getMsg("edit_mc_type_midi"));
        this.toggleType03.setToolTipText(this.options.getMsg("edit_mc_type_midi"));
        this.toggleType03.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType03, gridBagConstraints);
        this.mediaTypes.add(this.toggleType04);
        this.toggleType04.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[4]));
        this.toggleType04.setText(this.options.getMsg("edit_mc_type_cdaudio"));
        this.toggleType04.setToolTipText(this.options.getMsg("edit_mc_type_cdaudio"));
        this.toggleType04.setEnabled(false);
        this.toggleType04.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType04, gridBagConstraints);
        this.mediaTypes.add(this.toggleType05);
        this.toggleType05.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[5]));
        this.toggleType05.setText(this.options.getMsg("edit_mc_type_record"));
        this.toggleType05.setToolTipText(this.options.getMsg("edit_mc_type_record"));
        this.toggleType05.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType05, gridBagConstraints);
        this.mediaTypes.add(this.toggleType06);
        this.toggleType06.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[6]));
        this.toggleType06.setText(this.options.getMsg("edit_mc_type_play_recorded"));
        this.toggleType06.setToolTipText(this.options.getMsg("edit_mc_type_play_recorded"));
        this.toggleType06.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType06, gridBagConstraints);
        this.mediaTypes.add(this.toggleType07);
        this.toggleType07.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[7]));
        this.toggleType07.setText(this.options.getMsg("edit_mc_type_run_activity"));
        this.toggleType07.setToolTipText(this.options.getMsg("edit_mc_type_run_activity"));
        this.toggleType07.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType07, gridBagConstraints);
        this.mediaTypes.add(this.toggleType08);
        this.toggleType08.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[8]));
        this.toggleType08.setText(this.options.getMsg("edit_mc_type_run_sequence"));
        this.toggleType08.setToolTipText(this.options.getMsg("edit_mc_type_run_sequence"));
        this.toggleType08.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType08, gridBagConstraints);
        this.mediaTypes.add(this.toggleType09);
        this.toggleType09.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[9]));
        this.toggleType09.setText(this.options.getMsg("edit_mc_type_run_external"));
        this.toggleType09.setToolTipText(this.options.getMsg("edit_mc_type_run_external"));
        this.toggleType09.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType09, gridBagConstraints);
        this.mediaTypes.add(this.toggleType10);
        this.toggleType10.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[10]));
        this.toggleType10.setText(this.options.getMsg("edit_mc_type_url"));
        this.toggleType10.setToolTipText(this.options.getMsg("edit_mc_type_url"));
        this.toggleType10.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType10, gridBagConstraints);
        this.mediaTypes.add(this.toggleType11);
        this.toggleType11.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[11]));
        this.toggleType11.setText(this.options.getMsg("edit_mc_type_exit"));
        this.toggleType11.setToolTipText(this.options.getMsg("edit_mc_type_exit"));
        this.toggleType11.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType11, gridBagConstraints);
        this.mediaTypes.add(this.toggleType12);
        this.toggleType12.setIcon(ResourceManager.getImageIcon(MediaContentButton.MEDIA_ICONS[12]));
        this.toggleType12.setText(this.options.getMsg("edit_mc_type_return"));
        this.toggleType12.setToolTipText(this.options.getMsg("edit_mc_type_return"));
        this.toggleType12.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mediaTypePanel.add((Component)this.toggleType12, gridBagConstraints);
        this.add((Component)this.mediaTypePanel, "West");
        this.mainPanel.setLayout(new GridBagLayout());
        this.lbLevel.setText(this.options.getMsg("edit_mc_level"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.lbLevel, gridBagConstraints);
        this.levelEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.levelEditor, gridBagConstraints);
        this.loopChk.setText(this.options.getMsg("edit_mc_loop"));
        this.loopChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.loopChk, gridBagConstraints);
        this.autostartChk.setText(this.options.getMsg("edit_mc_autostart"));
        this.autostartChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.autostartChk, gridBagConstraints);
        this.filePanel.setLayout(new CardLayout());
        this.filePanel.add((Component)filePanelCard0, "card0");
        filePanelCard1.setLayout(new GridBagLayout());
        this.lbFile.setText(this.options.getMsg("edit_mc_file"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        filePanelCard1.add((Component)this.lbFile, gridBagConstraints);
        this.fileTxt.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        filePanelCard1.add((Component)this.fileTxt, gridBagConstraints);
        this.findFileBtn.setText("...");
        this.findFileBtn.addActionListener(this);
        filePanelCard1.add((Component)this.findFileBtn, new GridBagConstraints());
        this.filePanel.add((Component)filePanelCard1, "card1");
        filePanelCard2.setLayout(new GridBagLayout());
        this.lbRecbuffer.setText(this.options.getMsg("edit_mc_recBuffer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        filePanelCard2.add((Component)this.lbRecbuffer, gridBagConstraints);
        this.recBufferEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        filePanelCard2.add((Component)this.recBufferEditor, gridBagConstraints);
        this.lbLength.setText(this.options.getMsg("edit_mc_length"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        filePanelCard2.add((Component)this.lbLength, gridBagConstraints);
        this.lengthEditor.setMax(15);
        this.lengthEditor.setValue(5);
        this.lengthEditor.setMin(1);
        this.lengthEditor.addPropertyChangeListener("value", this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        filePanelCard2.add((Component)this.lengthEditor, gridBagConstraints);
        this.filePanel.add((Component)filePanelCard2, "card2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.filePanel, gridBagConstraints);
        this.fragmentPanel.setLayout(new CardLayout());
        this.fragmentPanel.add((Component)fragmentPanelCard0, "card0");
        fragmentPanelCard1.setLayout(new GridBagLayout());
        this.lbFrom.setLabelFor(this.fromTxt);
        this.lbFrom.setText(this.options.getMsg("edit_mc_from"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fragmentPanelCard1.add((Component)this.lbFrom, gridBagConstraints);
        this.fromTxt.setHorizontalAlignment(4);
        this.fromTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fragmentPanelCard1.add((Component)this.fromTxt, gridBagConstraints);
        this.lbTo.setLabelFor(this.toTxt);
        this.lbTo.setText(this.options.getMsg("edit_mc_to"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fragmentPanelCard1.add((Component)this.lbTo, gridBagConstraints);
        this.toTxt.setHorizontalAlignment(4);
        this.toTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fragmentPanelCard1.add((Component)this.toTxt, gridBagConstraints);
        this.fragmentPanel.add((Component)fragmentPanelCard1, "card1");
        fragmentPanelCard2.setLayout(new GridBagLayout());
        this.lbExternal.setLabelFor(this.externalTxt);
        this.lbExternal.setText(this.options.getMsg("edit_mc_externalParam"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fragmentPanelCard2.add((Component)this.lbExternal, gridBagConstraints);
        this.externalTxt.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        fragmentPanelCard2.add((Component)this.externalTxt, gridBagConstraints);
        this.fragmentPanel.add((Component)fragmentPanelCard2, "card2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.fragmentPanel, gridBagConstraints);
        this.locationPanel.setLayout(new CardLayout());
        this.locationPanel.add((Component)locationPanelCard0, "card0");
        locationPanelCard1.setLayout(new GridBagLayout());
        lpanel.setBorder(BorderFactory.createTitledBorder(this.options.getMsg("edit_mc_location")));
        lpanel.setLayout(new GridBagLayout());
        this.posTypes.add(this.posCellRadio);
        this.posCellRadio.setText(this.options.getMsg("edit_mc_pos_cell"));
        this.posCellRadio.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        lpanel.add((Component)this.posCellRadio, gridBagConstraints);
        this.posTypes.add(this.posWindowRadio);
        this.posWindowRadio.setText(this.options.getMsg("edit_mc_pos_window"));
        this.posWindowRadio.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.posWindowRadio, gridBagConstraints);
        this.posTypes.add(this.posAbsoluteRadio);
        this.posAbsoluteRadio.setText(this.options.getMsg("edit_mc_pos_absolute"));
        this.posAbsoluteRadio.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        lpanel.add((Component)this.posAbsoluteRadio, gridBagConstraints);
        this.lbX.setText(this.options.getMsg("edit_mc_location_x"));
        this.lbX.setLabelFor(this.xTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.lbX, gridBagConstraints);
        this.xTxt.setHorizontalAlignment(4);
        this.xTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.xTxt, gridBagConstraints);
        this.lbY.setText(this.options.getMsg("edit_mc_location_y"));
        this.lbY.setLabelFor(this.yTxt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.lbY, gridBagConstraints);
        this.yTxt.setHorizontalAlignment(4);
        this.yTxt.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.yTxt, gridBagConstraints);
        this.lbLocFrom.setText(this.options.getMsg("edit_mc_location_from"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.lbLocFrom, gridBagConstraints);
        this.locFromCombo.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        lpanel.add((Component)this.locFromCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        locationPanelCard1.add((Component)lpanel, gridBagConstraints);
        this.catchMouseChk.setText(this.options.getMsg("edit_mc_catchmouse"));
        this.catchMouseChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        locationPanelCard1.add((Component)this.catchMouseChk, gridBagConstraints);
        this.stretchChk.setText(this.options.getMsg("edit_mc_stretch"));
        this.stretchChk.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        locationPanelCard1.add((Component)this.stretchChk, gridBagConstraints);
        this.locationPanel.add((Component)locationPanelCard1, "card1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.locationPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    @Override
    public boolean documentChangePerformed(DocumentEvent ev) {
        int v;
        Document doc = ev.getDocument();
        for (v = 0; v < this.textFields.length && this.textFields[v].getDocument() != doc; ++v) {
        }
        if (v < this.textFields.length) {
            return this.eventPerformed(new EventObject(this.textFields[v]));
        }
        return false;
    }

    @Override
    public boolean eventPerformed(EventObject ev) {
        if (ev != null && ev.getSource() != null) {
            this.setInitializing(true);
            MediaContent oldMc = this.getMcClone();
            Object src = ev.getSource();
            if (src == this.levelEditor) {
                this.mc.level = this.levelEditor.getValue();
            } else if (src == this.recBufferEditor) {
                this.mc.recBuffer = this.recBufferEditor.getValue();
            } else if (src == this.lengthEditor) {
                this.mc.length = this.lengthEditor.getValue();
            } else if (src == this.fileTxt) {
                String s = this.fileTxt.getText();
                this.mc.mediaFileName = s.length() > 0 ? s : null;
            } else if (src == this.externalTxt) {
                String s = this.externalTxt.getText();
                this.mc.externalParam = s.length() > 0 ? s : null;
            } else if (src == this.fromTxt) {
                this.mc.from = this.getIntValue(this.fromTxt, -1);
            } else if (src == this.toTxt) {
                this.mc.to = this.getIntValue(this.toTxt, -1);
            } else if (src == this.stretchChk) {
                this.mc.stretch = this.stretchChk.isSelected();
            } else if (src == this.posCellRadio) {
                this.mc.free = false;
                this.mc.absLocation = null;
                this.syncPointValues();
                this.checkEnabled();
            } else if (src == this.posWindowRadio) {
                this.mc.free = true;
                this.mc.absLocation = null;
                this.syncPointValues();
                this.checkEnabled();
            } else if (src == this.posAbsoluteRadio) {
                this.mc.free = false;
                this.mc.absLocation = new Point();
                this.syncPointValues();
                this.checkEnabled();
            } else if (src == this.locFromCombo) {
                this.mc.absLocationFrom = Math.max(0, this.locFromCombo.getSelectedIndex());
            } else if (src == this.xTxt && this.mc.absLocation != null) {
                this.mc.absLocation.x = this.getIntValue(this.xTxt, 0);
            } else if (src == this.yTxt && this.mc.absLocation != null) {
                this.mc.absLocation.y = this.getIntValue(this.yTxt, 0);
            } else if (src == this.loopChk) {
                this.mc.loop = this.loopChk.isSelected();
            } else if (src == this.autostartChk) {
                this.mc.autoStart = this.autostartChk.isSelected();
            } else if (src == this.catchMouseChk) {
                this.mc.catchMouseEvents = this.catchMouseChk.isSelected();
            } else if (src == this.findFileBtn) {
                this.selectBtnPressed();
            } else if (src instanceof JToggleButton) {
                Enumeration<AbstractButton> en = this.mediaTypes.getElements();
                int v = -1;
                int j = 0;
                while (en.hasMoreElements()) {
                    JToggleButton rb = (JToggleButton)en.nextElement();
                    if (rb == src) {
                        v = j;
                        break;
                    }
                    ++j;
                }
                if (v >= 0) {
                    int currentType = this.mc.mediaType;
                    this.mc.mediaType = v;
                    if (this.mc.mediaType != currentType) {
                        MediaContent mc2 = new MediaContent();
                        mc2.mediaType = this.mc.mediaType;
                        this.setMediaContent(mc2);
                    }
                }
            }
            this.checkAndFirePropertyChange(oldMc);
            this.setInitializing(false);
        }
        return true;
    }

    protected void selectBtnPressed() {
        String value = null;
        JList list = null;
        String dlgTitleKey = null;
        if (this.mc.mediaType == 7) {
            list = new JList(this.mbe.getProjectEditor().getActivityBagEditor().getListModel());
            dlgTitleKey = "edit_mc_activity_selection";
        } else if (this.mc.mediaType == 8) {
            list = new JList(this.mbe.getProjectEditor().getActivitySequenceEditor().getTagList());
            dlgTitleKey = "edit_mc_sequence_selection";
        }
        if (list != null) {
            Object o;
            JScrollPane pane = new JScrollPane(list);
            if (this.options.getMessages().showInputDlg(this, pane, dlgTitleKey) && (o = list.getSelectedValue()) != null) {
                value = o.toString();
            }
        } else {
            int filter = this.mc.mediaType == 1 ? 13 : (this.mc.mediaType == 3 ? 14 : (this.mc.mediaType == 2 ? 15 : 20));
            value = MediaBagSelector.getMediaName(this.mc.mediaFileName, this.options, this, this.mbe, filter);
        }
        if (value != null) {
            this.mc.mediaFileName = value;
            this.fileTxt.setText(value);
        }
    }

    protected void checkEnabled() {
        String s;
        boolean bLevel = true;
        boolean bRecBuffer = false;
        boolean bLength = false;
        boolean bFile = false;
        boolean bExternal = false;
        boolean bFrom = false;
        boolean bTo = false;
        boolean bStretch = false;
        boolean bLocation = false;
        boolean bLoop = false;
        boolean bAutostart = true;
        boolean bCatchMouse = false;
        int filePanelItem = 0;
        int fragmentPanelItem = 0;
        int locationPanelItem = 0;
        switch (this.mc.mediaType) {
            case 2: {
                bStretch = true;
                bLocation = true;
                bCatchMouse = true;
                locationPanelItem = 1;
            }
            case 1: 
            case 3: {
                bFile = true;
                bFrom = true;
                bTo = true;
                bLoop = true;
                filePanelItem = 1;
                fragmentPanelItem = 1;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                bLength = true;
            }
            case 6: {
                bRecBuffer = true;
                filePanelItem = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                bExternal = true;
            }
            case 10: {
                bFile = true;
                bLevel = false;
                filePanelItem = 1;
                fragmentPanelItem = 2;
                break;
            }
            case 11: 
            case 12: {
                bLevel = false;
                break;
            }
            default: {
                bLevel = false;
            }
        }
        this.levelEditor.setEnabled(bLevel);
        this.recBufferEditor.setEnabled(bRecBuffer);
        this.lengthEditor.setEnabled(bLength);
        this.fileTxt.setEnabled(bFile);
        this.findFileBtn.setEnabled(bFile);
        this.externalTxt.setEnabled(bExternal);
        this.fromTxt.setEnabled(bFrom);
        this.toTxt.setEnabled(bTo);
        this.stretchChk.setEnabled(bStretch);
        this.posCellRadio.setEnabled(bLocation);
        this.posWindowRadio.setEnabled(bLocation);
        this.posAbsoluteRadio.setEnabled(bLocation);
        this.locFromCombo.setEnabled(bLocation && this.mc.absLocation != null);
        this.xTxt.setEnabled(bLocation && this.mc.absLocation != null);
        this.yTxt.setEnabled(bLocation && this.mc.absLocation != null);
        this.loopChk.setEnabled(bLoop);
        this.autostartChk.setEnabled(bAutostart);
        this.catchMouseChk.setEnabled(bCatchMouse);
        CardLayout cl = (CardLayout)this.filePanel.getLayout();
        cl.show(this.filePanel, "card" + Integer.toString(filePanelItem));
        if (filePanelItem == 1) {
            s = this.mc.mediaType == 7 ? "edit_mc_activity" : (this.mc.mediaType == 8 ? "edit_mc_sequence" : (this.mc.mediaType == 10 ? "edit_mc_url" : "edit_mc_file"));
            this.lbFile.setText(this.options.getMsg(s));
            boolean b = this.mc.mediaType != 10 && this.mc.mediaType != 9;
            this.findFileBtn.setVisible(b);
            this.filePanel.revalidate();
        }
        cl = (CardLayout)this.fragmentPanel.getLayout();
        cl.show(this.fragmentPanel, "card" + Integer.toString(fragmentPanelItem));
        if (fragmentPanelItem == 2) {
            s = this.mc.mediaType == 7 || this.mc.mediaType == 8 ? "edit_mc_project" : "edit_mc_externalParam";
            this.lbExternal.setText(this.options.getMsg(s));
            this.fragmentPanel.revalidate();
        }
        cl = (CardLayout)this.locationPanel.getLayout();
        cl.show(this.locationPanel, "card" + Integer.toString(locationPanelItem));
    }

    private void syncPointValues() {
        Point p = this.mc.absLocation;
        if (p == null) {
            p = new Point();
        }
        this.xTxt.setText(Integer.toString(p.x));
        this.yTxt.setText(Integer.toString(p.y));
        this.locFromCombo.setSelectedIndex(this.mc.absLocationFrom);
    }

    protected int getIntValue(JTextField txf, int defaultValue) {
        String s = txf.getText();
        int result = defaultValue;
        try {
            result = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static MediaContent getMediaContent(MediaContent initialMc, Component parent, Options options, MediaBagEditor mbe) {
        MediaContent result = null;
        Messages msg = options.getMessages();
        MediaContentEditor mce = panels.get(options);
        if (mce == null) {
            mce = new MediaContentEditor(options, initialMc, mbe);
            panels.put(options, mce);
        } else {
            mce.setMediaBagEditor(mbe);
            mce.setMediaContent(initialMc);
        }
        if (msg.showInputDlg(parent, mce, "edit_mc_title") && mce.check(parent)) {
            result = mce.getMc();
        }
        return result;
    }

    public static boolean nameChanged(MediaContent mc, int type, String oldName, String newName) {
        boolean result = false;
        if ((type & 0x47F6) != 0 && oldName.equals(mc.mediaFileName)) {
            mc.mediaFileName = newName;
            result = true;
        }
        return result;
    }
}

