/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.EditableLine2D;
import edu.xtec.jclic.shapers.EditableShape;
import edu.xtec.jclic.shapers.EditableShapeConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class EditableRectangle
extends Rectangle2D.Double
implements EditableShape,
Cloneable {
    protected boolean selected = false;
    protected int border = -1;
    private int selectedBorder = -1;
    protected Point2D p1;
    protected Point2D p2;
    protected Point2D p3;
    protected Point2D p4;
    protected Point2D lastP1;
    protected Point2D lastP2;

    public EditableRectangle(Point2D ini, Point2D end) {
        this.setLimits(ini, end);
    }

    public EditableRectangle(int x, int y, int width, int height) {
        this.setLimits(x, y, width, height);
    }

    public void setLimits(int x, int y, int width, int height) {
        if (width < 0) {
            x -= (width *= -1);
        }
        if (height < 0) {
            y -= (height *= -1);
        }
        this.p1 = new Point2D.Double(x, y);
        this.p2 = new Point2D.Double(x + width, y + height);
        this.p3 = new Point2D.Double();
        this.p4 = new Point2D.Double();
        this.lastP1 = new Point2D.Double(1.0, 1.0);
        this.lastP2 = new Point2D.Double(1.0, 1.0);
        this.setRect(this.p1, this.p2);
    }

    public void setLimits(Point2D ini, Point2D end) {
        this.p1 = new Point2D.Double();
        this.p2 = new Point2D.Double();
        this.p3 = new Point2D.Double();
        this.p4 = new Point2D.Double();
        this.lastP1 = new Point2D.Double(1.0, 1.0);
        this.lastP2 = new Point2D.Double(1.0, 1.0);
        this.setRect(ini, end);
    }

    @Override
    public EditableShape[] divide(double x, double y) {
        return this.divide(x, y, true);
    }

    public EditableShape[] divide(double x, double y, boolean newPoint) {
        EditableShape[] lines = new EditableShape[5];
        lines[0] = new EditableLine2D(this.p1, this.p3);
        lines[1] = new EditableLine2D(this.p3, this.p2);
        lines[2] = new EditableLine2D(this.p2, this.p4);
        lines[3] = new EditableLine2D(this.p4, this.p1);
        if (newPoint) {
            double minDist = ((EditableLine2D)lines[0]).ptLineDistSq(x, y);
            int nearestLine = 0;
            for (int i = 1; i < 4; i = (int)((short)(i + 1))) {
                double dist = ((EditableLine2D)lines[i]).ptLineDistSq(x, y);
                if (!(dist < minDist)) continue;
                minDist = dist;
                nearestLine = i;
            }
            Point2D.Double p = new Point2D.Double(x, y);
            Point2D p1 = ((EditableLine2D)lines[nearestLine]).getP1();
            Point2D p2 = ((EditableLine2D)lines[nearestLine]).getP2();
            lines[nearestLine] = new EditableLine2D(p1, p);
            lines[4] = new EditableLine2D(p, p2);
        }
        return lines;
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    @Override
    public double distanceTo(double x, double y) {
        double d4;
        double d3;
        double d6;
        double d2;
        Line2D.Double l1 = new Line2D.Double(this.p1, this.p3);
        Line2D.Double l2 = new Line2D.Double(this.p3, this.p2);
        Line2D.Double l3 = new Line2D.Double(this.p2, this.p4);
        Line2D.Double l4 = new Line2D.Double(this.p4, this.p1);
        double d1 = l1.ptLineDistSq(x, y);
        double d5 = d1 < (d2 = l2.ptLineDistSq(x, y)) ? d1 : d2;
        if (d5 < (d6 = (d3 = l3.ptLineDistSq(x, y)) < (d4 = l4.ptLineDistSq(x, y)) ? d3 : d4)) {
            return d5;
        }
        return d6;
    }

    @Override
    public boolean hasClickedBorder(double x, double y, boolean needSelected) {
        boolean hasClicked = false;
        if (!needSelected || this.selected) {
            Rectangle r1 = new Rectangle((int)this.p1.getX() - EditableShapeConstants.selectLength / 2, (int)this.p1.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle r2 = new Rectangle((int)this.p2.getX() - EditableShapeConstants.selectLength / 2, (int)this.p2.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle r3 = new Rectangle((int)this.p3.getX() - EditableShapeConstants.selectLength / 2, (int)this.p3.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            Rectangle r4 = new Rectangle((int)this.p4.getX() - EditableShapeConstants.selectLength / 2, (int)this.p4.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
            if (r1.contains(x, y)) {
                this.border = 1;
                hasClicked = true;
            } else if (r2.contains(x, y)) {
                this.border = 2;
                hasClicked = true;
            } else if (r3.contains(x, y)) {
                this.border = 3;
                hasClicked = true;
            } else if (r4.contains(x, y)) {
                this.border = 4;
                hasClicked = true;
            }
        }
        return hasClicked;
    }

    @Override
    public void paintSelection(Graphics g) {
        g.setColor(Color.black);
        this.drawBorders(g);
        g.setColor(EditableShapeConstants.selectedColor);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void aproximateNearestBorder(double x, double y) {
        boolean b = this.hasClickedBorder(x, y, false);
        this.changeBorder(x, y);
    }

    @Override
    public void paintWithColor(Graphics g, int drawingMode, Color c) {
        g.setColor(EditableShapeConstants.BORDER_COLOR);
        this.drawBorders(g);
        if (this.selected) {
            this.paintSelection(g);
        } else if (drawingMode == 4) {
            g.setColor(Color.red);
            this.drawBorders(g);
            g.setColor(c);
        } else {
            g.setColor(c);
        }
        g.drawRect((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    @Override
    public void transform(AffineTransform aTransf) {
        aTransf.transform(this.p1, this.p1);
        aTransf.transform(this.p2, this.p2);
        this.setRect(this.p1, this.p2);
    }

    @Override
    public boolean isAdjacentTo(Point2D p) {
        return p.equals(this.p1) || p.equals(this.p2) || p.equals(this.p3) || p.equals(this.p4);
    }

    @Override
    public boolean isInto(Rectangle2D r) {
        return r.intersects(this);
    }

    @Override
    public Point2D getEndPoint() {
        return this.p2;
    }

    private void setRect(Point2D ini, Point2D end) {
        if (!this.lastP1.equals(ini) || !this.lastP2.equals(end)) {
            this.p1 = ini;
            this.p2 = end;
            this.p3.setLocation(this.p2.getX(), this.p1.getY());
            this.p4.setLocation(this.p1.getX(), this.p2.getY());
            double x = Math.min(this.p1.getX(), this.p2.getX());
            double y = Math.min(this.p1.getY(), this.p2.getY());
            double width = Math.abs(this.p2.getX() - this.p1.getX());
            double height = Math.abs(this.p2.getY() - this.p1.getY());
            this.setRect(x, y, width, height);
            this.lastP1 = (Point2D)this.p1.clone();
            this.lastP2 = (Point2D)this.p2.clone();
        }
    }

    @Override
    public void changeBorder(double x, double y) {
        Point2D.Double newPoint = new Point2D.Double(x, y);
        if (this.border == 1) {
            this.setRect(newPoint, this.p2);
        } else if (this.border == 2) {
            this.setRect(this.p1, newPoint);
        } else if (this.border == 3) {
            this.p1.setLocation(this.p1.getX(), ((Point2D)newPoint).getY());
            this.p2.setLocation(((Point2D)newPoint).getX(), this.p2.getY());
            this.setRect(this.p1, this.p2);
        } else if (this.border == 4) {
            this.p1.setLocation(((Point2D)newPoint).getX(), this.p1.getY());
            this.p2.setLocation(this.p2.getX(), ((Point2D)newPoint).getY());
            this.setRect(this.p1, this.p2);
        }
    }

    @Override
    public void drawBorders(Graphics g) {
        g.drawRect((int)this.p1.getX() - EditableShapeConstants.selectLength / 2, (int)this.p1.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        g.drawRect((int)this.p2.getX() - EditableShapeConstants.selectLength / 2, (int)this.p2.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        g.drawRect((int)this.p3.getX() - EditableShapeConstants.selectLength / 2, (int)this.p3.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        g.drawRect((int)this.p4.getX() - EditableShapeConstants.selectLength / 2, (int)this.p4.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        g.setColor(EditableShapeConstants.SELECTED_BORDER_COLOR);
        if (this.selectedBorder == 1) {
            g.fillRect((int)this.p1.getX() - EditableShapeConstants.selectLength / 2, (int)this.p1.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 2) {
            g.fillRect((int)this.p2.getX() - EditableShapeConstants.selectLength / 2, (int)this.p2.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 3) {
            g.fillRect((int)this.p3.getX() - EditableShapeConstants.selectLength / 2, (int)this.p3.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        } else if (this.selectedBorder == 4) {
            g.fillRect((int)this.p4.getX() - EditableShapeConstants.selectLength / 2, (int)this.p4.getY() - EditableShapeConstants.selectLength / 2, EditableShapeConstants.selectLength, EditableShapeConstants.selectLength);
        }
    }

    @Override
    public Point2D getInitialPoint() {
        return this.getLocation();
    }

    @Override
    public void paint(Graphics g, int drawingMode) {
        this.paintWithColor(g, drawingMode, EditableShapeConstants.defaultColor);
    }

    @Override
    public Point2D getNearestBorder(double x, double y) {
        double d1 = this.p1.distance(x, y);
        double d2 = this.p2.distance(x, y);
        double d3 = this.p3.distance(x, y);
        double d4 = this.p4.distance(x, y);
        Point2D p5 = d1 < d2 ? this.p1 : this.p2;
        Point2D p6 = d3 < d4 ? this.p3 : this.p4;
        if (p5.distance(x, y) < p6.distance(x, y)) {
            return p5;
        }
        return p6;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public Object clone() {
        return new EditableRectangle(this.getLocation(), new Point2D.Double(this.getLocation().getX() + this.getWidth(), this.getLocation().getY() + this.getHeight()));
    }

    @Override
    public Point2D[] getBorders() {
        return new Point2D[]{this.p1, this.p2, this.p3, this.p4};
    }

    @Override
    public void selectBorder(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        this.selectedBorder = this.p1.equals(p) ? 1 : (this.p2.equals(p) ? 2 : (this.p3.equals(p) ? 3 : (this.p4.equals(p) ? 4 : -1)));
    }

    @Override
    public void deselectBorder() {
        this.selectedBorder = -1;
    }

    @Override
    public boolean hasSelectedBorder() {
        return this.selectedBorder != -1;
    }

    @Override
    public Point2D getNotSelectedBorder() {
        if (this.selectedBorder == 1) {
            return this.p1;
        }
        if (this.selectedBorder == 2) {
            return this.p2;
        }
        if (this.selectedBorder == 3) {
            return this.p3;
        }
        return this.p4;
    }
}

