/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MenuEditorPanel
extends EditorPanel {
    private JTextField captionText;
    private JPanel mainPanel;

    public MenuEditorPanel(Options options) {
        super(options);
        MenuEditor.createActions(options);
        this.initComponents();
        this.postInit(250, true, true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel captionLb = new JLabel();
        this.captionText = new JTextField();
        this.captionText.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setOpaque(false);
        captionLb.setLabelFor(this.captionText);
        captionLb.setText(this.options.getMsg("edit_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)captionLb, gridBagConstraints);
        this.captionText.setToolTipText(this.options.getMsg("menu_dlg_name_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.captionText, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    @Override
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof MenuEditor;
    }

    protected MenuEditor getMenuEditor() {
        return (MenuEditor)this.editor;
    }

    protected Menu getMenu() {
        if (this.editor == null) {
            return null;
        }
        return this.getMenuEditor().getMenu();
    }

    @Override
    public void fillData() {
        Menu m = this.getMenu();
        this.captionText.setText(m == null ? "" : m.description);
    }

    @Override
    public void saveData() {
        Menu m = this.getMenu();
        if (m != null) {
            this.getMenuEditor().setDescription(this.captionText.getText());
        }
    }

    @Override
    protected Icon getIcon() {
        return MenuEditor.getIcon();
    }

    @Override
    protected String getTitle() {
        return this.options.getMsg("menu_dlg_title");
    }

    @Override
    protected void addActionsTo(Container cnt) {
        cnt.add(new SmallButton(MenuEditor.newMenuElementAction));
        cnt.add(new SmallButton(MenuEditor.newMenuAction));
        cnt.add(new SmallButton(Editor.moveUpAction));
        cnt.add(new SmallButton(Editor.moveDownAction));
        cnt.add(new SmallButton(Editor.copyAction));
        cnt.add(new SmallButton(Editor.cutAction));
        cnt.add(new SmallButton(Editor.pasteAction));
        cnt.add(new SmallButton(Editor.deleteAction));
    }
}

