/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.textGrid;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.boxes.TextGrid;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import org.jdom.Element;

public class WordSearch
extends Activity
implements ActiveBagContentKit.Compatible {
    String[] clues;
    int[] clueItems;

    public WordSearch(JClicProject project) {
        super(project);
        this.boxGridPos = 0;
        this.abc = new ActiveBagContent[1];
        this.clues = null;
        this.clueItems = null;
    }

    @Override
    public void initNew() {
        super.initNew();
        this.clues = new String[0];
        this.clueItems = new int[0];
        this.tgc = TextGridContent.initNew(3, 3, 'A');
    }

    @Override
    public Element getJDomElement() {
        if (this.clues == null || this.tgc == null) {
            return null;
        }
        Element e = super.getJDomElement();
        e.addContent(this.tgc.getJDomElement());
        Element ex = new Element("clues");
        for (int i = 0; i < this.clues.length; ++i) {
            Element ex2 = new Element("clue");
            ex2.setAttribute("id", Integer.toString(this.clueItems[i]));
            ex2.setText(this.clues[i]);
            ex.addContent(ex2);
        }
        e.addContent(ex);
        if (this.abc[0] != null) {
            e.addContent(this.abc[0].getJDomElement().setAttribute("id", "secondary"));
            ex = new Element("layout");
            ex.setAttribute("position", LAYOUT_NAMES[this.boxGridPos]);
            e.addContent(ex);
            if (this.scramble[0]) {
                ex = new Element("scramble");
                ex.setAttribute("times", Integer.toString(this.shuffles));
                ex.setAttribute("secondary", JDomUtility.boolString(this.scramble[0]));
                e.addContent(ex);
            }
        }
        return e;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        super.setProperties(e, aux);
        Element child = e.getChild("textGrid");
        if (child == null) {
            throw new IllegalArgumentException("WordSearch without TextGridContent!");
        }
        this.tgc = TextGridContent.getTextGridContent(child);
        child = e.getChild("clues");
        if (child == null) {
            throw new IllegalArgumentException("WordSearch without clues!");
        }
        List cluesList = child.getChildren("clue");
        int numClues = cluesList.size();
        this.clues = new String[numClues];
        this.clueItems = new int[numClues];
        for (int i = 0; i < numClues; ++i) {
            Element child2 = (Element)cluesList.get(i);
            this.clueItems[i] = JDomUtility.getIntAttr(child2, "id", i);
            this.clues[i] = child2.getText();
        }
        child = e.getChild("cells");
        if (child != null) {
            if (!"secondary".equals(child.getAttributeValue("id"))) {
                throw new IllegalArgumentException("WordSearch expects only \"secondary\" BagContent!");
            }
            this.abc[0] = ActiveBagContent.getActiveBagContent(child, this.project.mediaBag);
            child = e.getChild("scramble");
            if (child != null) {
                this.shuffles = JDomUtility.getIntAttr(child, "times", this.shuffles);
                this.scramble[0] = JDomUtility.getBoolAttr(child, "secondary", this.scramble[0]);
            } else {
                this.scramble[0] = false;
            }
        } else {
            this.abc[0] = null;
        }
        child = e.getChild("layout");
        if (child != null) {
            this.boxGridPos = JDomUtility.getStrIndexAttr(child, "position", LAYOUT_NAMES, this.boxGridPos);
        }
    }

    @Override
    public void setProperties(Clic3Activity c3a) throws Exception {
        super.setProperties(c3a);
        this.boxGridPos = c3a.graPos;
        this.tgc = new TextGridContent();
        this.tgc.nch = c3a.nctxh;
        this.tgc.ncw = c3a.nctxw;
        this.tgc.w = c3a.txtCW;
        this.tgc.h = c3a.txtCH;
        this.tgc.border = c3a.delim[1];
        this.tgc.text = c3a.graTxt;
        this.clues = c3a.tags[0];
        this.clueItems = new int[this.clues.length];
        for (int i = 0; i < this.clues.length; ++i) {
            this.clueItems[i] = i;
        }
        this.tgc.bb = c3a.getBoxBase(0);
        if (c3a.bar[0]) {
            c3a.txtCW = c3a.txtCW2;
            c3a.txtCH = c3a.txtCH2;
            this.abc[0] = c3a.createActiveBagContent(0);
            this.abc[0].setBoxBase(c3a.getBoxBase(1));
        } else {
            this.abc[0] = null;
        }
    }

    @Override
    public int getMinNumActions() {
        return this.clues.length;
    }

    @Override
    public boolean helpSolutionAllowed() {
        return true;
    }

    @Override
    public boolean hasRandom() {
        return true;
    }

    @Override
    public Activity.Panel getActivityPanel(PlayStation ps) {
        return new Panel(ps);
    }

    public String[] getClues() {
        return this.clues;
    }

    public void setClues(String[] cl, int[] clItems) {
        this.clues = cl;
        if (this.clues == null) {
            this.clues = new String[0];
        }
        this.clueItems = clItems;
        if (this.clueItems == null || this.clueItems.length != this.clues.length) {
            this.clueItems = new int[this.clues.length];
            for (int i = 0; i < this.clueItems.length; ++i) {
                this.clueItems[i] = i;
            }
        }
    }

    class Panel
    extends Activity.Panel {
        TextGrid grid;
        ActiveBoxBag bgAlt;
        boolean[] resolvedClues;

        protected Panel(PlayStation ps) {
            super(ps);
            this.bc = new BoxConnector(this);
            this.resolvedClues = new boolean[WordSearch.this.clues.length];
            this.grid = null;
            this.bgAlt = null;
        }

        @Override
        public void clear() {
            if (this.grid != null) {
                this.grid.end();
                this.grid = null;
            }
            if (this.bgAlt != null) {
                this.bgAlt.end();
                this.bgAlt = null;
            }
        }

        @Override
        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (WordSearch.this.acp != null && WordSearch.this.abc != null) {
                WordSearch.this.acp.generateContent(new ActiveBagContentKit(0, 0, WordSearch.this.abc, false), this.ps);
            }
            if (WordSearch.this.tgc != null) {
                this.grid = TextGrid.createEmptyGrid(null, this, WordSearch.this.margin, WordSearch.this.margin, WordSearch.this.tgc, false);
                if (WordSearch.this.abc[0] != null) {
                    this.bgAlt = ActiveBoxGrid.createEmptyGrid(null, this, WordSearch.this.margin, WordSearch.this.margin, WordSearch.this.abc[0]);
                }
                this.grid.setVisible(true);
                this.invalidate();
            }
        }

        @Override
        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            } else {
                this.firstRun = false;
            }
            this.setAndPlayMsg(1, 0);
            if (this.grid != null) {
                this.grid.setChars(WordSearch.this.tgc.text);
                this.grid.randomize();
                this.grid.setAllCellsAttribute(1, false);
                for (int i = 0; i < WordSearch.this.clueItems.length; ++i) {
                    this.resolvedClues[i] = false;
                }
                if (this.bgAlt != null) {
                    this.bgAlt.setContent(WordSearch.this.abc[0]);
                    if (WordSearch.this.scramble[0]) {
                        this.shuffle(new ActiveBoxBag[]{this.bgAlt}, true, true);
                    }
                    this.bgAlt.setVisible(false);
                }
                this.playing = true;
            }
        }

        public int getCurrentScore() {
            int result = 0;
            if (WordSearch.this.clues != null) {
                for (int i = 0; i < WordSearch.this.clues.length; ++i) {
                    if (!this.resolvedClues[i]) continue;
                    ++result;
                }
            }
            return result;
        }

        @Override
        public void render(Graphics2D g2, Rectangle dirtyRegion) {
            if (this.grid != null) {
                this.grid.update(g2, dirtyRegion, this);
            }
            if (this.bgAlt != null) {
                this.bgAlt.update(g2, dirtyRegion, this);
            }
            if (this.bc.active) {
                this.bc.update(g2, dirtyRegion, this);
            }
        }

        @Override
        public Dimension setDimension(Dimension preferredMaxSize) {
            if (this.grid == null || this.getSize().equals(preferredMaxSize)) {
                return preferredMaxSize;
            }
            if (this.bgAlt != null) {
                return BoxBag.layoutDouble(preferredMaxSize, this.grid, this.bgAlt, WordSearch.this.boxGridPos, WordSearch.this.margin);
            }
            return BoxBag.layoutSingle(preferredMaxSize, this.grid, WordSearch.this.margin);
        }

        @Override
        public void processMouse(MouseEvent e) {
            Point p = e.getPoint();
            boolean m = false;
            if (this.playing) {
                switch (e.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            this.bc.end();
                            Point pt1 = this.grid.getLogicalCoords(this.bc.origin);
                            Point pt2 = this.grid.getLogicalCoords(this.bc.dest);
                            if (pt1 == null || pt2 == null) break;
                            String s = this.grid.getStringBetween(pt1.x, pt1.y, pt2.x, pt2.y);
                            if (s != null && s.length() > 0) {
                                int c;
                                boolean ok = false;
                                boolean repeated = false;
                                for (c = 0; c < WordSearch.this.clues.length; ++c) {
                                    if (!s.equals(WordSearch.this.clues[c])) continue;
                                    ok = true;
                                    break;
                                }
                                if (ok && !(repeated = this.resolvedClues[c])) {
                                    ActiveBox bx;
                                    int k;
                                    this.resolvedClues[c] = true;
                                    this.grid.setAttributeBetween(pt1.x, pt1.y, pt2.x, pt2.y, 1, true);
                                    if (this.bgAlt != null && (k = WordSearch.this.clueItems[c]) >= 0 && k < this.bgAlt.getNumCells() && (bx = this.bgAlt.getActiveBox(WordSearch.this.clueItems[c])) != null) {
                                        bx.setVisible(true);
                                        m = bx.playMedia(this.ps);
                                    }
                                }
                                if (!repeated) {
                                    int r = this.getCurrentScore();
                                    this.ps.reportNewAction(this.getActivity(), "SELECT", s, null, ok, r);
                                    if (r == WordSearch.this.clues.length) {
                                        this.finishActivity(true);
                                        break;
                                    }
                                    if (m) break;
                                    this.playEvent(ok ? 3 : 2);
                                    break;
                                }
                                if (ok || m) break;
                                this.playEvent(2);
                                break;
                            }
                            this.playEvent(2);
                            break;
                        }
                        if (!this.grid.contains(p)) break;
                        this.playEvent(1);
                        this.bc.begin(p);
                        break;
                    }
                    case 503: 
                    case 506: {
                        if (!this.bc.active) break;
                        this.bc.moveTo(p);
                    }
                }
            }
        }

        @Override
        public void showHelp() {
            if (!WordSearch.this.helpWindowAllowed() || this.grid == null) {
                return;
            }
            HelpActivityComponent hac = null;
            if (WordSearch.this.showSolution) {
                hac = new HelpActivityComponent(this){
                    JScrollPane scrollPane;
                    JList cluesList;
                    {
                        this.scrollPane = null;
                        this.cluesList = null;
                    }

                    @Override
                    public void render(Graphics2D g2, Rectangle dirtyRegion) {
                    }

                    @Override
                    public void init() {
                        this.cluesList = new JList<String>(WordSearch.this.clues);
                        this.cluesList.setSelectionMode(0);
                        this.cluesList.addListSelectionListener(this);
                        this.scrollPane = new JScrollPane(this.cluesList);
                        this.add(this.scrollPane);
                        Dimension size = Panel.this.grid.getBounds().getSize();
                        this.scrollPane.setBounds(8, 8, size.width, size.height);
                        size.width += 16;
                        size.height += 16;
                        this.setPreferredSize(size);
                        this.setMaximumSize(size);
                        this.setMinimumSize(size);
                        Point p = (Point)this.getClientProperty("prefLoc");
                        if (p != null) {
                            p.translate((int)Panel.this.grid.x - 8, (int)Panel.this.grid.y - 8);
                        }
                    }

                    @Override
                    public void doLayout() {
                        Rectangle r = this.getBounds();
                        if (this.scrollPane != null) {
                            this.scrollPane.setBounds(8, 8, r.width - 16, r.height - 16);
                        }
                    }

                    @Override
                    public void valueChanged(ListSelectionEvent ev) {
                        if (Panel.this.bgAlt != null && !ev.getValueIsAdjusting()) {
                            int i = this.cluesList.getSelectedIndex();
                            if (i < 0) {
                                this.unmarkBox();
                            } else {
                                Panel.this.playEvent(1);
                                this.markBox(Panel.this.bgAlt.getActiveBox(WordSearch.this.clueItems[i]), true);
                            }
                        }
                    }
                };
                hac.init();
            }
            if (this.ps.showHelp(hac, WordSearch.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.getCurrentScore());
            }
            if (hac != null) {
                hac.end();
            }
        }
    }
}

