/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation;

import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import java.lang.reflect.Method;
import java.util.Map;
import org.jdom.Element;

public abstract class AutoContentProvider
implements Domable,
Editable {
    public static final String ELEMENT_NAME = "automation";
    public static final String BASE_CLASS = "edu.xtec.jclic.automation.";
    public static final String BASE_CLASS_TAG = "@";
    private static final Class[] ARRAY_OF_CLASS = new Class[]{Class.class};

    @Override
    public abstract void setProperties(Element var1, Object var2) throws Exception;

    public boolean setClic3Properties(byte[] data) {
        return false;
    }

    public static AutoContentProvider getAutoContentProvider(Element e) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        String className = JDomUtility.getClassName(e);
        AutoContentProvider acp = AutoContentProvider.getAutoContentProvider(className);
        if (acp != null) {
            acp.setProperties(e, null);
        }
        return acp;
    }

    public static AutoContentProvider getAutoContentProvider(String className) throws Exception {
        Object acp = null;
        Class providerClass = AutoContentProvider.getAutoContentProviderClass(className);
        return (AutoContentProvider)providerClass.newInstance();
    }

    public static Class getAutoContentProviderClass(String className) throws Exception {
        if (className.startsWith(BASE_CLASS_TAG)) {
            className = BASE_CLASS + className.substring(1);
        }
        Class<?> providerClass = Class.forName(className);
        return providerClass;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute("class", this.getShortClassName());
        return e;
    }

    public String getShortClassName() {
        String result = this.getClass().getName();
        if (result.startsWith(BASE_CLASS)) {
            result = BASE_CLASS_TAG + result.substring(BASE_CLASS.length());
        }
        return result;
    }

    public void init(ResourceBridge rb, FileSystem fs) {
        this.init(rb);
    }

    public void init(ResourceBridge rb) {
    }

    public abstract boolean generateContent(Object var1, ResourceBridge var2);

    @Override
    public Editor getEditor(Editor parent) {
        Object result = null;
        String s = this.getClass().getName() + "Editor";
        try {
            Class.forName(s);
        }
        catch (ClassNotFoundException ex) {
            s = "edu.xtec.jclic.automation.AutoContentProviderEditor";
        }
        return Editor.createEditor(s, this, parent);
    }

    public static boolean checkClient(String contentProviderClassName, Class clientClass) {
        boolean result = false;
        try {
            Object o;
            Class contentProviderClass = AutoContentProvider.getAutoContentProviderClass(contentProviderClassName);
            Method method = contentProviderClass.getMethod("checkClient", ARRAY_OF_CLASS);
            if (method != null && (o = method.invoke(null, (Object[])new Class[]{clientClass})) instanceof Boolean) {
                result = (Boolean)o;
            }
        }
        catch (Exception ex) {
            System.err.println("Error checking class:\n" + ex);
        }
        return result;
    }

    public static void listReferences(Element e, Map<String, String> map) throws Exception {
        AutoContentProvider acp = AutoContentProvider.getAutoContentProvider(e);
        if (acp != null) {
            acp.innerListReferences(map);
        }
    }

    public void innerListReferences(Map<String, String> map) throws Exception {
    }
}

