/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.bags.ConditionalJumpInfo;
import edu.xtec.jclic.bags.JumpInfo;
import edu.xtec.util.JDomUtility;
import java.util.Map;
import org.jdom.Element;

public class ActivitySequenceJump
extends JumpInfo
implements Cloneable {
    public ConditionalJumpInfo upperJump = null;
    public ConditionalJumpInfo lowerJump = null;
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String UPPER = "upper";
    public static final String LOWER = "lower";

    public ActivitySequenceJump(int action) {
        this(action, null);
    }

    public ActivitySequenceJump(int action, String sequence) {
        super(action, sequence);
    }

    public Element getJDomElement(String id) {
        Element child;
        Element e = super.getJDomElement();
        e.setAttribute(ID, id);
        if (this.upperJump != null) {
            child = this.upperJump.getJDomElement();
            child.setAttribute(ID, UPPER);
            e.addContent(child);
        }
        if (this.lowerJump != null) {
            child = this.lowerJump.getJDomElement();
            child.setAttribute(ID, LOWER);
            e.addContent(child);
        }
        return e;
    }

    public static ActivitySequenceJump getActivitySequenceJump(Element e) throws Exception {
        ActivitySequenceJump asj = new ActivitySequenceJump(1);
        asj.setProperties(e, null);
        return asj;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, "jump");
        String s = e.getAttributeValue(NAME);
        if (s == null) {
            super.setProperties(e, aux);
            Element child = JDomUtility.getChildWithId(e, "jump", UPPER);
            if (child != null) {
                this.upperJump = ConditionalJumpInfo.getConditionalJumpInfo(child);
            }
            if ((child = JDomUtility.getChildWithId(e, "jump", LOWER)) != null) {
                this.lowerJump = ConditionalJumpInfo.getConditionalJumpInfo(child);
            }
        } else {
            String sq;
            int t;
            int v;
            Element child;
            if (!s.equals(actions[1])) {
                if (s.equals(actions[3])) {
                    this.action = 3;
                } else {
                    this.action = 0;
                    this.sequence = s;
                }
            }
            if ((child = e.getChild(UPPER)) != null) {
                v = JDomUtility.getIntAttr(child, "threshold", 0);
                t = JDomUtility.getIntAttr(child, "time", -1);
                sq = child.getText();
                this.upperJump = new ConditionalJumpInfo(0, sq, v, t);
            }
            if ((child = e.getChild(LOWER)) != null) {
                v = JDomUtility.getIntAttr(child, "threshold", 0);
                t = JDomUtility.getIntAttr(child, "time", -1);
                sq = child.getText();
                this.lowerJump = new ConditionalJumpInfo(0, sq, v, t);
            }
        }
    }

    public void setConditionalJump(ConditionalJumpInfo jump, boolean upper) {
        if (upper) {
            this.upperJump = jump;
        } else {
            this.lowerJump = jump;
        }
    }

    public JumpInfo resolveJump(int rating, int time) {
        if (rating < 0 || time < 0) {
            return this;
        }
        if (this.upperJump != null && rating > this.upperJump.threshold && (this.upperJump.time <= 0 || time < this.upperJump.time)) {
            return this.upperJump;
        }
        if (this.lowerJump != null && (rating < this.lowerJump.threshold || this.lowerJump.time > 0 && time > this.lowerJump.time)) {
            return this.lowerJump;
        }
        return this;
    }

    @Override
    public void listReferences(String type, Map<String, String> map) {
        super.listReferences(type, map);
        if (this.upperJump != null) {
            this.upperJump.listReferences(type, map);
        }
        if (this.lowerJump != null) {
            this.lowerJump.listReferences(type, map);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ActivitySequenceJump result = (ActivitySequenceJump)super.clone();
        if (this.upperJump != null) {
            result.upperJump = (ConditionalJumpInfo)this.upperJump.clone();
        }
        if (this.lowerJump != null) {
            result.lowerJump = (ConditionalJumpInfo)this.lowerJump.clone();
        }
        return result;
    }
}

