/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.bags;

import edu.xtec.jclic.edit.Editable;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.ico.ICODecoder;
import org.jdom.Element;

public class MediaBagElement
implements Editable,
Domable,
Comparable {
    private String name;
    private String fileName;
    private int usageCount;
    private Object data;
    public boolean projectFlag;
    public boolean saveFlag;
    public boolean animated;
    private boolean hasThumb;
    private String metadata;
    public static final String ELEMENT_NAME = "media";
    public static final String FILE = "file";
    public static final String NAME = "name";
    public static final String SAVE = "save";
    public static final String USAGE = "usage";
    public static final String ANIMATED = "animated";
    private static int imgReadyFlag = 3;

    public MediaBagElement(String fileName) {
        this(fileName, null);
    }

    public MediaBagElement(String fileName, Object data) {
        this(fileName, data, fileName);
    }

    public MediaBagElement(String fileName, Object data, String name) {
        this.setName(name);
        this.setFileName(fileName);
        this.setData(data);
        this.usageCount = 0;
        this.animated = false;
        this.saveFlag = true;
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(NAME, this.name);
        e.setAttribute(FILE, this.fileName);
        if (!this.saveFlag) {
            e.setAttribute(SAVE, JDomUtility.BOOL_STR[0]);
        }
        if (this.usageCount > 0) {
            e.setAttribute(USAGE, Integer.toString(this.usageCount));
        }
        if (this.animated) {
            e.setAttribute(ANIMATED, JDomUtility.BOOL_STR[1]);
        }
        return e;
    }

    protected static MediaBagElement getMediaBagElement(Element e) throws Exception {
        MediaBagElement mb = new MediaBagElement("NONAME", null);
        mb.setProperties(e, null);
        return mb;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.setName(JDomUtility.getStringAttr(e, NAME, this.name, false));
        this.setFileName(JDomUtility.getStringAttr(e, FILE, this.fileName, false));
        this.saveFlag = JDomUtility.getBoolAttr(e, SAVE, true);
        this.usageCount = JDomUtility.getIntAttr(e, USAGE, this.usageCount);
        this.animated = JDomUtility.getBoolAttr(e, ANIMATED, false);
    }

    @Override
    public Editor getEditor(Editor parent) {
        return Editor.createEditor(this.getClass().getName() + "Editor", this, parent);
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void setFileName(String sName) {
        this.fileName = FileSystem.stdFn(sName);
        this.data = null;
        this.animated = false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMetaData(String meta) {
        this.metadata = meta;
    }

    public String getMetaData() {
        return this.metadata;
    }

    public boolean isImage() {
        return Utils.getFileType(this.fileName) == 0;
    }

    public void setData(Object sData) {
        this.data = sData;
        if (this.data != null && this.data instanceof Image) {
            Toolkit.getDefaultToolkit().prepareImage((Image)this.data, -1, -1, null);
        }
    }

    public void clearData() {
        if (this.data != null && !(this.data instanceof Font)) {
            if (this.data instanceof Image) {
                ((Image)this.data).flush();
            }
            this.setData(null);
        }
    }

    public Object getData() {
        return this.data;
    }

    public boolean isInternal() {
        return this.data != null;
    }

    public void incUsageCount() {
        ++this.usageCount;
    }

    public void decUsageCount() {
        --this.usageCount;
    }

    public boolean isUsed() {
        return this.usageCount <= 0;
    }

    protected void finalize() throws Throwable {
        Image img = this.getImage();
        if (img != null) {
            img.flush();
        }
        this.data = null;
        super.finalize();
    }

    public boolean prepareImage(FileSystem fs) throws Exception {
        boolean result = false;
        if (this.isImage()) {
            if (this.data == null || !(this.data instanceof Image)) {
                String fn = this.fileName.toLowerCase();
                if (fn.endsWith(".bmp")) {
                    BufferedImage img = BMPDecoder.read(fs.getInputStream(this.fileName));
                    this.setData(Toolkit.getDefaultToolkit().createImage(img.getSource()));
                } else if (fn.endsWith(".ico")) {
                    List<BufferedImage> list = ICODecoder.read(fs.getInputStream(this.fileName));
                    int maxs = 0;
                    BufferedImage img = null;
                    int listSize = list.size();
                    for (int i = 0; i < listSize; ++i) {
                        BufferedImage imgtmp = list.get(i);
                        int s = imgtmp.getWidth() * imgtmp.getHeight();
                        if (s < maxs) continue;
                        img = imgtmp;
                        maxs = s;
                    }
                    if (img != null) {
                        this.setData(Toolkit.getDefaultToolkit().createImage(img.getSource()));
                    }
                } else {
                    this.setData(fs.getImageFile(this.fileName));
                }
            }
            result = true;
        }
        return result;
    }

    public Image getImage() throws Exception {
        int imgStatus = 0;
        if (this.data == null || !(this.data instanceof Image)) {
            return null;
        }
        if (!this.animated) {
            while (true) {
                if (((imgStatus = Toolkit.getDefaultToolkit().checkImage((Image)this.data, -1, -1, null)) & 0xC0) != 0) {
                    System.err.println("Error loading " + this.getName() + " - Toolkit.checkImage returned status: " + imgStatus);
                    this.data = null;
                    break;
                }
                if ((imgStatus & imgReadyFlag) == imgReadyFlag) break;
                Thread.sleep(50L);
            }
        }
        if (this.data != null && (imgStatus & 0x10) != 0) {
            this.animated = true;
        }
        return (Image)this.data;
    }

    public Image prepareAndGetImage(FileSystem fs) throws Exception {
        Image img = this.getImage();
        if (img == null && this.data == null && this.prepareImage(fs)) {
            img = this.getImage();
        }
        return img;
    }

    public ImageIcon getThumbNail(int maxWidth, int maxHeight, FileSystem fs) {
        ImageIcon result = null;
        try {
            Image img = this.prepareAndGetImage(fs);
            if (img == null) {
                img = Utils.getFileIcon(this.fileName).getImage();
            }
            if (img != null && maxWidth > 0 && maxHeight > 0) {
                int w = img.getWidth(null);
                int h = img.getHeight(null);
                if (w > 0 && h > 0 && (w > maxWidth || h > maxHeight)) {
                    double f = Math.min((double)maxWidth / (double)w, (double)maxHeight / (double)h);
                    img = img.getScaledInstance((int)(f * (double)w), (int)(f * (double)h), 4);
                }
                result = new ImageIcon(img);
                this.hasThumb = true;
            }
        }
        catch (Exception ex) {
            System.err.println("Error reading image:\n" + ex);
        }
        return result;
    }

    public boolean isWaitingForImage() {
        if (this.hasThumb || this.animated || this.data == null || !(this.data instanceof Image)) {
            return false;
        }
        int state = Toolkit.getDefaultToolkit().checkImage((Image)this.data, -1, -1, null);
        if ((state & 0x10) != 0) {
            this.animated = true;
        }
        boolean result = (state & 0x30) == 0;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = FileSystem.stdFn(name);
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object obj) {
        int result = -1;
        if (this.getName() != null && obj instanceof MediaBagElement) {
            result = this.getName().compareTo(((MediaBagElement)obj).getName());
        }
        return result;
    }
}

