/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.boxes;

import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.Resizable;
import edu.xtec.jclic.boxes.TextGridContent;
import edu.xtec.util.StrUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class TextGrid
extends AbstractBox
implements Cloneable,
Resizable,
ActionListener {
    int nRows;
    int nCols;
    char[][] chars;
    char[][] answers;
    int[][] attributes;
    double cellWidth;
    double cellHeight;
    Rectangle2D preferredBounds = new Rectangle2D.Double();
    public char wild = (char)42;
    String randomChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    boolean cursorEnabled;
    boolean useCursor;
    Point cursor = new Point();
    boolean cursorBlink;
    Timer cursorTimer;
    boolean wildTransparent;
    public static final int MIN_CELL_SIZE = 12;
    public static final int DEFAULT_CELL_SIZE = 20;
    public static final int MIN_INTERNAL_MARGIN = 2;
    public static final int NORMAL = 0;
    public static final int INVERTED = 1;
    public static final int HIDDEN = 2;
    public static final int LOCKED = 4;
    public static final int MARKED = 8;
    public static final int TRANSPARENT = 16;

    public TextGrid(AbstractBox parent, JComponent container, double setX, double setY, int setNcw, int setNch, double setCellW, double setCellH, BoxBase boxBase, boolean setBorder) {
        super(parent, container, boxBase);
        this.x = setX;
        this.y = setY;
        this.nCols = Math.max(1, setNcw);
        this.nRows = Math.max(1, setNch);
        this.cellWidth = Math.max(setCellW, 12.0);
        this.cellHeight = Math.max(setCellH, 12.0);
        this.width = this.cellWidth * (double)this.nCols;
        this.height = this.cellHeight * (double)this.nRows;
        this.chars = new char[this.nRows][this.nCols];
        this.attributes = new int[this.nRows][this.nCols];
        this.preferredBounds.setRect(this.getBounds());
        this.setBorder(setBorder);
        this.cursorTimer = new Timer(500, this);
        this.cursorTimer.setRepeats(true);
        this.cursorEnabled = false;
        this.useCursor = false;
        this.wildTransparent = false;
        this.answers = null;
    }

    public static TextGrid createEmptyGrid(AbstractBox parent, JComponent container, double setX, double setY, TextGridContent tgc, boolean wildTransparent) {
        TextGrid result = new TextGrid(parent, container, setX, setY, tgc.ncw, tgc.nch, tgc.w, tgc.h, tgc.bb, tgc.border);
        result.wild = tgc.wild;
        result.randomChars = tgc.randomChars;
        result.wildTransparent = wildTransparent;
        return result;
    }

    public void setChars(String[] text) {
        this.answers = new char[this.nRows][this.nCols];
        for (int py = 0; py < this.nRows; ++py) {
            String line = py < text.length ? text[py] : null;
            for (int px = 0; px < this.nCols; ++px) {
                this.chars[py][px] = line == null || px >= line.length() ? 32 : (int)line.charAt(px);
                this.answers[py][px] = this.chars[py][px];
            }
        }
        this.repaint();
    }

    public void randomize() {
        for (int py = 0; py < this.nRows; ++py) {
            for (int px = 0; px < this.nCols; ++px) {
                if (this.chars[py][px] != this.wild) continue;
                this.chars[py][px] = this.randomChars.charAt((int)(Math.random() * (double)this.randomChars.length()));
            }
        }
        this.repaint();
    }

    public void setCellAttributes(boolean lockWild, boolean clearChars) {
        int atr = 4;
        atr = this.wildTransparent ? (atr |= 0x10) : (atr |= 3);
        for (int py = 0; py < this.nRows; ++py) {
            for (int px = 0; px < this.nCols; ++px) {
                if (lockWild && this.chars[py][px] == this.wild) {
                    this.attributes[py][px] = atr;
                    continue;
                }
                this.attributes[py][px] = 0;
                if (!clearChars) continue;
                this.chars[py][px] = 32;
            }
        }
        this.repaint();
    }

    public void setCellLocked(int px, int py, boolean locked) {
        if (px >= 0 && px < this.nCols && py >= 0 && py < this.nRows) {
            this.attributes[py][px] = locked ? 4 | (this.wildTransparent ? 16 : 3) : 0;
        }
    }

    public Point getItemFor(int rx, int ry) {
        if (!this.isValidCell(rx, ry)) {
            return null;
        }
        Point point = new Point();
        boolean inBlack = false;
        boolean startCount = false;
        for (int px = 0; px < rx; ++px) {
            if ((this.attributes[ry][px] & 4) != 0) {
                if (inBlack) continue;
                if (startCount) {
                    ++point.x;
                }
                inBlack = true;
                continue;
            }
            startCount = true;
            inBlack = false;
        }
        inBlack = false;
        startCount = false;
        for (int py = 0; py < ry; ++py) {
            if ((this.attributes[py][rx] & 4) != 0) {
                if (inBlack) continue;
                if (startCount) {
                    ++point.y;
                }
                inBlack = true;
                continue;
            }
            startCount = true;
            inBlack = false;
        }
        return point;
    }

    public void setCursorEnabled(boolean status) {
        this.cursorEnabled = status;
        if (status) {
            this.startCursorBlink();
        } else {
            this.stopCursorBlink();
        }
    }

    public void startCursorBlink() {
        if (this.useCursor && this.cursorEnabled && this.cursorTimer != null && !this.cursorTimer.isRunning()) {
            this.blink(1);
            this.cursorTimer.start();
        }
    }

    public void stopCursorBlink() {
        if (this.cursorTimer != null && this.cursorTimer.isRunning()) {
            this.cursorTimer.stop();
            this.blink(-1);
        }
    }

    public void moveCursor(int dx, int dy, boolean skipLocked) {
        Point point;
        if (this.useCursor && !this.cursor.equals(point = this.findNextCellWithAttr(this.cursor.x, this.cursor.y, skipLocked ? 4 : 0, dx, dy, false))) {
            this.setCursorAt(point.x, point.y, skipLocked);
        }
    }

    public Point findFreeCell(Point from, int dx, int dy) {
        Point result = null;
        if (from != null && (dx != 0 || dy != 0)) {
            Point scan = new Point(from);
            while (result == null) {
                scan.x += dx;
                scan.y += dy;
                if (scan.x < 0 || scan.x >= this.nCols || scan.y < 0 || scan.y >= this.nRows) break;
                if (this.getCellAttribute(scan.x, scan.y, 4)) continue;
                result = scan;
            }
        }
        return result;
    }

    public boolean isIntoBlacks(Point pt, boolean checkHorizontal) {
        boolean result = checkHorizontal ? !(pt.x > 0 && !this.getCellAttribute(pt.x - 1, pt.y, 4) || pt.x < this.nCols - 1 && !this.getCellAttribute(pt.x + 1, pt.y, 4)) : !(pt.y > 0 && !this.getCellAttribute(pt.x, pt.y - 1, 4) || pt.y < this.nRows - 1 && !this.getCellAttribute(pt.x, pt.y + 1, 4));
        return result;
    }

    public boolean isIntoWhites(Point pt, boolean checkHorizontal) {
        boolean result = checkHorizontal ? pt.x > 0 && !this.getCellAttribute(pt.x - 1, pt.y, 4) && pt.x < this.nCols - 1 && !this.getCellAttribute(pt.x + 1, pt.y, 4) : pt.y > 0 && !this.getCellAttribute(pt.x, pt.y - 1, 4) && pt.y < this.nRows - 1 && !this.getCellAttribute(pt.x, pt.y + 1, 4);
        return result;
    }

    public Point findNextCellWithAttr(int startX, int startY, int attr, int dx, int dy, boolean attrState) {
        Point point = new Point(startX + dx, startY + dy);
        while (true) {
            if (point.x < 0) {
                point.x = this.nCols - 1;
                point.y = point.y > 0 ? --point.y : this.nRows - 1;
            } else if (point.x >= this.nCols) {
                point.x = 0;
                point.y = point.y < this.nRows - 1 ? ++point.y : 0;
            }
            if (point.y < 0) {
                point.y = this.nRows - 1;
                point.x = point.x > 0 ? --point.x : this.nCols - 1;
            } else if (point.y >= this.nRows) {
                point.y = 0;
                point.x = point.x < this.nCols - 1 ? ++point.x : 0;
            }
            if (point.x == startX && point.y == startY || this.getCellAttribute(point.x, point.y, attr) == attrState) break;
            point.x += dx;
            point.y += dy;
        }
        return point;
    }

    public void setCursorAt(int px, int py, boolean skipLocked) {
        this.stopCursorBlink();
        if (this.isValidCell(px, py)) {
            this.cursor.x = px;
            this.cursor.y = py;
            this.useCursor = true;
            if (skipLocked && this.getCellAttribute(px, py, 4)) {
                this.moveCursor(1, 0, skipLocked);
            } else if (this.cursorEnabled) {
                this.startCursorBlink();
            }
        }
    }

    public void setUseCursor(boolean value) {
        this.useCursor = value;
    }

    public Point getCursor() {
        return this.cursor;
    }

    public int countCharsLike(char ch) {
        int result = 0;
        for (int py = 0; py < this.nRows; ++py) {
            for (int px = 0; px < this.nCols; ++px) {
                if (this.chars[py][px] != ch) continue;
                ++result;
            }
        }
        return result;
    }

    public int getNumCells() {
        return this.nRows * this.nCols;
    }

    public int countCoincidences(boolean checkCase) {
        int result = 0;
        if (this.answers != null) {
            for (int py = 0; py < this.nRows; ++py) {
                for (int px = 0; px < this.nCols; ++px) {
                    if (!this.isCellOk(px, py, checkCase)) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public boolean isCellOk(int px, int py, boolean checkCase) {
        char ch2;
        char ch;
        boolean result = false;
        if (this.isValidCell(px, py) && (ch = this.chars[py][px]) != this.wild && (ch == (ch2 = this.answers[py][px]) || !checkCase && Character.toUpperCase(ch) == Character.toUpperCase(ch2))) {
            result = true;
        }
        return result;
    }

    public Point getLogicalCoords(Point2D devicePoint) {
        int py;
        if (!this.contains(devicePoint)) {
            return null;
        }
        int px = (int)((devicePoint.getX() - this.getX()) / this.cellWidth);
        if (this.isValidCell(px, py = (int)((devicePoint.getY() - this.getY()) / this.cellHeight))) {
            return new Point(px, py);
        }
        return null;
    }

    public boolean isValidCell(int px, int py) {
        return px < this.nCols && py < this.nRows && px >= 0 && py >= 0;
    }

    public void setCharAt(int px, int py, char ch) {
        if (this.isValidCell(px, py)) {
            this.chars[py][px] = ch;
            this.repaintCell(px, py);
        }
    }

    public char getCharAt(int px, int py) {
        if (this.isValidCell(px, py)) {
            return this.chars[py][px];
        }
        return ' ';
    }

    public String getStringBetween(int x0, int y0, int x1, int y1) {
        StringBuilder sb = new StringBuilder();
        if (this.isValidCell(x0, y0) && this.isValidCell(x1, y1)) {
            int dx = x1 - x0;
            int dy = y1 - y0;
            if (dx == 0 || dy == 0 || Math.abs(dx) == Math.abs(dy)) {
                int steps = Math.max(Math.abs(dx), Math.abs(dy));
                if (steps > 0) {
                    dx /= steps;
                    dy /= steps;
                }
                for (int i = 0; i <= steps; ++i) {
                    sb.append(this.getCharAt(x0 + dx * i, y0 + dy * i));
                }
            }
        }
        return sb.substring(0);
    }

    public void setAttributeBetween(int x0, int y0, int x1, int y1, int attribute, boolean value) {
        if (this.isValidCell(x0, y0) && this.isValidCell(x1, y1)) {
            int dx = x1 - x0;
            int dy = y1 - y0;
            if (dx == 0 || dy == 0 || Math.abs(dx) == Math.abs(dy)) {
                int steps = Math.max(Math.abs(dx), Math.abs(dy));
                if (steps > 0) {
                    dx /= steps;
                    dy /= steps;
                }
                for (int i = 0; i <= steps; ++i) {
                    this.setAttribute(x0 + dx * i, y0 + dy * i, attribute, value);
                }
            }
        }
    }

    public void setAttribute(int px, int py, int attribute, boolean state) {
        if (this.isValidCell(px, py)) {
            if (attribute == 8 && !state) {
                this.repaintCell(px, py);
            }
            int[] nArray = this.attributes[py];
            int n = px;
            nArray[n] = nArray[n] & ~attribute;
            int[] nArray2 = this.attributes[py];
            int n2 = px;
            nArray2[n2] = nArray2[n2] | (state ? attribute : 0);
            if (attribute != 8 || state) {
                this.repaintCell(px, py);
            }
        }
    }

    public void setAllCellsAttribute(int attribute, boolean state) {
        for (int py = 0; py < this.nRows; ++py) {
            for (int px = 0; px < this.nCols; ++px) {
                this.setAttribute(px, py, attribute, state);
            }
        }
    }

    public boolean getCellAttribute(int px, int py, int attribute) {
        if (this.isValidCell(px, py)) {
            return (this.attributes[py][px] & attribute) != 0;
        }
        return false;
    }

    public Rectangle2D getCellRect(int px, int py) {
        return new Rectangle2D.Double(this.getX() + (double)px * this.cellWidth, this.getY() + (double)py * this.cellHeight, this.cellWidth, this.cellHeight);
    }

    public Rectangle getCellBorderBounds(int px, int py) {
        boolean isMarked = this.getCellAttribute(px, py, 8);
        if (!this.border && !isMarked) {
            return this.getCellRect(px, py).getBounds();
        }
        BoxBase bb = this.getBoxBaseResolve();
        Stroke strk = isMarked ? bb.getMarker() : bb.getBorder();
        return strk.createStrokedShape(this.getCellRect(px, py)).getBounds();
    }

    public void repaintCell(int px, int py) {
        JComponent jc = this.getContainerResolve();
        if (jc != null) {
            jc.repaint(this.getCellBorderBounds(px, py));
        }
    }

    @Override
    public Object clone() {
        TextGrid tgb = (TextGrid)super.clone();
        tgb.nRows = this.nRows;
        tgb.nCols = this.nCols;
        tgb.chars = new char[this.nRows][this.nCols];
        tgb.attributes = new int[this.nRows][this.nCols];
        for (int i = 0; i < this.nRows; ++i) {
            System.arraycopy(this.chars[i], 0, tgb.chars[i], 0, this.nCols);
            System.arraycopy(this.attributes[i], 0, tgb.attributes[i], 0, this.nCols);
        }
        tgb.cellWidth = this.cellWidth;
        tgb.cellHeight = this.cellHeight;
        tgb.preferredBounds = (Rectangle2D)this.preferredBounds.clone();
        return tgb;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredBounds.getBounds().getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(12 * this.nCols, 12 * this.nRows);
    }

    @Override
    public Dimension getScaledSize(double scale) {
        return new Dimension(StrUtils.roundTo(scale * this.preferredBounds.getWidth(), this.nCols), StrUtils.roundTo(scale * this.preferredBounds.getHeight(), this.nRows));
    }

    @Override
    public void setBounds(Rectangle2D r) {
        super.setBounds(r);
        this.cellWidth = this.width / (double)this.nCols;
        this.cellHeight = this.height / (double)this.nRows;
    }

    @Override
    public boolean update(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        if (this.isEmpty() || !this.isVisible() || this.isTemporaryHidden()) {
            return false;
        }
        if (dirtyRegion != null && !this.shape.intersects(dirtyRegion)) {
            return false;
        }
        this.updateContent(g2, dirtyRegion, io);
        return true;
    }

    @Override
    public boolean updateContent(Graphics2D g2, Rectangle dirtyRegion, ImageObserver io) {
        FontRenderContext frc = g2.getFontRenderContext();
        BoxBase bb = this.getBoxBaseResolve();
        FontMetrics fm = g2.getFontMetrics(bb.getFont());
        boolean resize = false;
        while (!((double)fm.charWidth('W') <= this.cellWidth - 4.0 && (double)(fm.getAscent() + fm.getDescent()) <= this.cellHeight - 4.0 || !bb.reduceFont())) {
            resize = true;
            fm = g2.getFontMetrics(bb.getFont());
        }
        if (resize) {
            JComponent jc = this.getContainerResolve();
            if (jc != null) {
                RepaintManager.currentManager(jc).markCompletelyDirty(jc);
            }
            return true;
        }
        char[] ch = new char[1];
        double ry = (this.cellHeight - (double)fm.getDescent() + (double)fm.getAscent()) / 2.0;
        for (int py = 0; py < this.nRows; ++py) {
            for (int px = 0; px < this.nCols; ++px) {
                int attr;
                Rectangle bxr = this.getCellBorderBounds(px, py);
                if (!bxr.intersects(dirtyRegion) || ((attr = this.attributes[py][px]) & 0x10) != 0) continue;
                boolean isInverted = (attr & 1) != 0;
                boolean isMarked = (attr & 8) != 0;
                boolean isCursor = this.useCursor && this.cursor.x == px && this.cursor.y == py;
                Rectangle2D boxBounds = this.getCellRect(px, py);
                g2.setColor(isCursor && this.cursorBlink ? bb.inactiveColor : (isInverted ? bb.textColor : bb.backColor));
                g2.fill(boxBounds);
                g2.setColor(Color.black);
                if ((attr & 2) == 0) {
                    ch[0] = this.chars[py][px];
                    if (ch[0] != '\u0000') {
                        double dx = boxBounds.getX() + (this.cellWidth - (double)fm.charWidth(ch[0])) / 2.0;
                        double dy = boxBounds.getY() + ry;
                        GlyphVector gv = bb.getFont().createGlyphVector(frc, ch);
                        if (bb.shadow) {
                            g2.setColor(bb.shadowColor);
                            g2.drawGlyphVector(gv, (float)(dx + (double)(bb.getDynFontSize() / 10.0f)), (float)(dy + (double)(bb.getDynFontSize() / 10.0f)));
                        }
                        g2.setColor(isInverted ? bb.backColor : (this.isAlternative() ? bb.alternativeColor : bb.textColor));
                        g2.drawGlyphVector(gv, (float)dx, (float)dy);
                    }
                }
                if (this.border || isMarked) {
                    g2.setColor(bb.borderColor);
                    g2.setStroke(isMarked ? bb.getMarker() : bb.getBorder());
                    if (isMarked) {
                        g2.setXORMode(Color.white);
                    }
                    g2.draw(boxBounds);
                    if (isMarked) {
                        g2.setPaintMode();
                    }
                    g2.setStroke(BoxBase.DEFAULT_STROKE);
                }
                g2.setColor(Color.black);
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.blink(0);
    }

    protected synchronized void blink(int status) {
        if (this.useCursor) {
            this.cursorBlink = status == 1 ? true : (status == -1 ? false : !this.cursorBlink);
            this.repaintCell(this.cursor.x, this.cursor.y);
        }
    }

    @Override
    public void end() {
        if (this.cursorTimer != null) {
            this.cursorTimer.stop();
            this.cursorTimer = null;
        }
    }

    @Override
    public void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }
}

