/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.PCCFileSystem;
import edu.xtec.util.ResourceBridge;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FilePCC
extends PCCFileSystem {
    RandomAccessFile raf;

    public FilePCC(String rootPath, String fName, ResourceBridge rb) throws Exception {
        super(rootPath, fName, rb);
        this.open();
    }

    @Override
    protected void open() throws Exception {
        if (this.raf == null) {
            DataInputStream dis = super.getDataInputStream(this.pccName);
            this.initPCC(dis);
            dis.close();
            this.raf = new RandomAccessFile(FilePCC.sysFn(this.getCanonicalNameOf(this.root + this.pccName)), "r");
        }
    }

    @Override
    protected byte[] getBytes(int entryNum) throws IOException {
        long fileSize = this.fe[entryNum].size;
        byte[] b = new byte[(int)fileSize];
        this.raf.seek(this.fe[entryNum].offset);
        for (long k = 0L; k < fileSize; k += (long)this.raf.read(b, (int)k, (int)(fileSize - k))) {
        }
        return b;
    }

    @Override
    protected void changeBase(String newRoot, String newFileName) throws Exception {
        if (this.raf != null) {
            throw new Exception("Unable to change base fileName: FileSystem is open!");
        }
        super.changeBase(newRoot, newFileName);
        this.pccName = this.getCanonicalNameOf(newFileName);
    }

    @Override
    public void close() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.raf = null;
        }
        super.close();
    }
}

