/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.fileSystem;

import edu.xtec.jclic.fileSystem.ZipFileSystem;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StreamIO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileZip
extends ZipFileSystem {
    protected ZipFile zip;

    public FileZip(String rootPath, String fName, ResourceBridge rb) throws Exception {
        super(rootPath, fName, rb);
        this.open();
    }

    @Override
    protected void open() throws Exception {
        if (this.zip == null) {
            this.zip = new ZipFile(FileZip.sysFn(this.root + this.zipName));
            Enumeration<? extends ZipEntry> en = this.zip.entries();
            ArrayList<FileZipEntry> v = new ArrayList<FileZipEntry>();
            while (en.hasMoreElements()) {
                v.add(new FileZipEntry(en.nextElement()));
            }
            this.entries = v.toArray(new FileZipEntry[v.size()]);
        }
    }

    @Override
    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.zip = null;
        }
        super.close();
    }

    @Override
    protected void changeBase(String newRoot, String newFileName) throws Exception {
        if (this.zip != null) {
            throw new Exception("Unable to change base fileName: FileSystem is open!");
        }
        super.changeBase(newRoot, newFileName);
        this.zipName = this.getCanonicalNameOf(newFileName);
        this.entries = null;
        this.loaded = false;
    }

    protected class FileZipEntry
    extends ZipFileSystem.ExtendedZipEntry {
        FileZipEntry(ZipEntry entry) {
            super(FileZip.this, entry);
        }

        @Override
        public byte[] getBytes() throws IOException {
            return StreamIO.readInputStream(this.getInputStream());
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream is = FileZip.this.zip.getInputStream(this);
            if (FileZip.this.rb != null) {
                is = FileZip.this.rb.getProgressInputStream(is, (int)this.getSize(), this.getName());
            }
            return is;
        }
    }
}

