/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.ActiveMediaPlayer;
import edu.xtec.jclic.media.MediaContent;
import java.util.HashSet;
import java.util.Iterator;

public class ActiveMediaBag
extends HashSet<ActiveMediaPlayer> {
    public ActiveMediaPlayer createActiveMediaPlayer(MediaContent mc, MediaBag mb, PlayStation ps) {
        ActiveMediaPlayer amp = null;
        switch (mc.mediaType) {
            case 5: {
                if (mc.length <= 0 || mc.length >= 20) break;
            }
            case 6: {
                if (mc.recBuffer < 0 || mc.recBuffer >= 10) break;
            }
            case 1: 
            case 2: 
            case 3: {
                amp = ActiveMediaPlayer.createActiveMediaPlayer(mc, mb, ps);
            }
        }
        if (amp != null) {
            this.add(amp);
        }
        return amp;
    }

    public ActiveMediaPlayer getActiveMediaPlayer(MediaContent mc, MediaBag mb, PlayStation ps) {
        ActiveMediaPlayer amp = null;
        Iterator i = this.iterator();
        while (i.hasNext() && (amp = (ActiveMediaPlayer)i.next()).getMediaContent() != mc && !amp.getMediaContent().isEquivalent(mc)) {
            amp = null;
        }
        if (amp == null) {
            amp = this.createActiveMediaPlayer(mc, mb, ps);
        }
        return amp;
    }

    public void removeActiveMediaPlayer(MediaContent mc) {
        ActiveMediaPlayer amp = null;
        Iterator i = this.iterator();
        while (i.hasNext() && (amp = (ActiveMediaPlayer)i.next()).getMediaContent() != mc) {
            amp = null;
        }
        if (amp != null) {
            amp.clear();
            this.remove(amp);
        }
    }

    public void realizeAll() {
        for (ActiveMediaPlayer amp : this) {
            amp.realize();
        }
    }

    public void stopAll() {
        this.stopAll(-1);
    }

    public void stopAll(int level) {
        for (ActiveMediaPlayer amp : this) {
            if (level != -1 && amp.getMediaContent().level > level) continue;
            amp.stop();
        }
    }

    public void removeAll() {
        for (ActiveMediaPlayer amp : this) {
            amp.clear();
        }
        this.clear();
        ActiveMediaPlayer.clearAllAudioBuffers();
    }
}

