/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.media.JavaSoundAudioPlayer;
import edu.xtec.jclic.media.PseudoClip;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class FalseClip
implements PseudoClip {
    private AudioInputStream ais;
    private AudioFormat af;
    private MediaBag mb;
    private String mediaFileName;
    private PlayThread playThread;
    private int loopCount;

    private FalseClip(MediaBag mb, String mediaFileName) throws Exception {
        this.mb = mb;
        this.mediaFileName = mediaFileName;
        this.af = this.getAudioInputStream().getFormat();
    }

    public static FalseClip getFalseClip(MediaBag mb, String mediaFileName) throws Exception {
        return new FalseClip(mb, mediaFileName);
    }

    private AudioInputStream getAudioInputStream() throws Exception {
        if (this.ais == null) {
            JavaSoundAudioPlayer jsap = new JavaSoundAudioPlayer();
            jsap.setDataSource(this.mb.getMediaDataSource(this.mediaFileName));
            this.ais = jsap.ais;
            if (this.ais == null) {
                throw new Exception("Unable to open audio data!");
            }
        }
        return this.ais;
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public AudioFormat getFormat() {
        return this.af;
    }

    @Override
    public boolean isActive() {
        return this.playThread != null && this.playThread.isAlive();
    }

    @Override
    public boolean isOpen() {
        return this.ais != null;
    }

    @Override
    public boolean isRunning() {
        return this.isActive();
    }

    @Override
    public void loop(int count) throws Exception {
        this.start();
        this.loopCount = count;
    }

    @Override
    public void open() throws Exception {
        this.getAudioInputStream();
    }

    @Override
    public void setFramePosition(int frames) {
    }

    @Override
    public void setLoopPoints(int start, int end) {
    }

    @Override
    public void start() throws Exception {
        if (this.playThread == null) {
            this.loopCount = 0;
            this.playThread = new PlayThread();
            this.playThread.start();
        }
    }

    @Override
    public void stop() {
        if (this.playThread != null) {
            if (this.playThread.isAlive()) {
                this.playThread.running = false;
                while (this.playThread != null) {
                    Thread.yield();
                }
            } else {
                this.playThread = null;
                this.ais = null;
            }
        }
    }

    class PlayThread
    extends Thread {
        public boolean running = false;
        byte[] buf = new byte[1024];
        SourceDataLine line = null;

        public PlayThread() throws Exception {
            FalseClip.this.getAudioInputStream();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, FalseClip.this.af);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            if (this.line != null) {
                this.line.open(FalseClip.this.af);
            }
        }

        @Override
        public void run() {
            if (this.line != null) {
                this.running = true;
                int nBytesRead = 0;
                try {
                    this.line.start();
                    while (this.running && nBytesRead >= 0) {
                        nBytesRead = FalseClip.this.ais.read(this.buf, 0, this.buf.length);
                        if (nBytesRead >= 0) {
                            int n = this.line.write(this.buf, 0, nBytesRead);
                        }
                        Thread.yield();
                    }
                    if (this.running) {
                        this.line.drain();
                    } else {
                        this.line.stop();
                    }
                }
                catch (Exception ex) {
                    System.err.println("JavaSound playing error:\n" + ex);
                }
                this.line.close();
            }
            FalseClip.this.ais = null;
            FalseClip.this.playThread = null;
            if (this.running && FalseClip.this.loopCount != 0) {
                if (FalseClip.this.loopCount > 0) {
                    FalseClip.this.loopCount--;
                }
                try {
                    int lc = FalseClip.this.loopCount;
                    FalseClip.this.start();
                    FalseClip.this.loopCount = lc;
                }
                catch (Exception ex) {
                    System.err.println("Error looping sound: " + ex);
                }
            }
            this.running = false;
        }
    }
}

