/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.jclic.bags.MediaBag;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.StrUtils;
import java.awt.Point;
import java.util.Map;
import org.jdom.Element;

public class MediaContent
implements Cloneable,
Domable {
    public static final int UNKNOWN = 0;
    public static final int PLAY_AUDIO = 1;
    public static final int PLAY_VIDEO = 2;
    public static final int PLAY_MIDI = 3;
    public static final int PLAY_CDAUDIO = 4;
    public static final int RECORD_AUDIO = 5;
    public static final int PLAY_RECORDED_AUDIO = 6;
    public static final int RUN_CLIC_ACTIVITY = 7;
    public static final int RUN_CLIC_PACKAGE = 8;
    public static final int RUN_EXTERNAL = 9;
    public static final int URL = 10;
    public static final int EXIT = 11;
    public static final int RETURN = 12;
    public static final int NUM_MEDIA_TYPES = 13;
    public static final String[] mediaName = new String[]{"UNKNOWN", "PLAY_AUDIO", "PLAY_VIDEO", "PLAY_MIDI", "PLAY_CDAUDIO", "RECORD_AUDIO", "PLAY_RECORDED_AUDIO", "RUN_CLIC_ACTIVITY", "RUN_CLIC_PACKAGE", "RUN_EXTERNAL", "URL", "EXIT", "RETURN"};
    public static final int FROM_BOX = 0;
    public static final int FROM_WINDOW = 1;
    public static final int FROM_FRAME = 2;
    public static final String[] fromName = new String[]{"BOX", "WINDOW", "FRAME"};
    public int mediaType = 0;
    public int level = 1;
    public String mediaFileName = null;
    public String externalParam = null;
    public int from = -1;
    public int to = -1;
    public int length = 3;
    public String cdFrom = null;
    public String cdTo = null;
    public int recBuffer = 0;
    public boolean stretch = false;
    public boolean free = false;
    public Point absLocation = null;
    public int absLocationFrom = 0;
    public boolean loop = false;
    public boolean catchMouseEvents = false;
    public boolean autoStart = false;
    public static final String ELEMENT_NAME = "media";
    protected static final String TYPE = "type";
    protected static final String LEVEL = "level";
    protected static final String FILE = "file";
    protected static final String PARAMS = "params";
    protected static final String FROM = "from";
    protected static final String TO = "to";
    protected static final String CDFROM = "cdFrom";
    protected static final String CDTO = "cdTo";
    protected static final String BUFFER = "buffer";
    protected static final String LENGTH = "length";
    protected static final String STRETCH = "stretch";
    protected static final String FREE = "free";
    protected static final String PX = "px";
    protected static final String PY = "py";
    protected static final String PFROM = "pFrom";
    protected static final String LOOP = "loop";
    protected static final String CATCH_MOUSE = "catchMouseEvents";
    protected static final String AUTOSTART = "autoStart";

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(TYPE, mediaName[this.mediaType]);
        e.setAttribute(LEVEL, Integer.toString(this.level));
        if (this.mediaFileName != null) {
            e.setAttribute(FILE, this.mediaFileName);
        }
        if (this.externalParam != null) {
            e.setAttribute(PARAMS, this.externalParam);
        }
        if (this.from != -1) {
            e.setAttribute(FROM, Integer.toString(this.from));
        }
        if (this.to != -1) {
            e.setAttribute(TO, Integer.toString(this.to));
        }
        if (this.cdFrom != null) {
            e.setAttribute(CDFROM, this.cdFrom);
        }
        if (this.cdTo != null) {
            e.setAttribute(CDTO, this.cdTo);
        }
        if (this.mediaType == 5 || this.mediaType == 6) {
            e.setAttribute(BUFFER, Integer.toString(this.recBuffer));
            if (this.mediaType == 5) {
                e.setAttribute(LENGTH, Integer.toString(this.length));
            }
        }
        if (this.mediaType == 2) {
            e.setAttribute(STRETCH, JDomUtility.boolString(this.stretch));
            e.setAttribute(FREE, JDomUtility.boolString(this.free));
            if (this.catchMouseEvents) {
                e.setAttribute(CATCH_MOUSE, JDomUtility.boolString(this.catchMouseEvents));
            }
            if (this.absLocation != null) {
                e.setAttribute(PX, Integer.toString(this.absLocation.x));
                e.setAttribute(PY, Integer.toString(this.absLocation.y));
                e.setAttribute(PFROM, fromName[this.absLocationFrom]);
            }
        }
        if (this.loop) {
            e.setAttribute(LOOP, JDomUtility.boolString(this.loop));
        }
        if (this.autoStart) {
            e.setAttribute(AUTOSTART, JDomUtility.boolString(this.autoStart));
        }
        return e;
    }

    public static MediaContent getMediaContent(Element e) throws Exception {
        MediaContent mc = new MediaContent();
        mc.setProperties(e, null);
        return mc;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.mediaType = JDomUtility.getStrIndexAttr(e, TYPE, mediaName, -1);
        if (this.mediaType == -1) {
            throw new IllegalArgumentException("Unknown media type: " + mediaName);
        }
        this.level = JDomUtility.getIntAttr(e, LEVEL, this.level);
        this.mediaFileName = FileSystem.stdFn(e.getAttributeValue(FILE));
        this.externalParam = e.getAttributeValue(PARAMS);
        this.from = JDomUtility.getIntAttr(e, FROM, this.from);
        this.to = JDomUtility.getIntAttr(e, TO, this.to);
        this.cdFrom = e.getAttributeValue(CDFROM);
        this.cdTo = e.getAttributeValue(CDTO);
        this.recBuffer = JDomUtility.getIntAttr(e, BUFFER, this.recBuffer);
        this.length = JDomUtility.getIntAttr(e, LENGTH, this.length);
        this.stretch = JDomUtility.getBoolAttr(e, STRETCH, this.stretch);
        this.stretch = JDomUtility.getBoolAttr(e, "retainAspect", this.stretch);
        this.free = JDomUtility.getBoolAttr(e, FREE, this.free);
        this.absLocationFrom = JDomUtility.getStrIndexAttr(e, PFROM, fromName, this.absLocationFrom);
        this.absLocation = JDomUtility.getPointAttr(e, PX, PY, this.absLocation);
        this.loop = JDomUtility.getBoolAttr(e, LOOP, this.loop);
        this.catchMouseEvents = JDomUtility.getBoolAttr(e, CATCH_MOUSE, this.catchMouseEvents);
        this.autoStart = JDomUtility.getBoolAttr(e, AUTOSTART, this.autoStart);
    }

    public static void listReferences(Element e, Map<String, String> map) {
        if (e != null) {
            String s = e.getAttributeValue(FILE);
            String p = e.getAttributeValue(PARAMS);
            int k = 0;
            if (s != null && s.length() > 0) {
                int type;
                try {
                    type = JDomUtility.getStrIndexAttr(e, TYPE, mediaName, -1);
                }
                catch (Exception ex) {
                    System.err.println("error:\n" + ex);
                    return;
                }
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: {
                        map.put(s, ELEMENT_NAME);
                        break;
                    }
                    case 7: {
                        k = 1;
                    }
                    case 8: {
                        map.put(s, p != null ? "external" : (k > 0 ? "activity" : "sequence"));
                        if (p == null) break;
                        map.put(p, "external");
                        break;
                    }
                    case 9: {
                        map.put(p == null ? s : s + " " + p, "external");
                        break;
                    }
                    case 10: {
                        map.put(s, "url");
                    }
                }
            }
        }
    }

    public String getIconName() {
        String s = "unknown.gif";
        switch (this.mediaType) {
            case 1: {
                s = "icowave.png";
                break;
            }
            case 3: {
                s = "icomidi.png";
                break;
            }
            case 2: {
                s = "icomci.png";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                s = "ico00.png";
                break;
            }
            case 5: {
                s = "icorec.png";
                break;
            }
            case 6: {
                s = "icorplay.png";
                break;
            }
            case 11: {
                s = "icoexit.png";
                break;
            }
            case 9: 
            case 10: {
                s = "icoexe.png";
                break;
            }
        }
        return s;
    }

    public void registerContentTo(MediaBag mb) throws Exception {
        if (this.mediaFileName != null) {
            switch (this.mediaType) {
                case 1: 
                case 2: 
                case 3: {
                    mb.registerElement(this.mediaFileName, null);
                    break;
                }
            }
        }
    }

    public boolean isEquivalent(MediaContent mc) {
        return mc != null && this.mediaType == mc.mediaType && StrUtils.compareStringsIgnoreCase(this.mediaFileName, mc.mediaFileName) && StrUtils.compareStringsIgnoreCase(this.externalParam, mc.externalParam) && this.from == mc.from && this.to == mc.to && StrUtils.compareStringsIgnoreCase(this.cdFrom, mc.cdFrom) && StrUtils.compareStringsIgnoreCase(this.cdTo, mc.cdTo) && this.recBuffer == mc.recBuffer && this.stretch == mc.stretch && this.free == mc.free && StrUtils.compareObjects(this.absLocation, mc.absLocation) && this.absLocationFrom == mc.absLocationFrom && this.loop == mc.loop && this.level == mc.level;
    }

    public String getDescription() {
        StringBuilder result = new StringBuilder();
        result.append(mediaName[this.mediaType]);
        if (this.mediaFileName != null) {
            result.append(" ").append(this.mediaFileName);
            if (this.from >= 0) {
                result.append(" ").append("from:").append(this.from);
            }
            if (this.to >= 0) {
                result.append(" ").append("to:").append(this.to);
            }
        } else if (this.externalParam != null) {
            result.append(" ").append(this.externalParam);
        }
        return result.substring(0);
    }

    public Object clone() {
        MediaContent mc = null;
        try {
            mc = (MediaContent)super.clone();
            if (this.absLocation != null) {
                mc.absLocation = (Point)this.absLocation.clone();
            }
        }
        catch (Exception ex) {
            System.err.println("Unexpected error cloning MediaContent!");
        }
        return mc;
    }
}

