/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.media;

import edu.xtec.util.ExtendedByteArrayInputStream;
import edu.xtec.util.StreamIO;
import java.io.File;
import quicktime.QTSession;
import quicktime.app.view.MoviePlayer;
import quicktime.io.QTFile;
import quicktime.std.movies.Movie;
import quicktime.std.movies.media.DataRef;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;

public class QT61Tools {
    private static QT61Lock lock;

    public QT61Tools() throws Exception {
        if (lock == null) {
            lock = new QT61Lock();
        }
    }

    public static Movie getMovie(Object source, boolean midi) throws Exception {
        Movie movie;
        Object handle = null;
        String sourceName = "";
        if (source instanceof ExtendedByteArrayInputStream) {
            ExtendedByteArrayInputStream eias = (ExtendedByteArrayInputStream)source;
            handle = new QTHandle(eias.getBuffer());
            sourceName = eias.getName();
        } else if (source instanceof File) {
            sourceName = ((File)source).getName();
            handle = midi ? new QTHandle(StreamIO.readFile((File)source)) : new DataRef(new QTFile((File)source));
        } else if (source instanceof String) {
            sourceName = (String)source;
            handle = midi ? new QTHandle(StreamIO.readFile(new File(sourceName))) : new DataRef(sourceName);
        }
        if (midi) {
            MovieImporter movieimporter = new MovieImporter(QTUtils.toOSType((String)"Midi"));
            movie = new Movie(1);
            movie.setDefaultDataRef(new DataRef((QTHandleRef)new QTHandle()));
            movieimporter.fromHandle((QTHandleRef)handle, movie, null, 0, 1);
        } else {
            DataRef dr;
            if (handle instanceof DataRef) {
                dr = (DataRef)handle;
            } else {
                String extension = sourceName.substring(sourceName.lastIndexOf(46));
                dr = new DataRef((QTHandleRef)handle, 1702392864, extension);
            }
            movie = Movie.fromDataRef((DataRef)dr, (int)1);
        }
        return movie;
    }

    public static MoviePlayer getPlayer(Object source) throws Exception {
        Movie mv = QT61Tools.getMovie(source, false);
        return new MoviePlayer(mv);
    }

    protected class QT61Lock {
        protected QT61Lock() throws Exception {
            if (!QTSession.isInitialized()) {
                QTSession.open();
            }
        }

        protected void finalize() throws Throwable {
            QTSession.close();
            super.finalize();
        }
    }
}

