/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.project;

import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.project.LibraryManagerElement;
import edu.xtec.jclic.project.NewLibraryDlg;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.util.Domable;
import edu.xtec.util.ExtendedJDialog;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LibraryManager
implements Domable {
    protected DefaultListModel libraries;
    protected PlayerSettings settings;
    protected boolean modified;
    public boolean autoRun;
    public static final String AUTO_RUN = "autoRun";
    public static final String ELEMENT_NAME = "libraryManager";
    private static final String MSG_ID = "libraryManager_";
    public static final String PROJECT_LIBRARIES = "project.libraries";

    public LibraryManager(PlayerSettings settings) {
        this.settings = settings;
        this.libraries = new DefaultListModel();
        this.modified = false;
        this.autoRun = true;
    }

    public static LibraryManager getLibraryManager(PlayerSettings st, Element e) throws Exception {
        LibraryManager lm = new LibraryManager(st);
        lm.setProperties(e, null);
        return lm;
    }

    @Override
    public void setProperties(Element e, Object aux) throws Exception {
        JDomUtility.checkName(e, ELEMENT_NAME);
        this.autoRun = JDomUtility.getBoolAttr(e, AUTO_RUN, this.autoRun);
        String[][] sysLibs = LibraryManager.getSystemLibraries();
        if (sysLibs != null) {
            for (int i = 0; i < sysLibs.length; ++i) {
                LibraryManagerElement lme = new LibraryManagerElement(sysLibs[i][0], sysLibs[i][1], this.settings.rb.getOptions());
                lme.setSystemLib(true);
                this.libraries.addElement(lme);
            }
        }
        Iterator it = e.getChildren("library").iterator();
        while (it.hasNext()) {
            this.libraries.addElement(LibraryManagerElement.getLibraryManagerElement((Element)it.next(), this.settings.rb.getOptions()));
        }
    }

    public void addNewLibrary(String path, String title) throws Exception {
        File f = new File(path);
        if (f.exists()) {
            ProjectLibrary pl = ProjectLibrary.loadProjectLibrary(path, this.settings.rb);
            title = pl.settings.title;
        } else {
            if (title == null) {
                title = this.settings.rb.getMsg("libraryManager_mainLibraryTitle");
            }
            ProjectLibrary pl = ProjectLibrary.createNewProjectLibrary(this.settings.rb, this.settings.fileSystem);
            pl.settings.title = title;
            pl.save(path);
        }
        this.libraries.addElement(new LibraryManagerElement(title, path, this.settings.rb.getOptions()));
    }

    @Override
    public Element getJDomElement() {
        Element e = new Element(ELEMENT_NAME);
        e.setAttribute(AUTO_RUN, JDomUtility.boolString(this.autoRun));
        for (int i = 0; i < this.libraries.size(); ++i) {
            LibraryManagerElement lme = (LibraryManagerElement)this.libraries.get(i);
            if (lme.isSystemLib()) continue;
            e.addContent(lme.getJDomElement());
        }
        return e;
    }

    public boolean isEmpty() {
        return this.libraries.isEmpty();
    }

    public ProjectLibrary getAutoStartProjectLibrary() throws Exception {
        ProjectLibrary result = null;
        if (this.autoRun && !this.isEmpty()) {
            if (this.libraries.size() > 1) {
                result = this.selectProjectLibrary(false, false);
            } else {
                Menu m;
                result = ProjectLibrary.loadProjectLibrary(((LibraryManagerElement)this.libraries.get((int)0)).path, this.settings.rb);
                if (result != null && ((m = result.getRootMenu()) == null || m.getMenuElementCount() < 1)) {
                    result = null;
                }
            }
        }
        return result;
    }

    public ProjectLibrary selectProjectLibrary(boolean allowEdit, boolean selectOnlyEditable) throws Exception {
        ProjectLibrary result = null;
        if (!this.libraries.isEmpty() || allowEdit) {
            LibraryDialog plDlg = new LibraryDialog(allowEdit, selectOnlyEditable);
            plDlg.setVisible(true);
            if (plDlg.result != null) {
                result = ProjectLibrary.loadProjectLibrary(plDlg.result.path, this.settings.rb);
            }
        }
        return result;
    }

    public int getNumLibraries() {
        return this.libraries.getSize();
    }

    public LibraryManagerElement locateNewProjectLibrary(String path) {
        LibraryManagerElement result = null;
        ResourceBridge rb = this.settings.rb;
        if (path == null) {
            int[] filters = new int[]{0};
            String s = this.settings.fileSystem.chooseFile(this.settings.rootPath + File.separator + ".", false, filters, rb.getOptions(), null, rb.getComponent(), false);
            if (s != null) {
                path = this.settings.fileSystem.getFullFileNamePath(s);
            }
        }
        if (path != null && !this.elementExists(path, true)) {
            try {
                ProjectLibrary pl = ProjectLibrary.loadProjectLibrary(path, rb);
                result = new LibraryManagerElement(pl.settings.title, path, rb.getOptions());
            }
            catch (Exception ex) {
                this.settings.rb.getOptions().getMessages().showErrorWarning((Component)rb.getComponent(), "FILE_ERR_READING", path, ex, null);
            }
        }
        return result;
    }

    public LibraryManagerElement createNewProjectLibrary(String path, String name) {
        LibraryManagerElement result = null;
        ResourceBridge rb = this.settings.rb;
        if (path == null) {
            int[] filters = new int[]{0};
            String s = this.settings.fileSystem.chooseFile(this.settings.rootPath + File.separator + "library.jclic", true, filters, rb.getOptions(), null, rb.getComponent(), false);
            if (s != null) {
                path = this.settings.fileSystem.getFullFileNamePath(s);
            }
        }
        if (path != null && !this.elementExists(path, true)) {
            ProjectLibrary pl = ProjectLibrary.createNewProjectLibrary(rb, this.settings.fileSystem);
            try {
                pl.save(path);
                result = new LibraryManagerElement(pl.settings.title, path, rb.getOptions());
            }
            catch (Exception ex) {
                this.settings.rb.getOptions().getMessages().showErrorWarning((Component)rb.getComponent(), "FILE_ERR_SAVING", path, ex, null);
            }
        }
        return result;
    }

    public boolean elementExists(String path, boolean warn) {
        boolean result = false;
        for (int i = 0; i < this.libraries.size(); ++i) {
            LibraryManagerElement lme = (LibraryManagerElement)this.libraries.get(i);
            if (!path.equals(this.settings.fileSystem.getFullFileNamePath(lme.path))) continue;
            result = true;
            if (!warn) break;
            this.settings.rb.getOptions().getMessages().showAlert((Component)this.settings.rb.getComponent(), "libraryManager_new_exists");
            break;
        }
        return result;
    }

    public LibraryPane getLibraryPane(boolean allowEdit, boolean selectOnlyEditable) {
        return new LibraryPane(allowEdit, selectOnlyEditable);
    }

    public static String[][] getSystemLibraries() {
        String[][] result = null;
        try {
            String projectLibraries = PersistentSettings.systemPrefs.get(PROJECT_LIBRARIES, "[]");
            JSONArray jsa = new JSONArray(projectLibraries);
            int numLibraries = jsa.length();
            if (numLibraries > 0) {
                result = new String[numLibraries][2];
                for (int i = 0; i < numLibraries; ++i) {
                    JSONObject jso = jsa.getJSONObject(i);
                    if (jso != null) {
                        result[i][0] = jso.getString("name");
                        result[i][1] = jso.getString("path");
                    }
                    if (result[i][0] != null && result[i][1] != null) continue;
                    throw new Exception("Invalid settings in JClic system libraries.");
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Error reading JClic system libraries: " + ex.getMessage());
            result = null;
        }
        return result;
    }

    public static void main(String[] args) {
        String command = null;
        String libName = null;
        String libPath = null;
        String[][] sysLibs = LibraryManager.getSystemLibraries();
        boolean err = false;
        for (String s : args) {
            if (s.startsWith("-")) {
                if (command != null || s.length() == 1) {
                    err = true;
                    continue;
                }
                command = s.substring(1);
                continue;
            }
            if (libName == null) {
                libName = s;
                continue;
            }
            if (libPath == null) {
                libPath = s;
                continue;
            }
            err = true;
        }
        try {
            boolean done;
            JSONArray jsa;
            if (err || command == null) {
                LibraryManager.printUsage();
            } else if (command.equals("add") && libName != null && libPath != null) {
                jsa = new JSONArray();
                done = false;
                if (sysLibs != null) {
                    for (int i = 0; i < sysLibs.length; ++i) {
                        String name = sysLibs[i][0];
                        String path = sysLibs[i][1];
                        if (libName.equals(name)) {
                            path = libPath;
                            done = true;
                        }
                        JSONObject jso = new JSONObject();
                        jso.put("name", name);
                        jso.put("path", path);
                        jsa.put(jso);
                    }
                }
                if (!done) {
                    JSONObject jso = new JSONObject();
                    jso.put("name", libName);
                    jso.put("path", libPath);
                    jsa.put(jso);
                }
                try {
                    PersistentSettings.systemPrefs.put(PROJECT_LIBRARIES, jsa.toString());
                    PersistentSettings.systemPrefs.flush();
                }
                catch (Exception ex) {
                    System.err.println("Unable to write system settings. Check your permissions!");
                    System.err.println(ex.getMessage());
                    err = true;
                }
            } else if (command.equals("remove") && libName != null) {
                jsa = new JSONArray();
                done = false;
                if (sysLibs != null) {
                    for (int i = 0; i < sysLibs.length; ++i) {
                        String name = sysLibs[i][0];
                        String path = sysLibs[i][1];
                        if (libName.equals(name)) {
                            done = true;
                            continue;
                        }
                        JSONObject jso = new JSONObject();
                        jso.put("name", name);
                        jso.put("path", path);
                        jsa.put(jso);
                    }
                }
                if (!done) {
                    System.err.println("ERROR: Library \"" + libName + "\" does not exist!");
                    err = true;
                } else {
                    try {
                        PersistentSettings.systemPrefs.put(PROJECT_LIBRARIES, jsa.toString());
                        PersistentSettings.systemPrefs.flush();
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to write system settings. Check your permissions!");
                        System.err.println(ex.getMessage());
                        err = true;
                    }
                }
            } else if (command.equals("list")) {
                if (sysLibs == null || sysLibs.length == 0) {
                    System.out.println("There are no system libraries defined!");
                } else {
                    for (int i = 0; i < sysLibs.length; ++i) {
                        System.out.println(sysLibs[i][0] + ": " + sysLibs[i][1]);
                    }
                }
            } else {
                LibraryManager.printUsage();
            }
        }
        catch (JSONException ex) {
            System.err.println("JSON Error: " + ex.getMessage());
            err = true;
        }
        System.exit(err ? -1 : 0);
    }

    protected static void printUsage() {
        System.out.println("JClic System Libraries Manager\n\nusage: java -cp jclic.jar edu.xtec.jclic.project.LibraryManager -[option] [name] [path]\n\nValid options are:\n-add name path     Adds a new element to the list of system libraries.\n                   'path' must point to a library.jclic file.\n-remove name       Removes the library from the system list.\n-list              Displays a list of the existing system libraries.\n-help              Displays this message.\n");
    }

    class LibraryDialog
    extends ExtendedJDialog
    implements ListSelectionListener {
        LibraryManagerElement result;
        Action selectAction;
        Action cancelAction;
        LibraryPane pane;
        boolean allowEdit;
        boolean onlyEditable;

        LibraryDialog(boolean allowEdit, boolean selectOnlyEditable) {
            super(LibraryManager.this.settings.rb.getComponent(), LibraryManager.this.settings.rb.getMsg("libraryManager_caption"), true);
            this.result = null;
            this.allowEdit = allowEdit;
            this.onlyEditable = selectOnlyEditable;
            this.pane = new LibraryPane(allowEdit, selectOnlyEditable);
            this.pane.setOpaque(false);
            this.buildActions();
            this.pane.addListSelectionListener(this);
            this.getContentPane().add((Component)this.pane, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setOpaque(false);
            JButton btSelect = new JButton(this.selectAction);
            btSelect.setDefaultCapable(true);
            buttonsPanel.add(btSelect);
            buttonsPanel.add(new JButton(this.cancelAction));
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.getRootPane().setDefaultButton(btSelect);
            this.pack();
            this.centerOver(LibraryManager.this.settings.rb.getComponent());
            this.pane.list.setSelectedIndex(0);
            this.valueChanged(new ListSelectionEvent(this.pane.list, 0, 0, false));
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (ev != null && !ev.getValueIsAdjusting()) {
                LibraryManagerElement item = this.pane.getCurrentSelected();
                this.selectAction.setEnabled(item != null && item.exists && (!this.onlyEditable || item.editable));
            }
        }

        void closeDialog() {
            if (LibraryManager.this.modified) {
                LibraryManager.this.settings.save();
                LibraryManager.this.modified = false;
            }
            this.setVisible(false);
        }

        void buildActions() {
            Options options = LibraryManager.this.settings.rb.getOptions();
            this.selectAction = new AbstractAction(options.getMsg("libraryManager_select_caption"), ResourceManager.getImageIcon("icons/file_open.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LibraryDialog.this.result = (LibraryManagerElement)LibraryDialog.this.pane.list.getSelectedValue();
                    LibraryDialog.this.closeDialog();
                }
            };
            this.selectAction.putValue("ShortDescription", options.getMsg("libraryManager_select_tooltip"));
            this.selectAction.setEnabled(false);
            this.cancelAction = new AbstractAction(options.getMsg("libraryManager_cancel_caption"), ResourceManager.getImageIcon("icons/cancel.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LibraryDialog.this.result = null;
                    LibraryDialog.this.closeDialog();
                }
            };
            this.cancelAction.putValue("ShortDescription", options.getMsg("libraryManager_cancel_tooltip"));
        }
    }

    public class LibraryPane
    extends JPanel
    implements ListSelectionListener {
        Action editAction;
        Action newLibraryAction;
        Action deleteAction;
        JList list;
        boolean allowEdit;
        boolean onlyEditable;
        LibraryManagerElement current;

        LibraryPane(boolean allowEdit, boolean selectOnlyEditable) {
            super(new BorderLayout());
            this.current = null;
            this.allowEdit = allowEdit;
            this.onlyEditable = selectOnlyEditable;
            this.buildActions();
            this.list = new JList(LibraryManager.this.libraries);
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(this);
            if (this.list.getModel().getSize() > 0) {
                this.list.setSelectedIndex(0);
            }
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof LibraryManagerElement) {
                        LibraryManagerElement lme = (LibraryManagerElement)value;
                        this.setIcon(lme.getIcon());
                        if (!lme.exists || !lme.editable && LibraryPane.this.onlyEditable || lme.isSystemLib()) {
                            this.setForeground(SystemColor.textInactiveText);
                        }
                    }
                    return this;
                }
            });
            this.add((Component)new JScrollPane(this.list), "Center");
            if (allowEdit) {
                JPanel buttonsPanel = new JPanel();
                buttonsPanel.setOpaque(false);
                buttonsPanel.add(new JButton(this.editAction));
                buttonsPanel.add(new JButton(this.newLibraryAction));
                buttonsPanel.add(new JButton(this.deleteAction));
                this.add((Component)buttonsPanel, "South");
            }
        }

        void buildActions() {
            final Options options = LibraryManager.this.settings.rb.getOptions();
            this.editAction = new AbstractAction(options.getMsg("libraryManager_edit_caption"), ResourceManager.getImageIcon("icons/edit.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LibraryManagerElement lme = (LibraryManagerElement)LibraryPane.this.list.getSelectedValue();
                    if (lme != null) {
                        try {
                            if (!LibraryManager.this.settings.promptPassword(LibraryPane.this, null)) {
                                return;
                            }
                            ProjectLibrary pl = ProjectLibrary.loadProjectLibrary(lme.path, LibraryManager.this.settings.rb);
                            if (pl.editProjectLibrary(LibraryPane.this) && !pl.settings.title.equals(lme.name)) {
                                lme.name = pl.settings.title;
                                LibraryManager.this.modified = true;
                                LibraryPane.this.list.repaint();
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("Unable edit projectLibrary:\n" + ex);
                        }
                    }
                }
            };
            this.editAction.putValue("ShortDescription", options.getMsg("libraryManager_edit_tooltip"));
            this.editAction.setEnabled(false);
            this.deleteAction = new AbstractAction(options.getMsg("libraryManager_delete_caption"), ResourceManager.getImageIcon("icons/delete.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LibraryManagerElement lme = (LibraryManagerElement)LibraryPane.this.list.getSelectedValue();
                    if (lme != null) {
                        int currentIndex = LibraryPane.this.list.getSelectedIndex();
                        try {
                            if (!LibraryManager.this.settings.promptPassword(LibraryPane.this, null) || options.getMessages().showQuestionDlg(null, "libraryManager_delete_confirm", null, "yn") != 1) {
                                return;
                            }
                            LibraryManager.this.libraries.removeElement(lme);
                            LibraryManager.this.modified = true;
                            LibraryPane.this.list.setSelectedIndex(Math.max(0, currentIndex - 1));
                        }
                        catch (Exception ex) {
                            System.err.println("Unable to delete projectLibrary:\n" + ex);
                        }
                    }
                }
            };
            this.deleteAction.putValue("ShortDescription", options.getMsg("libraryManager_delete_tooltip"));
            this.deleteAction.setEnabled(false);
            this.newLibraryAction = new AbstractAction(options.getMsg("libraryManager_new_caption"), ResourceManager.getImageIcon("icons/database_new.gif")){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (!LibraryManager.this.settings.promptPassword(LibraryPane.this, null)) {
                        return;
                    }
                    LibraryManagerElement lme = NewLibraryDlg.getLibraryManagerElement(LibraryManager.this, LibraryPane.this);
                    if (lme != null) {
                        LibraryManager.this.modified = true;
                        LibraryManager.this.libraries.addElement(lme);
                        LibraryPane.this.list.setSelectedValue(lme, true);
                    }
                }
            };
            this.newLibraryAction.putValue("ShortDescription", options.getMsg("libraryManager_new_tooltip"));
        }

        public LibraryManagerElement getCurrentSelected() {
            return this.current;
        }

        public void addListSelectionListener(ListSelectionListener lst) {
            this.list.addListSelectionListener(lst);
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (ev != null && !ev.getValueIsAdjusting()) {
                this.current = (LibraryManagerElement)this.list.getSelectedValue();
                this.editAction.setEnabled(this.current != null && this.current.editable);
                this.deleteAction.setEnabled(this.current != null && !this.current.isSystemLib());
            }
        }
    }
}

