/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.shapers;

import edu.xtec.jclic.shapers.JigSaw;
import edu.xtec.jclic.shapers.ShapeData;

public class TriangularJigSaw
extends JigSaw {
    public TriangularJigSaw(int nx, int ny) {
        super(nx, ny);
    }

    @Override
    protected void hLine(ShapeData sd, int type, double x, double y, double w, double h, boolean inv) {
        int ky;
        int kx = inv ? -1 : 1;
        int n = ky = type == 1 ? 1 : -1;
        if (type == 0) {
            sd.lineTo(x + w * (double)kx, y);
        } else {
            double x0 = x + (w - w * this.baseWidthFactor) / 2.0 * (double)kx;
            double wb = w * this.baseWidthFactor * (double)kx;
            sd.lineTo(x0, y);
            double hb = h * this.toothHeightFactor * (double)ky;
            sd.lineTo(x0 + wb / 2.0, y + hb);
            sd.lineTo(x0 + wb, y);
            sd.lineTo(x + w * (double)kx, y);
        }
    }

    @Override
    protected void vLine(ShapeData sd, int type, double x, double y, double w, double h, boolean inv) {
        int kx;
        int ky = inv ? -1 : 1;
        int n = kx = type == 1 ? 1 : -1;
        if (type == 0) {
            sd.lineTo(x, y + h * (double)ky);
        } else {
            double y0 = y + (h - h * this.baseWidthFactor) / 2.0 * (double)ky;
            double hb = h * this.baseWidthFactor * (double)ky;
            sd.lineTo(x, y0);
            double wb = w * this.toothHeightFactor * (double)kx;
            sd.lineTo(x + wb, y0 + hb / 2.0);
            sd.lineTo(x, y0 + hb);
            sd.lineTo(x, y + h * (double)ky);
        }
    }
}

