/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.skins;

import edu.xtec.jclic.Constants;
import edu.xtec.jclic.boxes.AbstractBox;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.AnimatedActiveBox;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.boxes.Counter;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.jclic.misc.Utils;
import edu.xtec.jclic.skins.Skin;
import edu.xtec.util.Domable;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.jdom.Element;

public class BasicSkin
extends Skin {
    BufferedImage img;
    Color fillColor;
    int initiated;
    Rectangle frame;
    int leftSlicer;
    int rightSlicer;
    int topSlicer;
    int bottomSlicer;
    Rectangle playerRect;
    Rectangle msgRect;
    Rectangle[] msgAreaRect = new Rectangle[3];
    Color textColor;
    Rectangle[] buttonsRect = new Rectangle[8];
    Rectangle[][] countersRect = new Rectangle[3][];
    ActiveBox[] countersLabel = new ActiveBox[3];
    AbstractBox[] boxes = new AbstractBox[11];
    JProgressBar progressBar;
    Rectangle progressBarRect;
    Rectangle progressAnimationRect;
    AnimatedActiveBox progressAnimation;
    boolean hideProgressBar;
    boolean hideProgressAnim;
    static final int NUM_BOXES = 11;
    public static final String IMAGE = "image";
    public static final String PREFERRED_SIZE = "preferredSize";
    public static final String FRAME = "frame";
    public static final String PLAYER = "player";
    public static final String FILL = "fill";
    public static final String SLICER = "slicer";
    public static final String MESSAGES = "messages";
    public static final String STATUS_BAR = "statusBar";
    public static final String SETTINGS = "settings";
    public static final String STYLE = "style";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String MSG_AREA = "msgArea";
    public static final String BORDER = "border";
    public static final String BUTTONS = "buttons";
    public static final String BUTTON = "button";
    public static final String ACTIVE = "active";
    public static final String OVER = "over";
    public static final String DISABLED = "disabled";
    public static final String POS = "pos";
    public static final String SOURCE = "source";
    public static final String COUNTERS = "counters";
    public static final String COUNTER = "counter";
    public static final String LABEL = "label";
    public static final String DIGITS = "digits";
    public static final String TOGGLE = "toggle";
    public static final String PROGRESS_BAR = "progressBar";
    public static final String AUTO_HIDE = "autoHide";
    public static final String SHOW_PERCENT = "showPercent";
    public static final String PROGRESS_ANIMATION = "progressAnimation";
    public static final String FRAMES = "frames";
    public static final String DELAY = "delay";
    public static final String STEP = "step";

    protected BasicSkin() {
        for (int i = 0; i < 3; ++i) {
            this.countersRect[i] = new Rectangle[2];
        }
        this.progressBar = null;
        this.progressAnimation = null;
        this.hideProgressBar = true;
        this.hideProgressAnim = true;
        this.initiated = 0;
    }

    @Override
    protected void setProperties(Element e, FileSystem fs) throws Exception {
        Element child3;
        Element child2;
        Domable abc;
        this.setPreferredSize(JDomUtility.getDimension(e, PREFERRED_SIZE, new Dimension(640, 480)));
        this.fillColor = JDomUtility.getColorByPoint(e, FILL, this.img, Color.white);
        String imageFile = JDomUtility.getStringAttr(e, IMAGE, null, true);
        if (imageFile == null || imageFile.length() == 0) {
            throw new Exception("BasicSkin properties without image name!");
        }
        if (fs == null) {
            ImageIcon imgIcon = ResourceManager.getImageIcon("skins/" + imageFile);
            this.img = Utils.toBufferedImage(imgIcon.getImage(), this.fillColor, this);
        } else {
            ImageIcon imgi = new ImageIcon(fs.getBytes(imageFile));
            this.img = Utils.toBufferedImage(imgi.getImage(), this.fillColor, this);
        }
        this.fillColor = JDomUtility.getColorByPoint(e, FILL, this.img, Color.gray);
        this.setBackground(this.fillColor);
        this.frame = JDomUtility.getRectangle(e, FRAME, null);
        this.setMinimumSize(this.frame.getSize());
        Element child = e.getChild(SLICER);
        this.leftSlicer = JDomUtility.getIntAttr(child, "left", 0);
        this.rightSlicer = JDomUtility.getIntAttr(child, "right", 0);
        this.topSlicer = JDomUtility.getIntAttr(child, "top", 0);
        this.bottomSlicer = JDomUtility.getIntAttr(child, "bottom", 0);
        this.playerRect = JDomUtility.getRectangle(e, PLAYER, null);
        this.msgRect = JDomUtility.getRectangle(e, MESSAGES, null);
        BoxBase bb = new BoxBase();
        bb.transparent = true;
        this.msgBox = new ActiveBox(null, this, 0, this.msgRect, bb);
        child = e.getChild(PROGRESS_BAR);
        if (child != null) {
            this.hideProgressBar = JDomUtility.getBoolAttr(child, AUTO_HIDE, true);
            BoxBase bbProgres = this.getBoxBase(child, null);
            this.progressBarRect = JDomUtility.getRectangle(child, null, null);
            if (this.progressBarRect != null) {
                this.progressBar = new JProgressBar();
                BoxBase bbProgress = this.getBoxBase(child, null);
                this.progressBar.setBackground(bbProgress.backColor);
                this.progressBar.setForeground(bbProgress.textColor);
                this.progressBar.setFont(bbProgress.getFont());
                this.progressBar.setStringPainted(JDomUtility.getBoolAttr(child, SHOW_PERCENT, true));
                this.progressBar.setOpaque(false);
                this.progressBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.add(this.progressBar);
                this.progressBar.setVisible(!this.hideProgressBar);
                this.hasProgress = true;
            }
        }
        if ((child = e.getChild(PROGRESS_ANIMATION)) != null) {
            Dimension d = JDomUtility.getDimension(child, null, null);
            Point source = JDomUtility.getPoint(child, SOURCE, null);
            Point pos = JDomUtility.getPoint(child, POS, null);
            int frames = JDomUtility.getIntAttr(child, FRAMES, 0);
            int delay = JDomUtility.getIntAttr(child, DELAY, 0);
            int direction = JDomUtility.getDirection(child, 1);
            this.hideProgressAnim = JDomUtility.getBoolAttr(child, AUTO_HIDE, true);
            if (d != null && source != null && frames > 0 && delay >= 50) {
                int dy;
                int dx;
                switch (direction) {
                    case 3: {
                        dx = 1;
                        dy = 0;
                        break;
                    }
                    case 2: {
                        dx = -1;
                        dy = 0;
                        break;
                    }
                    case 0: {
                        dx = 0;
                        dy = -1;
                        break;
                    }
                    default: {
                        dx = 0;
                        dy = 1;
                    }
                }
                int sx = JDomUtility.getIntAttr(child, STEP, d.width);
                int sy = JDomUtility.getIntAttr(child, STEP, d.height);
                this.progressAnimationRect = new Rectangle(pos, d);
                this.progressAnimation = new AnimatedActiveBox(null, this, 0, this.progressAnimationRect, this.getBoxBase(child, null));
                this.progressAnimation.setDelay(delay);
                abc = new ActiveBagContent(1, frames);
                for (int i = 0; i < frames; ++i) {
                    ActiveBoxContent ab = new ActiveBoxContent();
                    ab.setImgContent(this.img, new Rectangle(source.x + dx * i * sx, source.y + dy * i * sy, d.width, d.height));
                    ((ActiveBagContent)abc).addActiveBoxContent(ab);
                }
                this.progressAnimation.setContent((ActiveBagContent)abc);
                this.progressAnimation.setVisible(!this.hideProgressAnim);
            }
        }
        if ((child = e.getChild(STATUS_BAR)) != null) {
            BoxBase bbMsgDef = this.getBoxBase(child, null);
            this.textColor = bbMsgDef.textColor;
            for (int i = 0; i < 3; ++i) {
                child2 = JDomUtility.getChildWithId(child, MSG_AREA, msgAreaNames[i]);
                if (child2 == null) continue;
                this.msgAreaRect[i] = JDomUtility.getRectangle(child2, null, null);
                bb = this.getBoxBase(child2, bbMsgDef);
                bb.textMargin = 0;
                this.msgArea[i] = new ActiveBox(null, this, 0, this.msgAreaRect[i], bb);
                ActiveBoxContent abc2 = new ActiveBoxContent();
                abc2.setBoxBase(bb);
                abc2.setTxtAlign(JDomUtility.getAlignment(child2, null, null));
                this.msgArea[i].setContent(abc2);
            }
        }
        if ((child = e.getChild(BUTTONS)) != null) {
            child2 = child.getChild(SETTINGS);
            Dimension dDef = JDomUtility.getDimension(child2, null, new Dimension());
            Point activeDef = JDomUtility.getOffset(child2, ACTIVE, null);
            Point overDef = JDomUtility.getOffset(child2, OVER, null);
            Point disabledDef = JDomUtility.getOffset(child2, DISABLED, null);
            for (int i = 0; i < 8; ++i) {
                child2 = JDomUtility.getChildWithId(child, BUTTON, Constants.ACTION_NAME[i]);
                if (child2 == null) continue;
                Point pos = JDomUtility.getPoint(child2, POS, null);
                boolean toggle = JDomUtility.getBoolAttr(child2, TOGGLE, false);
                if (pos == null) continue;
                child3 = child2.getChild(SETTINGS);
                Dimension d = JDomUtility.getDimension(child3, null, dDef);
                this.buttonsRect[i] = new Rectangle(pos, d);
                Point source = JDomUtility.getPoint(child2, SOURCE, null);
                Point active = JDomUtility.getOffset(child3, ACTIVE, activeDef);
                Point over = JDomUtility.getOffset(child3, OVER, overDef);
                Point disabled = JDomUtility.getOffset(child3, DISABLED, disabledDef);
                this.buttons[i] = this.createButton(i, d, source, active, over, disabled, toggle);
            }
        }
        if ((child = e.getChild(COUNTERS)) != null) {
            child2 = child.getChild(SETTINGS);
            Dimension dCounterDef = JDomUtility.getDimension(child2, COUNTER, new Dimension());
            Dimension dLabelDef = JDomUtility.getDimension(child2, LABEL, new Dimension());
            int[] dLabelAlign = JDomUtility.getAlignment(child2, LABEL, null);
            BoxBase bbCountersDef = this.getBoxBase(child, null);
            child2 = child.getChild(DIGITS);
            Dimension dSizeDef = JDomUtility.getDimension(child2, null, null);
            Point dOriginDef = JDomUtility.getPoint(child2, SOURCE, null);
            for (int i = 0; i < 3; ++i) {
                Point labelPos;
                child2 = JDomUtility.getChildWithId(child, COUNTER, Constants.counterNames[i]);
                if (child2 == null) continue;
                child3 = child.getChild(SETTINGS);
                bb = this.getBoxBase(child2, bbCountersDef);
                bb.textMargin = 0;
                Point counterPos = JDomUtility.getPoint(child2, COUNTER, null);
                if (counterPos != null) {
                    Dimension dCounter = JDomUtility.getDimension(child3, COUNTER, dCounterDef);
                    this.countersRect[i][0] = new Rectangle(counterPos, dCounter);
                    Element child4 = child2.getChild(DIGITS);
                    Dimension dSize = JDomUtility.getDimension(child4, null, dSizeDef);
                    Point dOrigin = JDomUtility.getPoint(child4, SOURCE, dOriginDef);
                    this.counters[i] = new Counter(null, this, this.countersRect[i][0], bb);
                    this.counters[i].setSource(this.img, dOrigin, dSize);
                }
                if ((labelPos = JDomUtility.getPoint(child2, LABEL, null)) == null) continue;
                Dimension dLabel = JDomUtility.getDimension(child3, LABEL, dLabelDef);
                this.countersRect[i][1] = new Rectangle(labelPos, dLabel);
                this.countersLabel[i] = new ActiveBox(null, this, 0, this.countersRect[i][1], bb);
                abc = new ActiveBoxContent();
                ((ActiveBoxContent)abc).setBoxBase(bb);
                ((ActiveBoxContent)abc).setTxtAlign(JDomUtility.getAlignment(child2, LABEL, dLabelAlign));
                ((ActiveBoxContent)abc).setTextContent(this.ps.getMsg("label_" + Constants.counterNames[i]));
                this.countersLabel[i].setContent((ActiveBoxContent)abc);
            }
        }
        int k = 0;
        for (int c = 0; c < 3; ++c) {
            this.boxes[k++] = this.counters[c];
            this.boxes[k++] = this.countersLabel[c];
        }
        for (int l = 0; l < 3; ++l) {
            this.boxes[k++] = this.msgArea[l];
        }
        this.boxes[k++] = this.msgBox;
        this.boxes[k++] = this.progressAnimation;
        this.initiated = 1;
    }

    protected BoxBase getBoxBase(Element e, BoxBase defaultValue) throws Exception {
        Element child;
        if (e == null || (child = e.getChild(STYLE)) == null) {
            return defaultValue;
        }
        BoxBase bb = defaultValue == null ? new BoxBase() : BoxBase.getBoxBase(defaultValue.getJDomElement());
        Element child2 = child.getChild("font");
        if (child2 != null) {
            bb.setFont(JDomUtility.elementToFont(child2));
        }
        bb.textColor = JDomUtility.getColorByPoint(child, FOREGROUND, this.img, bb.textColor);
        bb.backColor = JDomUtility.getColorByPoint(child, BACKGROUND, this.img, bb.backColor);
        bb.transparent = bb.backColor == BoxBase.DEFAULT_BACK_COLOR ? true : JDomUtility.getBoolAttr(child, "transparent", bb.transparent);
        bb.textMargin = JDomUtility.getIntAttr(child, "margin", bb.textMargin);
        return bb;
    }

    @Override
    public void doLayout() {
        int i;
        if (this.initiated < 1) {
            this.invalidate();
            return;
        }
        super.doLayout();
        if (this.player != null) {
            this.player.setBounds(this.translateRect(this.playerRect));
        }
        if (this.progressBar != null) {
            this.progressBar.setBounds(this.translateRect(this.progressBarRect));
        }
        for (i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null) continue;
            this.buttons[i].setBounds(this.translateRect(this.buttonsRect[i]));
        }
        for (i = 0; i < 3; ++i) {
            if (this.counters[i] != null) {
                this.counters[i].setLocation(this.translatePoint(this.countersRect[i][0].getLocation()));
            }
            if (this.countersLabel[i] == null) continue;
            this.countersLabel[i].setLocation(this.translatePoint(this.countersRect[i][1].getLocation()));
        }
        if (this.msgBox != null) {
            this.msgBox.setBounds(this.translateRect(this.msgRect));
        }
        if (this.progressAnimation != null) {
            this.progressAnimation.setBounds(this.translateRect(this.progressAnimationRect));
        }
        for (i = 0; i < 3; ++i) {
            if (this.msgArea[i] == null) continue;
            this.msgArea[i].setBounds(this.translateRect(this.msgAreaRect[i]));
        }
        if (this.player != null) {
            this.initiated = 2;
        }
    }

    @Override
    public void startAnimation() {
        if (this.progressAnimation != null) {
            if (this.hideProgressAnim) {
                this.progressAnimation.setStartDelay(1000);
            }
            this.progressAnimation.start();
        }
    }

    @Override
    public void stopAnimation() {
        if (this.progressAnimation != null) {
            if (this.hideProgressAnim) {
                this.progressAnimation.setVisible(false);
            }
            this.progressAnimation.stop(false);
        }
    }

    @Override
    public void render(Graphics2D g2, Rectangle clip) {
        int i;
        if (this.player == null || this.initiated < 2) {
            return;
        }
        if (!this.readyToPaint) {
            this.readyToPaint = true;
        }
        if (this.counters != null) {
            for (i = 0; i < 3; ++i) {
                if (this.counters[i] == null || !this.counters[i].getBounds().equals(clip)) continue;
                Utils.drawImage(g2, this.img, this.counters[i].getBounds(), this.countersRect[i][0], this);
                this.counters[i].update(g2, clip, this);
                return;
            }
        }
        this.drawSlicedFrame(g2, this.getBounds(), this.frame, this.img, this.leftSlicer, this.rightSlicer, this.topSlicer, this.bottomSlicer);
        if (this.boxes != null) {
            for (i = 0; i < 11; ++i) {
                if (this.boxes[i] == null) continue;
                this.boxes[i].update(g2, clip, this);
                if (!this.boxes[i].getBounds().equals(clip)) continue;
                return;
            }
        }
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        if (this.ps != null && this.countersLabel != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.countersLabel[i] == null) continue;
                this.countersLabel[i].setTextContent(this.ps.getMsg("label_" + Constants.counterNames[i]));
            }
        }
    }

    protected AbstractButton createButton(int buttonId, Dimension d, Point source, Point active, Point over, Point disabled, boolean toggle) {
        AbstractButton button;
        Action action = this.ps.getAction(buttonId);
        if (source != null) {
            ImageIcon icon = new ImageIcon(this.img.getSubimage(source.x, source.y, d.width, d.height));
            button = !toggle ? new JButton(action) : new JToggleButton(action);
            button.setIcon(icon);
            button.setText(null);
            if (active != null) {
                icon = new ImageIcon(this.img.getSubimage(source.x + active.x, source.y + active.y, d.width, d.height));
                if (!toggle) {
                    button.setPressedIcon(icon);
                } else {
                    button.setSelectedIcon(icon);
                }
            }
            if (over != null) {
                icon = new ImageIcon(this.img.getSubimage(source.x + over.x, source.y + over.y, d.width, d.height));
                button.setRolloverIcon(icon);
            }
            if (disabled != null) {
                icon = new ImageIcon(this.img.getSubimage(source.x + disabled.x, source.y + disabled.y, d.width, d.height));
                button.setDisabledIcon(icon);
            }
            button.setFocusPainted(false);
            button.setBorderPainted(false);
            button.setBorder(new EmptyBorder(0, 0, 0, 0));
            button.setContentAreaFilled(false);
            button.setMargin(new Insets(0, 0, 0, 0));
        } else {
            button = new JButton(action);
        }
        button.setPreferredSize(this.buttonsRect[buttonId].getSize());
        button.setVisible(true);
        if (toggle) {
            Object o = action.getValue("Default");
            button.setSelected(o != null && o.equals(Boolean.FALSE));
            action.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("selected")) {
                        button.setSelected(evt.getNewValue().equals(Boolean.FALSE));
                    }
                }
            });
        }
        this.add(button);
        return button;
    }

    Point translatePoint(Point pt) {
        Rectangle bounds = this.getBounds();
        Dimension extra = new Dimension(bounds.width - this.frame.width, bounds.height - this.frame.height);
        Point result = new Point(pt);
        if (pt.x > this.rightSlicer) {
            result.x += extra.width;
        }
        if (pt.y > this.bottomSlicer) {
            result.y += extra.height;
        }
        return result;
    }

    Rectangle translateRect(Rectangle r) {
        Rectangle bounds = this.getBounds();
        Dimension extra = new Dimension(bounds.width - this.frame.width, bounds.height - this.frame.height);
        Rectangle result = new Rectangle(r.x, r.y, r.width, r.height);
        if (r.x > this.rightSlicer) {
            result.x += extra.width;
        } else if (r.x + r.width > this.leftSlicer) {
            result.width += extra.width;
        }
        if (r.y > this.bottomSlicer) {
            result.y += extra.height;
        } else if (r.y + r.height > this.topSlicer) {
            result.height += extra.height;
        }
        return result;
    }

    @Override
    public void setProgressMax(int max) {
        super.setProgressMax(max);
        if (this.progressBar != null) {
            this.progressBar.setMaximum(max);
        }
    }

    @Override
    public void setProgressValue(int value) {
        super.setProgressValue(value);
        if (this.progressBar != null) {
            this.progressBar.setValue(value);
            if (!this.progressBar.isVisible() && System.currentTimeMillis() - this.progressStartTime >= 1000L) {
                this.progressBar.setVisible(true);
            }
        }
    }

    @Override
    public void endProgress() {
        super.endProgress();
        if (this.progressBar != null && this.hideProgressBar) {
            this.progressBar.setVisible(false);
        }
    }
}

