/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class GlobalMouseAdapter
implements MouseListener,
MouseMotionListener {
    protected Component parent;

    public GlobalMouseAdapter(Component parent) {
        this.parent = parent;
    }

    public void attachTo(Component cmp, boolean catchMotion) {
        cmp.addMouseListener(this);
        if (catchMotion) {
            cmp.addMouseMotionListener(this);
        }
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public void detach(Component cmp) {
        if (cmp != null) {
            cmp.removeMouseListener(this);
            cmp.removeMouseMotionListener(this);
        }
    }

    protected void processEvent(MouseEvent e) {
        Point pt = e.getComponent().getLocation();
        e.translatePoint(pt.x, pt.y);
        this.parent.dispatchEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processEvent(e);
    }
}

