/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class PersistentSettings {
    public static final String BASE = ".edu.xtec.properties";
    public static final String BASE_OLD = "edu.xtec.properties";
    public static final String BUNDLE = "messages.PersistentPathsMessages";
    public static final String BASE_PREFS_NODE = "/edu/xtec";
    public static final String JCLIC_PREFS_NODE = "/edu/xtec/jclic";
    public static Preferences userPrefs = Preferences.userRoot().node("/edu/xtec");
    public static Preferences systemPrefs = Preferences.systemRoot().node("/edu/xtec/jclic");

    private static Properties getProperties() throws Exception {
        Properties prop = new Properties();
        String[] keys = userPrefs.keys();
        if (keys.length == 0) {
            StringBuilder sb = new StringBuilder(300);
            sb.append(System.getProperty("user.dir"));
            sb.append(File.pathSeparator);
            sb.append(System.getProperty("user.home"));
            sb.append(File.pathSeparator);
            sb.append(System.getProperty("java.home")).append(File.separator).append("lib");
            sb.append(File.pathSeparator).append(System.getProperty("java.ext.dirs"));
            File baseFile = null;
            StringTokenizer st = new StringTokenizer(sb.substring(0), File.pathSeparator);
            while (baseFile == null && st.hasMoreTokens()) {
                String s = st.nextToken();
                File dir = new File(s);
                if (!dir.exists() || !dir.isDirectory()) continue;
                File testFile = new File(dir, BASE);
                if (testFile.canRead()) {
                    baseFile = testFile;
                    continue;
                }
                testFile = new File(dir, BASE_OLD);
                if (!testFile.canRead()) continue;
                baseFile = testFile;
            }
            if (baseFile != null) {
                FileInputStream is = new FileInputStream(baseFile);
                prop.load(is);
                ((InputStream)is).close();
                PersistentSettings.saveSettings(prop);
            }
        } else {
            for (String k : keys) {
                prop.put(k, userPrefs.get(k, ""));
            }
        }
        return prop;
    }

    public static File getBasePathTo(String programName, Options options) throws Exception {
        File d;
        Properties prop = PersistentSettings.getProperties();
        String path = (String)prop.get(programName);
        if (!(path == null || (d = new File(path)).exists() && d.isDirectory())) {
            path = null;
        }
        if (path == null) {
            String sPath = System.getProperty("user.home") + File.separator + programName;
            Messages messages = PersistentSettings.getMessages(options, BUNDLE);
            String msg = messages.get("cl_alert");
            int i = msg.indexOf(36);
            if (i >= 0) {
                msg = msg.substring(0, i) + programName + msg.substring(i + 1);
            }
            boolean done = false;
            File d2 = new File(sPath);
            while (!done) {
                String result = (String)JOptionPane.showInputDialog(options.getMainComponent(), msg, messages.get("cl_prompt_title"), 3, null, null, sPath);
                if (result == null) {
                    throw new Exception("bad user input!");
                }
                d2 = new File(result);
                try {
                    if (!d2.exists() || !d2.isDirectory()) {
                        d2.mkdirs();
                    }
                    done = d2.exists() && d2.isDirectory();
                }
                catch (Exception ex) {
                    messages.showErrorWarning(options.getMainComponent(), "cl_err_unableToCreateDir", ex);
                }
            }
            path = d2.getAbsolutePath();
            prop.setProperty(programName, path);
            PersistentSettings.saveSettings(prop);
        }
        return new File(path);
    }

    private static void saveSettings(Properties prop) throws Exception {
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = prop.getProperty(key, "");
            userPrefs.put(key, value);
        }
        userPrefs.flush();
    }

    public static Messages getMessages(Options options, String bundle) throws Exception {
        Messages msg = (Messages)options.get("messages");
        if (msg == null) {
            boolean mustSave = false;
            String l = (String)options.get("language");
            Properties prop = null;
            if (l == null) {
                prop = PersistentSettings.getProperties();
                l = prop.getProperty("language");
                if (l != null) {
                    options.put("language", l);
                } else {
                    mustSave = true;
                }
            } else {
                options.put("languageByParam", Options.BTRUE);
            }
            msg = Messages.getMessages(options, bundle);
            if (mustSave && prop != null) {
                prop.setProperty("language", (String)options.get("language"));
                PersistentSettings.saveSettings(prop);
            }
        } else if (bundle != null) {
            msg.addBundle(bundle);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFilePath(String programName, String fileName, Options options, boolean createFile) {
        File base;
        String result = null;
        try {
            base = PersistentSettings.getBasePathTo(programName, options);
        }
        catch (Exception ex) {
            base = new File(System.getProperty("user.home"));
        }
        File testFile = new File(base, fileName);
        if (testFile.canRead()) {
            result = testFile.getAbsolutePath();
        } else if (createFile) {
            try {
                FileOutputStream fos = new FileOutputStream(testFile);
                fos.close();
                testFile.delete();
            }
            catch (Exception ex) {
                testFile = new File(fileName);
            }
            finally {
                result = testFile.getAbsolutePath();
            }
        }
        return result;
    }
}

