/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class StrUtils {
    public static void strToIntArray(String str, int[] intArray) {
        if (str == null || intArray == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, ",", false);
        for (int i = 0; st.hasMoreTokens() && i < intArray.length; ++i) {
            try {
                intArray[i] = Integer.parseInt(st.nextToken().trim());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void strToPoint(String str, Point pt) {
        int[] values = new int[2];
        StrUtils.strToIntArray(str, values);
        pt.x = values[0];
        pt.y = values[1];
    }

    public static void strToDimension(String str, Dimension d) {
        int[] values = new int[2];
        StrUtils.strToIntArray(str, values);
        d.width = values[0];
        d.height = values[1];
    }

    public static void strToRect(String str, Rectangle r) {
        int[] values = new int[4];
        StrUtils.strToIntArray(str, values);
        r.setBounds(values[0], values[1], values[2], values[3]);
    }

    public static String[] strToStrArray(String source, String separator) {
        if (source == null || separator == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(source, separator, true);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (separator.equals(s)) {
                v.add(new String());
                continue;
            }
            v.add(s);
            if (!st.hasMoreTokens()) continue;
            st.nextToken();
        }
        return v.toArray(new String[v.size()]);
    }

    public static String[] strToStrArrayNoNulls(String source, String separator) throws Exception {
        String[] result = StrUtils.strToStrArray(source, separator);
        if (result == null || result.length == 0) {
            throw new Exception("Invalid parameter: " + source);
        }
        for (String s : result) {
            if (s != null && s.length() != 0) continue;
            throw new Exception("Invalid parameter: " + source);
        }
        return result;
    }

    public static byte[] extractByteSeq(byte[] data, int line, byte searchFor, byte changeTo) {
        byte[] result = null;
        int l = data.length;
        int k = 0;
        int p0 = 0;
        int p1 = 0;
        for (int i = 0; i < l; ++i) {
            if (data[i] != 13 || i >= l || data[i + 1] != 10) continue;
            p0 = p1 == 0 ? p1 : p1 + 2;
            p1 = i;
            if (k == line) break;
            ++k;
        }
        if (p1 > p0) {
            int j = p1 - p0;
            result = new byte[j];
            for (int i = 0; i < j; ++i) {
                result[i] = data[p0 + i];
                if (result[i] != searchFor) continue;
                result[i] = changeTo;
            }
        }
        return result;
    }

    public static int roundTo(double v, int n) {
        return (int)(v / (double)n) * n;
    }

    public static int countSpaces(String tx) {
        String t = tx.trim();
        int j = 0;
        for (char ch : t.toCharArray()) {
            if (ch != ' ') continue;
            ++j;
        }
        return j;
    }

    public static boolean compareStringsIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.compareToIgnoreCase(s2) == 0;
    }

    public static boolean compareTrimStringsIgnoreCase(Object s1, Object s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.toString().trim().compareToIgnoreCase(s2.toString().trim()) == 0;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String replace(String str, String pattern, String replace) {
        int e;
        int s = 0;
        if (str == null) {
            str = "";
        }
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            if (replace != null) {
                result.append(replace);
            }
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.substring(0);
    }

    public static String replace(String str, String pattern, String[] replace) {
        int e;
        int s = 0;
        if (str == null) {
            str = "";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            if (replace != null) {
                result.append(replace[i++ % replace.length]);
            }
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.substring(0);
    }

    public static boolean compareMultipleOptions(String answer, String check, boolean checkCase) {
        if (answer == null || answer.length() == 0 || check == null || check.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(check, "|");
        while (st.hasMoreTokens()) {
            if (!(checkCase ? st.nextToken().equals(answer) : st.nextToken().equalsIgnoreCase(answer))) continue;
            return true;
        }
        return false;
    }

    public static String secureString(Object data) {
        if (data == null) {
            return new String();
        }
        return data.toString();
    }

    public static String secureString(Object data, String defaultValue) {
        String result = StrUtils.nullableString(data);
        return result == null ? defaultValue : result;
    }

    public static String nullableString(Object o) {
        String result = null;
        if (o != null && (result = o.toString().trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    public static String trimEnding(String str) {
        String result = str;
        if (result != null) {
            char ch;
            int p;
            int p0 = p = result.length() - 1;
            while (p >= 0 && ((ch = result.charAt(p)) == ' ' || ch == '\n' || ch == '\r')) {
                --p;
            }
            if (p != p0) {
                result = result.substring(0, p + 1);
            }
        }
        return result;
    }

    public static String secureSQLString(String data) {
        return StrUtils.replace(StrUtils.secureString(data), "'", "''");
    }

    public static int getAbsIntValueOf(String s) {
        int result = -1;
        if (s != null && s.length() > 0) {
            for (char ch : s.toCharArray()) {
                if (ch >= '0' && ch <= '9') continue;
                return result;
            }
            try {
                result = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                result = -1;
            }
        }
        return result;
    }

    public static String getShortExpression(String text, int maxLen) {
        String result = StrUtils.secureString(text).trim();
        if (maxLen > 0 && result.length() > maxLen) {
            result = result.substring(0, maxLen);
            for (int p = maxLen - 1; p > 2 * maxLen / 3; --p) {
                if (!Character.isSpaceChar(result.charAt(p))) continue;
                result = result.substring(0, p) + "...";
                break;
            }
        }
        return result;
    }

    public static String limitStrLen(String text, int maxLen) {
        String result = text;
        if (result != null && result.length() > maxLen) {
            result = result.substring(0, maxLen);
        }
        return result;
    }

    public static int getIndexOf(String val, String[] ops) {
        int result = -1;
        if (val != null && ops != null) {
            for (int k = 0; k < ops.length; ++k) {
                if (!val.equals(ops[k])) continue;
                result = k;
                break;
            }
        }
        return result;
    }

    public static String safeHtml(String s) {
        return StrUtils.secureString(s).replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("&", "&amp;");
    }

    public static String getEnumeration(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (String s : array) {
            String tr;
            if (s == null || (tr = s.trim()).length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(tr);
        }
        return sb.toString();
    }
}

