/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ConnectionBean {
    private Connection con;
    private Map<String, PreparedStatement> statements;
    private Date born;
    private Date lastUsed;
    private String lastStatement;
    private Date closed;
    public int usageCount;

    public ConnectionBean(Connection con, boolean mapStatements) {
        this.con = con;
        if (mapStatements) {
            this.statements = new HashMap<String, PreparedStatement>();
        }
        this.born = new Date();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionBean ").append(this.hashCode());
        if (this.statements != null) {
            sb.append(" (").append(this.statements.size()).append(" statements)");
        }
        sb.append("<br>\n");
        sb.append("Created: ").append(this.born).append("<br>\n");
        sb.append("Usage count: ").append(this.usageCount).append("<br>\n");
        if (this.lastUsed == null) {
            sb.append("Not yet used!<br>\n");
        } else {
            sb.append("Last used: ").append(this.lastUsed).append("<br>\n");
            sb.append("Last statement: ").append(this.lastStatement).append("<br>\n");
        }
        if (this.closed != null) {
            sb.append("Closed: ").append(this.closed).append("<br>\n");
        }
        return sb.toString();
    }

    public Connection getConnection() {
        this.lastUsed = new Date();
        return this.con;
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        if (this.closed != null) {
            throw new SQLException("Connection closed!");
        }
        this.lastUsed = new Date();
        this.lastStatement = sql;
        PreparedStatement preparedStatement = stmt = this.statements == null ? null : this.statements.get(sql);
        if (stmt == null) {
            stmt = this.con.prepareStatement(sql);
            if (this.statements != null) {
                this.statements.put(sql, stmt);
            }
        } else {
            try {
                stmt.clearParameters();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stmt;
    }

    public PreparedStatement getPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        if (this.closed != null) {
            throw new SQLException("Connection closed!");
        }
        this.lastUsed = new Date();
        this.lastStatement = sql;
        PreparedStatement preparedStatement = stmt = this.statements == null ? null : this.statements.get(sql);
        if (stmt == null) {
            stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
            if (this.statements != null) {
                this.statements.put(sql, stmt);
            }
        } else {
            try {
                stmt.clearParameters();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stmt;
    }

    public void closeStatement(PreparedStatement stmt) {
        this.closeStatement(stmt, false);
    }

    public void closeStatement(PreparedStatement stmt, boolean forceClose) {
        if (stmt != null) {
            if (forceClose || this.statements == null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    System.err.println("Error closing statement: " + stmt);
                }
            }
            if (this.statements != null && forceClose) {
                for (String s : this.statements.keySet()) {
                    PreparedStatement ps = this.statements.get(s);
                    if (ps == null || ps != stmt) continue;
                    this.statements.remove(s);
                    break;
                }
            }
        }
    }

    public void closeConnection() throws SQLException {
        if (this.closed == null) {
            this.closed = new Date();
            if (this.statements != null) {
                for (String s : this.statements.keySet()) {
                    PreparedStatement stmt = this.statements.get(s);
                    if (stmt == null) continue;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                this.statements.clear();
            }
            this.con.close();
        }
    }

    public String getLastStatement() {
        return this.lastStatement;
    }

    public int getNumStatements() {
        return this.statements == null ? 0 : this.statements.size();
    }
}

