/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItem;
import VASSAL.build.module.gamepieceimage.ShapeItem;
import VASSAL.build.module.gamepieceimage.SymbolItem;
import VASSAL.build.module.gamepieceimage.TextBoxItem;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Dimension;
import java.awt.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Item
extends AbstractConfigurable {
    public static final String TYPE = "";
    protected static final String NAME = "name";
    protected static final String LOCATION = "location";
    protected static final String ADVANCED = "advanced";
    protected static final String ROTATION = "rotation";
    protected static final String X_OFFSET = "xoffset";
    protected static final String Y_OFFSET = "yoffset";
    protected static final String ANTIALIAS = "antialias";
    String location = "Center";
    protected int xoffset;
    protected int yoffset;
    protected boolean advanced = false;
    protected int rotation = 0;
    protected boolean antialias = true;
    protected GamePieceLayout layout;
    private VisibilityCondition advancedCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return Item.this.advanced;
        }
    };

    public Item() {
        this.setConfigureName(TYPE);
    }

    public Item(GamePieceLayout gamePieceLayout) {
        this();
        this.layout = gamePieceLayout;
    }

    public Item(String string) {
        this();
        this.setConfigureName(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Location:  ", "Advanced Options", "X Offset:  ", "Y Offset:  ", "Rotation (Degrees):  ", "Anti-alias?"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, LocationConfig.class, Boolean.class, Integer.class, Integer.class, Integer.class, Boolean.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, LOCATION, ADVANCED, X_OFFSET, Y_OFFSET, ROTATION, ANTIALIAS};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (LOCATION.equals(string)) {
            this.location = (String)object;
        } else if (X_OFFSET.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.xoffset = (Integer)object;
        } else if (Y_OFFSET.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.yoffset = (Integer)object;
        } else if (ADVANCED.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.advanced = (Boolean)object;
        } else if (ROTATION.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.rotation = (Integer)object;
        } else if (ANTIALIAS.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.antialias = (Boolean)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (LOCATION.equals(string)) {
            return this.location + TYPE;
        }
        if (X_OFFSET.equals(string)) {
            return this.xoffset + TYPE;
        }
        if (Y_OFFSET.equals(string)) {
            return this.yoffset + TYPE;
        }
        if (ADVANCED.equals(string)) {
            return this.advanced + TYPE;
        }
        if (ROTATION.equals(string)) {
            return this.rotation + TYPE;
        }
        if (ANTIALIAS.equals(string)) {
            return this.antialias + TYPE;
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (ROTATION.equals(string) || X_OFFSET.equals(string) || Y_OFFSET.equals(string) || ANTIALIAS.equals(string)) {
            return this.advancedCond;
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable buildable) {
        this.setAllAttributesUntranslatable();
    }

    public abstract void draw(Graphics var1, GamePieceImage var2);

    public abstract String getType();

    public abstract Dimension getSize();

    public String getDisplayName() {
        return this.getType();
    }

    public String getLocation() {
        return this.location;
    }

    public int getXoffset() {
        return this.xoffset;
    }

    public int getYoffset() {
        return this.yoffset;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    protected GamePieceLayout getLayout() {
        return this.layout;
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        Item item;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '|');
        String string2 = decoder.nextToken(TYPE);
        String string3 = decoder.nextToken(TYPE);
        if (string2.startsWith("Symbol")) {
            item = SymbolItem.decode(gamePieceLayout, string2);
        } else if (string2.startsWith("TextBox")) {
            item = TextBoxItem.decode(gamePieceLayout, string2);
        } else if (string2.startsWith("Text")) {
            item = TextItem.decode(gamePieceLayout, string2);
        } else if (string2.startsWith("Image")) {
            item = ImageItem.decode(gamePieceLayout, string2);
        } else if (string2.startsWith("Box")) {
            item = ShapeItem.decode(gamePieceLayout, string2);
        } else {
            return null;
        }
        SequenceEncoder.Decoder decoder2 = new SequenceEncoder.Decoder(string3, ';');
        item.setConfigureName(decoder2.nextToken());
        item.location = decoder2.nextToken();
        item.xoffset = decoder2.nextInt(0);
        item.yoffset = decoder2.nextInt(0);
        item.rotation = decoder2.nextInt(0);
        item.antialias = decoder2.nextBoolean(true);
        return item;
    }

    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getConfigureName());
        sequenceEncoder.append(this.location);
        sequenceEncoder.append(this.xoffset);
        sequenceEncoder.append(this.yoffset);
        sequenceEncoder.append(this.rotation);
        sequenceEncoder.append(this.antialias);
        return sequenceEncoder.getValue();
    }

    public static class LocationConfig
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return GamePieceLayout.LOCATIONS;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, Item.TYPE);
        }
    }
}

