/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.Command;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapShader
extends AbstractConfigurable
implements GameComponent,
Drawable,
UniqueIdManager.Identifyable {
    public static final String NAME = "name";
    public static final String ALWAYS_ON = "alwaysOn";
    public static final String STARTS_ON = "startsOn";
    public static final String HOT_KEY = "hotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOLTIP = "tooltip";
    public static final String BOARDS = "boards";
    public static final String BOARD_LIST = "boardList";
    public static final String ALL_BOARDS = "Yes";
    public static final String EXC_BOARDS = "No, exclude Boards in list";
    public static final String INC_BOARDS = "No, only shade Boards in List";
    protected static UniqueIdManager idMgr = new UniqueIdManager("MapShader");
    protected LaunchButton launch;
    protected boolean alwaysOn = false;
    protected boolean startsOn = false;
    protected String boardSelection = "Yes";
    protected String[] boardList = new String[0];
    protected boolean shadingVisible;
    protected boolean scaleImage;
    protected Map map;
    protected String id;
    protected Area boardClip = null;
    public static final String TYPE = "type";
    public static final String DRAW_OVER = "drawOver";
    public static final String PATTERN = "pattern";
    public static final String COLOR = "color";
    public static final String IMAGE = "image";
    public static final String SCALE_IMAGE = "scaleImage";
    public static final String OPACITY = "opacity";
    public static final String BORDER = "border";
    public static final String BORDER_COLOR = "borderColor";
    public static final String BORDER_WIDTH = "borderWidth";
    public static final String BORDER_OPACITY = "borderOpacity";
    public static final String BG_TYPE = "Background";
    public static final String FG_TYPE = "Foreground";
    public static final String TYPE_25_PERCENT = "25%";
    public static final String TYPE_50_PERCENT = "50%";
    public static final String TYPE_75_PERCENT = "75%";
    public static final String TYPE_SOLID = "100% (Solid)";
    public static final String TYPE_IMAGE = "Custom Image";
    protected String imageName;
    protected Color color = Color.BLACK;
    protected String type = "Foreground";
    protected boolean drawOver = false;
    protected String pattern = "25%";
    protected int opacity = 100;
    protected boolean border = false;
    protected Color borderColor = Color.BLACK;
    protected int borderWidth = 1;
    protected int borderOpacity = 100;
    protected Area shape;
    @Deprecated
    protected BufferedImage shadePattern = null;
    protected Rectangle patternRect = new Rectangle();
    protected ImageOp srcOp;
    protected TexturePaint texture = null;
    protected java.util.Map<Double, TexturePaint> textures = new HashMap<Double, TexturePaint>();
    protected AlphaComposite composite = null;
    protected AlphaComposite borderComposite = null;
    protected BasicStroke stroke = null;

    @Override
    public void draw(Graphics graphics, Map map) {
        if (this.shadingVisible) {
            double d = map.getZoom();
            this.buildStroke(d);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Color color = graphics2D.getColor();
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setComposite(this.getComposite());
            graphics2D.setColor(this.getColor());
            graphics2D.setPaint(this.scaleImage && this.pattern.equals(TYPE_IMAGE) && this.imageName != null ? this.getTexture(d) : this.getTexture());
            Area area = this.getShadeShape(map);
            if (d != 1.0) {
                area = new Area(AffineTransform.getScaleInstance(d, d).createTransformedShape(area));
            }
            graphics2D.fill(area);
            if (this.border) {
                graphics2D.setComposite(this.getBorderComposite());
                graphics2D.setStroke(this.getStroke(map.getZoom()));
                graphics2D.setColor(this.getBorderColor());
                graphics2D.draw(area);
            }
            graphics2D.setComposite(composite);
            graphics2D.setColor(color);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    protected AlphaComposite getComposite() {
        if (this.composite == null) {
            this.buildComposite();
        }
        return this.composite;
    }

    protected void buildComposite() {
        this.composite = AlphaComposite.getInstance(3, (float)this.opacity / 100.0f);
    }

    protected AlphaComposite getBorderComposite() {
        if (this.borderComposite == null) {
            this.borderComposite = this.buildBorderComposite();
        }
        return this.borderComposite;
    }

    protected AlphaComposite buildBorderComposite() {
        return AlphaComposite.getInstance(3, (float)this.borderOpacity / 100.0f);
    }

    protected Area getShadeShape(Map map) {
        Area area = this.type.equals(FG_TYPE) ? new Area() : new Area(this.getBoardClip());
        for (GamePiece gamePiece : map.getPieces()) {
            this.checkPiece(area, gamePiece);
        }
        return area;
    }

    protected void checkPiece(Area area, GamePiece gamePiece) {
        if (gamePiece instanceof Stack) {
            Stack stack = (Stack)gamePiece;
            for (int i = 0; i < stack.getPieceCount(); ++i) {
                this.checkPiece(area, stack.getPieceAt(i));
            }
        } else {
            Area area2;
            ShadedPiece shadedPiece = (ShadedPiece)((Object)Decorator.getDecorator(gamePiece, ShadedPiece.class));
            if (shadedPiece != null && (area2 = shadedPiece.getArea(this)) != null) {
                if (this.type.equals(FG_TYPE)) {
                    area.add(area2);
                } else {
                    area.subtract(area2);
                }
            }
        }
    }

    protected BufferedImage getShadePattern() {
        if (this.srcOp == null) {
            this.buildShadePattern();
        }
        return this.srcOp.getImage();
    }

    protected BufferedImage getShadePattern(double d) {
        if (this.srcOp == null) {
            this.buildShadePattern();
        }
        return Op.scale(this.srcOp, d).getImage();
    }

    protected Rectangle getPatternRect() {
        return this.patternRect;
    }

    protected Rectangle getPatternRect(double d) {
        return new Rectangle((int)Math.round(d * (double)this.patternRect.width), (int)Math.round(d * (double)this.patternRect.height));
    }

    protected void buildShadePattern() {
        this.srcOp = this.pattern.equals(TYPE_IMAGE) && this.imageName != null ? Op.load(this.imageName) : new PatternOp(this.color, this.pattern);
        this.patternRect = new Rectangle(this.srcOp.getSize());
    }

    protected BasicStroke getStroke(double d) {
        if (this.stroke == null) {
            this.buildStroke(d);
        }
        return this.stroke;
    }

    protected void buildStroke(double d) {
        this.stroke = new BasicStroke((float)Math.min((double)this.borderWidth * d, 1.0), 1, 1);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    protected TexturePaint getTexture() {
        if (this.texture == null) {
            this.buildTexture();
        }
        return this.texture;
    }

    protected TexturePaint getTexture(double d) {
        if (d == 1.0) {
            return this.getTexture();
        }
        TexturePaint texturePaint = this.textures.get(d);
        if (texturePaint == null) {
            texturePaint = new TexturePaint(this.getShadePattern(d), this.getPatternRect(d));
            this.textures.put(d, texturePaint);
        }
        return texturePaint;
    }

    protected void buildTexture() {
        if (this.getShadePattern() != null) {
            this.texture = new TexturePaint(this.getShadePattern(), this.getPatternRect());
        }
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean drawAboveCounters() {
        return this.drawOver;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, ALWAYS_ON, STARTS_ON, BUTTON_TEXT, TOOLTIP, ICON, HOT_KEY, BOARDS, BOARD_LIST, TYPE, DRAW_OVER, PATTERN, COLOR, IMAGE, SCALE_IMAGE, OPACITY, BORDER, BORDER_COLOR, BORDER_WIDTH, BORDER_OPACITY};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, Boolean.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, BoardPrompt.class, String[].class, TypePrompt.class, Boolean.class, PatternPrompt.class, Color.class, Image.class, Boolean.class, Integer.class, Boolean.class, Color.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.MapShader.shading_on"), Resources.getString("Editor.MapShader.shading_start"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.MapShader.shade_boards"), Resources.getString("Editor.MapShader.board_list"), Resources.getString("Editor.MapShader.type"), Resources.getString("Editor.MapShader.shade_top"), Resources.getString("Editor.MapShader.pattern"), Resources.getString("Editor.color_label"), Resources.getString("Editor.MapShader.image"), Resources.getString("Editor.MapShader.scale"), Resources.getString("Editor.MapShader.opacity"), Resources.getString("Editor.MapShader.border"), Resources.getString("Editor.MapShader.border_color"), Resources.getString("Editor.MapShader.border_width"), Resources.getString("Editor.MapShader.border_opacity")};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public MapShader() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapShader.this.toggleShading();
            }
        };
        this.launch = new LaunchButton("Shade", TOOLTIP, BUTTON_TEXT, HOT_KEY, ICON, actionListener);
        this.launch.setEnabled(false);
        this.setLaunchButtonVisibility();
        this.setConfigureName("Shading");
        this.reset();
    }

    public void reset() {
        this.shadingVisible = this.isAlwaysOn() || this.isStartsOn();
    }

    protected void toggleShading() {
        this.setShadingVisibility(!this.shadingVisible);
    }

    public void setShadingVisibility(boolean bl) {
        this.shadingVisible = bl;
        this.map.repaint();
    }

    protected boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    protected boolean isStartsOn() {
        return this.startsOn;
    }

    protected Map getMap() {
        return this.map;
    }

    public Area getBoardClip() {
        this.buildBoardClip();
        return this.boardClip;
    }

    protected void buildBoardClip() {
        if (this.boardClip == null) {
            this.boardClip = new Area();
            for (Board board : this.map.getBoards()) {
                int n;
                String string = board.getName();
                boolean bl = false;
                if (this.boardSelection.equals(ALL_BOARDS)) {
                    bl = true;
                } else if (this.boardSelection.equals(EXC_BOARDS)) {
                    bl = true;
                    for (n = 0; n < this.boardList.length && bl; ++n) {
                        bl = !this.boardList[n].equals(string);
                    }
                } else if (this.boardSelection.equals(INC_BOARDS)) {
                    for (n = 0; n < this.boardList.length && !bl; ++n) {
                        bl = this.boardList[n].equals(string);
                    }
                }
                if (!bl) continue;
                this.boardClip.add(new Area(board.bounds()));
            }
        }
    }

    public void setLaunchButtonVisibility() {
        this.launch.setVisible(!this.isAlwaysOn());
    }

    @Override
    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
        if (!bl) {
            this.boardClip = null;
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, object);
            }
        } else if (ALWAYS_ON.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.alwaysOn = (Boolean)object;
            this.setLaunchButtonVisibility();
            this.reset();
        } else if (STARTS_ON.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.startsOn = (Boolean)object;
            this.setLaunchButtonVisibility();
            this.reset();
        } else if (BOARDS.equals(string)) {
            this.boardSelection = (String)object;
        } else if (BOARD_LIST.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.boardList = object;
        } else if (TYPE.equals(string)) {
            this.type = (String)object;
        } else if (DRAW_OVER.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.drawOver = (Boolean)object;
        } else if (PATTERN.equals(string)) {
            this.pattern = (String)object;
            this.buildShadePattern();
            this.buildTexture();
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            if (object != null) {
                this.color = (Color)object;
                this.buildShadePattern();
                this.buildTexture();
            }
        } else if (IMAGE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.imageName = (String)object;
            this.buildShadePattern();
            this.textures.clear();
            this.buildTexture();
        } else if (SCALE_IMAGE.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.scaleImage = (Boolean)object;
        } else if (BORDER.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.border = (Boolean)object;
        } else if (BORDER_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.borderColor = (Color)object;
        } else if (BORDER_WIDTH.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.borderWidth = (Integer)object;
            if (this.borderWidth < 0) {
                this.borderWidth = 0;
            }
            this.stroke = null;
        } else if (OPACITY.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.opacity = (Integer)object;
            if (this.opacity < 0 || this.opacity > 100) {
                this.opacity = 100;
            }
            this.buildComposite();
        } else if (BORDER_OPACITY.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.borderOpacity = (Integer)object;
            if (this.borderOpacity < 0 || this.borderOpacity > 100) {
                this.borderOpacity = 100;
            }
            this.buildBorderComposite();
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName() + "";
        }
        if (ALWAYS_ON.equals(string)) {
            return String.valueOf(this.isAlwaysOn());
        }
        if (STARTS_ON.equals(string)) {
            return String.valueOf(this.isStartsOn());
        }
        if (BOARDS.equals(string)) {
            return this.boardSelection + "";
        }
        if (BOARD_LIST.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.boardList);
        }
        if (TYPE.equals(string)) {
            return this.type + "";
        }
        if (DRAW_OVER.equals(string)) {
            return String.valueOf(this.drawOver);
        }
        if (PATTERN.equals(string)) {
            return this.pattern + "";
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (IMAGE.equals(string)) {
            return this.imageName;
        }
        if (SCALE_IMAGE.equals(string)) {
            return String.valueOf(this.scaleImage);
        }
        if (BORDER.equals(string)) {
            return String.valueOf(this.border);
        }
        if (BORDER_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.borderColor);
        }
        if (BORDER_WIDTH.equals(string)) {
            return this.borderWidth + "";
        }
        if (OPACITY.equals(string)) {
            return this.opacity + "";
        }
        if (BORDER_OPACITY.equals(string)) {
            return this.borderOpacity + "";
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (ICON.equals(string) || HOT_KEY.equals(string) || BUTTON_TEXT.equals(string) || STARTS_ON.equals(string) || TOOLTIP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !MapShader.this.isAlwaysOn();
                }
            };
        }
        if (BOARD_LIST.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !MapShader.this.boardSelection.equals(MapShader.ALL_BOARDS);
                }
            };
        }
        if (COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !MapShader.this.pattern.equals(MapShader.TYPE_IMAGE);
                }
            };
        }
        if (IMAGE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return MapShader.this.pattern.equals(MapShader.TYPE_IMAGE);
                }
            };
        }
        if (SCALE_IMAGE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return MapShader.this.pattern.equals(MapShader.TYPE_IMAGE);
                }
            };
        }
        if (BORDER_COLOR.equals(string) || BORDER_WIDTH.equals(string) || BORDER_OPACITY.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return MapShader.this.border;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MapShader.component_type");
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.map.removeDrawComponent(this);
        idMgr.remove(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "MapShading");
    }

    @Override
    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map = (Map)buildable;
        this.map.addDrawComponent(this);
        idMgr.add(this);
        this.validator = idMgr;
        this.setAttributeTranslatable(NAME, false);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public static interface ShadedPiece {
        public Area getArea(MapShader var1);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((MapShader)autoConfigurable).launch.getAttributeValueString(MapShader.ICON));
        }
    }

    public static class BoardPrompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MapShader.ALL_BOARDS, MapShader.EXC_BOARDS, MapShader.INC_BOARDS};
        }
    }

    public static class PatternPrompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MapShader.TYPE_25_PERCENT, MapShader.TYPE_50_PERCENT, MapShader.TYPE_75_PERCENT, MapShader.TYPE_SOLID, MapShader.TYPE_IMAGE};
        }
    }

    public static class TypePrompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{MapShader.FG_TYPE, MapShader.BG_TYPE};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternOp
    extends AbstractTileOpImpl {
        private final Color color;
        private final String pattern;
        private final int hash;

        public PatternOp(Color color, String string) {
            if (color == null || string == null) {
                throw new IllegalArgumentException();
            }
            this.color = color;
            this.pattern = string;
            this.hash = new HashCodeBuilder().append((Object)color).append((Object)string).toHashCode();
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(this.color);
            if (MapShader.TYPE_25_PERCENT.equals(this.pattern)) {
                graphics2D.drawLine(0, 0, 0, 0);
            } else if (MapShader.TYPE_50_PERCENT.equals(this.pattern)) {
                graphics2D.drawLine(0, 0, 0, 0);
                graphics2D.drawLine(1, 1, 1, 1);
            } else if (MapShader.TYPE_75_PERCENT.equals(this.pattern)) {
                graphics2D.drawLine(0, 0, 1, 0);
                graphics2D.drawLine(1, 1, 1, 1);
            } else {
                graphics2D.drawLine(0, 0, 1, 0);
                graphics2D.drawLine(0, 1, 1, 1);
            }
            graphics2D.dispose();
            return bufferedImage;
        }

        @Override
        protected void fixSize() {
        }

        @Override
        public Dimension getSize() {
            return new Dimension(2, 2);
        }

        @Override
        public int getWidth() {
            return 2;
        }

        @Override
        public int getHeight() {
            return 2;
        }

        @Override
        public List<VASSAL.tools.opcache.Op<?>> getSources() {
            return Collections.emptyList();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PatternOp)) {
                return false;
            }
            return this.color.equals(((PatternOp)object).color) && this.pattern.equals(((PatternOp)object).pattern);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

