/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PieceMover
extends AbstractBuildable
implements MouseListener,
GameComponent,
Comparator<GamePiece> {
    public static final String AUTO_REPORT = "autoReport";
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    protected Map map;
    protected Point dragBegin;
    protected GamePiece dragging;
    protected LaunchButton markUnmovedButton;
    protected String markUnmovedText;
    protected String markUnmovedIcon;
    public static final String ICON_NAME = "icon";
    protected String iconName;
    protected PieceFinder dragTargetSelector;
    protected PieceFinder dropTargetSelector;
    protected PieceVisitorDispatcher selectionProcessor;
    protected Comparator<GamePiece> pieceSorter = new PieceSorter();

    @Override
    public void addTo(Buildable buildable) {
        this.dragTargetSelector = this.createDragTargetSelector();
        this.dropTargetSelector = this.createDropTargetSelector();
        this.selectionProcessor = this.createSelectionProcessor();
        this.map = (Map)buildable;
        this.map.addLocalMouseListener(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map.setDragGestureListener(DragHandler.getTheDragHandler());
        this.map.setPieceMover(this);
        this.setAttribute("markUnmovedText", this.map.getAttributeValueString("markUnmovedText"));
        this.setAttribute("markUnmovedIcon", this.map.getAttributeValueString("markUnmovedIcon"));
    }

    protected MovementReporter createMovementReporter(Command command) {
        return new MovementReporter(command);
    }

    protected PieceFinder createDropTargetSelector() {
        return new PieceFinder.Movable(){

            public Object visitDeck(Deck deck) {
                Point point = deck.getPosition();
                Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
                if (deck.getShape().contains(point2)) {
                    return deck;
                }
                return null;
            }

            public Object visitDefault(GamePiece gamePiece) {
                GamePiece gamePiece2 = null;
                if (this.map.getStackMetrics().isStackingEnabled() && this.map.getPieceCollection().canMerge(PieceMover.this.dragging, gamePiece)) {
                    if (this.map.isLocationRestricted(this.pt)) {
                        Point point = this.map.snapTo(this.pt);
                        if (gamePiece.getPosition().equals(point)) {
                            gamePiece2 = gamePiece;
                        }
                    } else {
                        gamePiece2 = (GamePiece)super.visitDefault(gamePiece);
                    }
                }
                if (gamePiece2 != null && DragBuffer.getBuffer().contains(gamePiece2) && gamePiece2.getParent() != null && gamePiece2.getParent().topPiece() == gamePiece2) {
                    gamePiece2 = null;
                }
                return gamePiece2;
            }

            public Object visitStack(Stack stack) {
                GamePiece gamePiece = null;
                if (this.map.getStackMetrics().isStackingEnabled() && this.map.getPieceCollection().canMerge(PieceMover.this.dragging, stack) && !DragBuffer.getBuffer().contains(stack) && stack.topPiece() != null) {
                    if (this.map.isLocationRestricted(this.pt) && !stack.isExpanded()) {
                        if (stack.getPosition().equals(this.map.snapTo(this.pt))) {
                            gamePiece = stack;
                        }
                    } else {
                        gamePiece = (GamePiece)super.visitStack(stack);
                    }
                }
                return gamePiece;
            }
        };
    }

    protected PieceVisitorDispatcher createSelectionProcessor() {
        return new DeckVisitorDispatcher(new DeckVisitor(){

            public Object visitDeck(Deck deck) {
                DragBuffer.getBuffer().clear();
                PieceIterator pieceIterator = deck.drawCards();
                while (pieceIterator.hasMoreElements()) {
                    DragBuffer.getBuffer().add(pieceIterator.nextPiece());
                }
                return null;
            }

            public Object visitStack(Stack stack) {
                GamePiece gamePiece;
                int n;
                DragBuffer.getBuffer().clear();
                int n2 = 0;
                for (n = 0; n < stack.getPieceCount(); ++n) {
                    if (!Boolean.TRUE.equals(stack.getPieceAt(n).getProperty("Selected"))) continue;
                    ++n2;
                }
                if (((Boolean)GameModule.getGameModule().getPrefs().getValue("movingStacksPickupUnits")).booleanValue() || stack.getPieceCount() == 1 || stack.getPieceCount() == n2) {
                    DragBuffer.getBuffer().add(stack);
                } else {
                    for (n = 0; n < stack.getPieceCount(); ++n) {
                        gamePiece = stack.getPieceAt(n);
                        if (!Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) continue;
                        DragBuffer.getBuffer().add(gamePiece);
                    }
                }
                if (KeyBuffer.getBuffer().containsChild(stack)) {
                    KeyBuffer.getBuffer().sort(PieceMover.this);
                    Iterator<GamePiece> iterator = KeyBuffer.getBuffer().getPiecesIterator();
                    while (iterator.hasNext()) {
                        gamePiece = iterator.next();
                        if (gamePiece.getParent() == stack) continue;
                        DragBuffer.getBuffer().add(gamePiece);
                    }
                }
                return null;
            }

            public Object visitDefault(GamePiece gamePiece) {
                DragBuffer.getBuffer().clear();
                if (KeyBuffer.getBuffer().contains(gamePiece)) {
                    KeyBuffer.getBuffer().sort(PieceMover.this);
                    Iterator<GamePiece> iterator = KeyBuffer.getBuffer().getPiecesIterator();
                    while (iterator.hasNext()) {
                        DragBuffer.getBuffer().add(iterator.next());
                    }
                } else {
                    DragBuffer.getBuffer().clear();
                    DragBuffer.getBuffer().add(gamePiece);
                }
                return null;
            }
        });
    }

    protected PieceFinder createDragTargetSelector() {
        return new PieceFinder.Movable(){

            public Object visitDeck(Deck deck) {
                Point point = deck.getPosition();
                Point point2 = new Point(this.pt.x - point.x, this.pt.y - point.y);
                if (deck.boundingBox().contains(point2) && deck.getPieceCount() > 0) {
                    return deck;
                }
                return null;
            }
        };
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            this.initButton();
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    private Image loadIcon(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return Op.load(string).getImage();
    }

    protected void initButton() {
        Object object;
        String string = this.getMarkOption();
        if ("Use Preferences Setting".equals(string)) {
            object = new BooleanConfigurer("markMoved", "Mark Moved Pieces", Boolean.TRUE);
            GameModule.getGameModule().getPrefs().addOption((Configurer)object);
        }
        if (!"Never".equals(string)) {
            if (this.markUnmovedButton == null) {
                object = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GamePiece[] gamePieceArray = PieceMover.this.map.getAllPieces();
                        NullCommand nullCommand = new NullCommand();
                        for (int i = 0; i < gamePieceArray.length; ++i) {
                            nullCommand.append(PieceMover.this.markMoved(gamePieceArray[i], false));
                        }
                        GameModule.getGameModule().sendAndLog(nullCommand);
                        PieceMover.this.map.repaint();
                    }
                };
                this.markUnmovedButton = new LaunchButton("", NAME, HOTKEY, "markUnmovedIcon", (ActionListener)object);
                Image image = null;
                if (this.iconName != null && this.iconName.length() > 0 && (image = this.loadIcon(this.iconName)) != null) {
                    this.markUnmovedButton.setAttribute("markUnmovedIcon", this.iconName);
                }
                if (image == null && (image = this.loadIcon(this.markUnmovedIcon)) != null) {
                    this.markUnmovedButton.setAttribute("markUnmovedIcon", this.markUnmovedIcon);
                }
                this.markUnmovedButton.setAlignmentY(0.0f);
                this.markUnmovedButton.setText(this.markUnmovedText);
                this.markUnmovedButton.setToolTipText(this.map.getAttributeValueString("markUnmovedTooltip"));
                this.map.getToolBar().add(this.markUnmovedButton);
            }
        } else if (this.markUnmovedButton != null) {
            this.map.getToolBar().remove(this.markUnmovedButton);
            this.markUnmovedButton = null;
        }
    }

    private String getMarkOption() {
        String string = this.map.getAttributeValueString("markMoved");
        if (string == null) {
            string = GlobalOptions.getInstance().getAttributeValueString("markMoved");
        }
        return string;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ICON_NAME};
    }

    @Override
    public String getAttributeValueString(String string) {
        return ICON_NAME.equals(string) ? this.iconName : null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (ICON_NAME.equals(string)) {
            this.iconName = (String)object;
        } else if ("markUnmovedText".equals(string)) {
            if (this.markUnmovedButton != null) {
                this.markUnmovedButton.setAttribute(NAME, object);
            }
            this.markUnmovedText = (String)object;
        } else if ("markUnmovedIcon".equals(string)) {
            if (this.markUnmovedButton != null) {
                this.markUnmovedButton.setAttribute("markUnmovedIcon", object);
            }
            this.markUnmovedIcon = (String)object;
        }
    }

    protected boolean isMultipleSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    protected Command movedPiece(GamePiece gamePiece, Point point) {
        this.setOldLocation(gamePiece);
        Command command = null;
        if (!point.equals(gamePiece.getPosition())) {
            command = this.markMoved(gamePiece, true);
        }
        if (gamePiece.getParent() != null) {
            Command command2 = gamePiece.getParent().pieceRemoved(gamePiece);
            command = command == null ? command2 : command.append(command2);
        }
        return command;
    }

    protected void setOldLocation(GamePiece gamePiece) {
        if (gamePiece instanceof Stack) {
            for (int i = 0; i < ((Stack)gamePiece).getPieceCount(); ++i) {
                Decorator.setOldProperties(((Stack)gamePiece).getPieceAt(i));
            }
        } else {
            Decorator.setOldProperties(gamePiece);
        }
    }

    public Command markMoved(GamePiece gamePiece, boolean bl) {
        if ("Never".equals(this.getMarkOption())) {
            bl = false;
        }
        Command command = new NullCommand();
        if (!bl || this.shouldMarkMoved()) {
            if (gamePiece instanceof Stack) {
                Iterator<GamePiece> iterator = ((Stack)gamePiece).getPiecesIterator();
                while (iterator.hasNext()) {
                    command.append(this.markMoved(iterator.next(), bl));
                }
            } else if (gamePiece.getProperty("Moved") != null && gamePiece.getId() != null) {
                ChangeTracker changeTracker = new ChangeTracker(gamePiece);
                gamePiece.setProperty("Moved", bl ? Boolean.TRUE : Boolean.FALSE);
                command = changeTracker.getChangeCommand();
            }
        }
        return command;
    }

    protected boolean shouldMarkMoved() {
        String string = this.getMarkOption();
        if ("Always".equals(string)) {
            return true;
        }
        if ("Never".equals(string)) {
            return false;
        }
        return Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue("markMoved"));
    }

    public Command movePieces(Map map, Point point) {
        Object object;
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
        PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
        if (!pieceIterator.hasMoreElements()) {
            return null;
        }
        Point point2 = null;
        Command command = new NullCommand();
        BoundsTracker boundsTracker = new BoundsTracker();
        HashMap hashMap = new HashMap();
        while (pieceIterator.hasMoreElements()) {
            GamePiece gamePiece3;
            int n;
            this.dragging = pieceIterator.nextPiece();
            boundsTracker.addPiece(this.dragging);
            object = new ArrayList(0);
            if (this.dragging instanceof Stack) {
                int n2 = ((Stack)this.dragging).getPieceCount();
                for (int i = 0; i < n2; ++i) {
                    ((ArrayList)object).add(((Stack)this.dragging).getPieceAt(i));
                }
            } else {
                ((ArrayList)object).add(this.dragging);
            }
            if (point2 != null) {
                point = new Point(this.dragging.getPosition().x + point2.x, this.dragging.getPosition().y + point2.y);
            }
            ArrayList<GamePiece> arrayList2 = (ArrayList<GamePiece>)hashMap.get(point);
            GamePiece gamePiece2 = null;
            if (arrayList2 != null) {
                int n3 = arrayList2.size();
                for (n = 0; n < n3; ++n) {
                    gamePiece3 = (GamePiece)arrayList2.get(n);
                    if (!map.getPieceCollection().canMerge(gamePiece3, this.dragging)) continue;
                    gamePiece2 = gamePiece3;
                    arrayList2.set(n, this.dragging);
                    break;
                }
            }
            if (gamePiece2 == null) {
                gamePiece2 = map.findAnyPiece(point, this.dropTargetSelector);
                if (gamePiece2 == null && !Boolean.TRUE.equals(this.dragging.getProperty("IgnoreGrid"))) {
                    point = map.snapTo(point);
                }
                if (point2 == null) {
                    point2 = new Point(point.x - this.dragging.getPosition().x, point.y - this.dragging.getPosition().y);
                }
                if (gamePiece2 != null && map.getStackMetrics().isStackingEnabled()) {
                    arrayList2 = new ArrayList<GamePiece>();
                    arrayList2.add(this.dragging);
                    arrayList2.add(gamePiece2);
                    hashMap.put(point, arrayList2);
                }
            }
            if (gamePiece2 == null) {
                Stack stack;
                command = command.append(this.movedPiece(this.dragging, point));
                command = command.append(map.placeAt(this.dragging, point));
                if (!(this.dragging instanceof Stack) && !Boolean.TRUE.equals(this.dragging.getProperty("NoStack")) && (stack = map.getStackMetrics().createStack(this.dragging)) != null) {
                    command = command.append(map.placeAt(stack, point));
                }
            } else {
                if (gamePiece2 instanceof Deck) {
                    ArrayList<GamePiece> arrayList3 = new ArrayList<GamePiece>(0);
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        boolean bl;
                        gamePiece3 = (GamePiece)iterator.next();
                        if (!((Deck)gamePiece2).mayContain(gamePiece3) || (bl = Boolean.TRUE.equals(gamePiece3.getProperty("Obscured"))) && (!bl || !"nobody".equals(gamePiece3.getProperty("obs;")))) continue;
                        arrayList3.add(gamePiece3);
                    }
                    if (arrayList3.size() != ((ArrayList)object).size()) {
                        ((ArrayList)object).clear();
                        for (GamePiece gamePiece3 : arrayList3) {
                            ((ArrayList)object).add(gamePiece3);
                        }
                    }
                }
                if (gamePiece2 instanceof Stack) {
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        command = command.append(this.movedPiece((GamePiece)((ArrayList)object).get(n), gamePiece2.getPosition()));
                        command = command.append(map.getStackMetrics().merge(gamePiece2, (GamePiece)((ArrayList)object).get(n)));
                    }
                } else {
                    for (n = ((ArrayList)object).size() - 1; n >= 0; --n) {
                        command = command.append(this.movedPiece((GamePiece)((ArrayList)object).get(n), gamePiece2.getPosition()));
                        command = command.append(map.getStackMetrics().merge(gamePiece2, (GamePiece)((ArrayList)object).get(n)));
                    }
                }
            }
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                GamePiece gamePiece4 = (GamePiece)iterator.next();
                KeyBuffer.getBuffer().add(gamePiece4);
            }
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                GamePiece gamePiece5 = (GamePiece)iterator.next();
                arrayList.add(gamePiece5);
            }
            boundsTracker.addPiece(this.dragging);
        }
        if (GlobalOptions.getInstance().autoReportEnabled()) {
            object = this.createMovementReporter(command).getReportCommand().append(new MovementReporter.HiddenMovementReporter(command).getReportCommand());
            ((Command)object).execute();
            command = command.append((Command)object);
        }
        if (map.getMoveKey() != null) {
            this.applyKeyAfterMove(arrayList, command, map.getMoveKey());
        }
        boundsTracker.repaint();
        return command;
    }

    protected void applyKeyAfterMove(List<GamePiece> list, Command command, KeyStroke keyStroke) {
        for (GamePiece gamePiece : list) {
            if (gamePiece.getProperty("snapshot") == null) {
                gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
            }
            command.append(gamePiece.keyEvent(keyStroke));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.canHandleEvent(mouseEvent)) {
            this.selectMovablePieces(mouseEvent);
        }
    }

    protected void selectMovablePieces(MouseEvent mouseEvent) {
        GamePiece gamePiece = this.map.findPiece(mouseEvent.getPoint(), this.dragTargetSelector);
        this.dragBegin = mouseEvent.getPoint();
        if (gamePiece != null) {
            EventFilter eventFilter = (EventFilter)gamePiece.getProperty("moveEventFilter");
            if (eventFilter == null || !eventFilter.rejectEvent(mouseEvent)) {
                this.selectionProcessor.accept(gamePiece);
            } else {
                DragBuffer.getBuffer().clear();
            }
        } else {
            DragBuffer.getBuffer().clear();
        }
        this.map.repaint();
    }

    @Deprecated
    protected void selectMovablePieces(Point point) {
        GamePiece gamePiece = this.map.findPiece(point, this.dragTargetSelector);
        this.dragBegin = point;
        this.selectionProcessor.accept(gamePiece);
        this.map.repaint();
    }

    protected boolean canHandleEvent(MouseEvent mouseEvent) {
        return !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isMetaDown() && mouseEvent.getClickCount() < 2 && !mouseEvent.isConsumed();
    }

    public boolean isClick(Point point) {
        boolean bl = false;
        if (this.dragBegin != null) {
            boolean bl2;
            Board board = this.map.findBoard(point);
            boolean bl3 = bl2 = board != null && board.getGrid() != null;
            if (bl2) {
                PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
                GamePiece gamePiece = pieceIterator.hasMoreElements() ? pieceIterator.nextPiece() : null;
                boolean bl4 = bl2 = gamePiece != null && !Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid")) && (gamePiece.getParent() == null || !gamePiece.getParent().isExpanded());
            }
            if (bl2) {
                if (this.map.equals(DragBuffer.getBuffer().getFromMap()) && this.map.snapTo(point).equals(this.map.snapTo(this.dragBegin))) {
                    bl = true;
                }
            } else if (Math.abs(point.x - this.dragBegin.x) <= 5 && Math.abs(point.y - this.dragBegin.y) <= 5) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.canHandleEvent(mouseEvent) && !this.isClick(mouseEvent.getPoint())) {
            this.performDrop(mouseEvent.getPoint());
        }
        this.dragBegin = null;
        this.map.getView().setCursor(null);
    }

    protected void performDrop(Point point) {
        Command command = this.movePieces(this.map, point);
        GameModule.getGameModule().sendAndLog(command);
        if (command != null) {
            DragBuffer.getBuffer().clear();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public int compare(GamePiece gamePiece, GamePiece gamePiece2) {
        return this.pieceSorter.compare(gamePiece, gamePiece2);
    }

    static {
        try {
            Class.forName(MovementReporter.class.getName());
            Class.forName(KeyBuffer.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    public static class DragHandlerMacOSX
    extends DragHandler {
        protected int getOffsetMult() {
            return 1;
        }
    }

    public static class DragHandler
    extends AbstractDragHandler {
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.dragGestureRecognizedPrep(dragGestureEvent) == null) {
                return;
            }
            super.dragGestureRecognized(dragGestureEvent);
        }

        protected int getOffsetMult() {
            return -1;
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    public static class DragHandlerNoImage
    extends AbstractDragHandler {
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = this.dragGestureRecognizedPrep(dragGestureEvent);
            if (point == null) {
                return;
            }
            this.makeDragCursor(this.dragPieceOffCenterZoom);
            this.setDrawWinToOwnerOf(this.dragWin);
            SwingUtilities.convertPointToScreen(point, this.drawWin);
            this.moveDragCursor(point.x, point.y);
            super.dragGestureRecognized(dragGestureEvent);
        }

        protected int getOffsetMult() {
            return 1;
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.removeDragCursor();
            super.dragDropEnd(dragSourceDropEvent);
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            if (!dragSourceDragEvent.getLocation().equals(this.lastDragLocation)) {
                this.lastDragLocation = dragSourceDragEvent.getLocation();
                this.moveDragCursor(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
                if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                    this.dragCursor.setVisible(true);
                }
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
            if (component != this.dropWin) {
                double d;
                double d2 = d = component instanceof Map.View ? ((Map.View)component).getMap().getZoom() : 1.0;
                if (Math.abs(d - this.dragCursorZoom) > 0.01) {
                    this.makeDragCursor(d);
                }
                this.setDrawWinToOwnerOf(dropTargetDragEvent.getDropTargetContext().getComponent());
                this.dropWin = component;
            }
            super.dragEnter(dropTargetDragEvent);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.removeDragCursor();
            super.drop(dropTargetDropEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractDragHandler
    implements DragGestureListener,
    DragSourceListener,
    DragSourceMotionListener,
    DropTargetListener {
        private static AbstractDragHandler theDragHandler = DragSource.isDragImageSupported() ? (SystemUtils.IS_OS_MAC_OSX ? new DragHandlerMacOSX() : new DragHandler()) : new DragHandlerNoImage();
        static final int CURSOR_ALPHA = 127;
        static final int EXTRA_BORDER = 4;
        protected JLabel dragCursor;
        private Point drawOffset = new Point();
        private Rectangle boundingBox;
        private int originalPieceOffsetX;
        private int originalPieceOffsetY;
        protected double dragPieceOffCenterZoom = 1.0;
        private int currentPieceOffsetX;
        private int currentPieceOffsetY;
        protected double dragCursorZoom = 1.0;
        Component dragWin;
        Component dropWin;
        JLayeredPane drawWin;
        java.util.Map<Component, DropTargetListener> dropTargetListeners = new HashMap<Component, DropTargetListener>();
        protected Point lastDragLocation = new Point();

        public static AbstractDragHandler getTheDragHandler() {
            return theDragHandler;
        }

        public static void setTheDragHandler(AbstractDragHandler abstractDragHandler) {
            theDragHandler = abstractDragHandler;
        }

        protected abstract int getOffsetMult();

        public static DropTarget makeDropTarget(Component component, int n, DropTargetListener dropTargetListener) {
            if (dropTargetListener != null) {
                DragHandler.getTheDragHandler().dropTargetListeners.put(component, dropTargetListener);
            }
            return new DropTarget(component, n, DragHandler.getTheDragHandler());
        }

        public static void removeDropTarget(Component component) {
            DragHandler.getTheDragHandler().dropTargetListeners.remove(component);
        }

        protected DropTargetListener getListener(DropTargetEvent dropTargetEvent) {
            Component component = dropTargetEvent.getDropTargetContext().getComponent();
            return this.dropTargetListeners.get(component);
        }

        protected void moveDragCursor(int n, int n2) {
            if (this.drawWin != null) {
                this.dragCursor.setLocation(n - this.drawOffset.x, n2 - this.drawOffset.y);
            }
        }

        protected void removeDragCursor() {
            if (this.drawWin != null) {
                if (this.dragCursor != null) {
                    this.dragCursor.setVisible(false);
                    this.drawWin.remove(this.dragCursor);
                }
                this.drawWin = null;
            }
        }

        private void calcDrawOffset() {
            if (this.drawWin != null) {
                this.drawOffset.x = -this.boundingBox.x - this.currentPieceOffsetX + 4;
                this.drawOffset.y = -this.boundingBox.y - this.currentPieceOffsetY + 4;
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
            }
        }

        private void setDrawWin(JLayeredPane jLayeredPane) {
            if (jLayeredPane != this.drawWin) {
                if (this.dragCursor.getParent() != null) {
                    this.dragCursor.getParent().remove(this.dragCursor);
                }
                if (this.drawWin != null) {
                    this.drawWin.repaint(this.dragCursor.getBounds());
                }
                this.drawWin = jLayeredPane;
                this.calcDrawOffset();
                this.dragCursor.setVisible(false);
                this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
            }
        }

        public void setDrawWinToOwnerOf(Component component) {
            JRootPane jRootPane;
            if (component != null && (jRootPane = SwingUtilities.getRootPane(component)) != null) {
                this.setDrawWin(jRootPane.getLayeredPane());
            }
        }

        BufferedImage makeDragImageCursorCommon(double d, boolean bl, Component component, boolean bl2) {
            this.dragCursorZoom = d;
            List<Point> list = this.buildBoundingBox(d, bl);
            int n = this.boundingBox.width + 8;
            int n2 = this.boundingBox.height + 8;
            BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(n, n2);
            this.drawDragImage(bufferedImage, component, list, d);
            if (bl2) {
                this.dragCursor.setSize(n, n2);
            }
            bufferedImage = this.featherDragImage(bufferedImage, n, n2, 4);
            return bufferedImage;
        }

        private BufferedImage makeDragImage(double d) {
            return this.makeDragImageCursorCommon(d, false, null, false);
        }

        protected void makeDragCursor(double d) {
            if (this.dragCursor == null) {
                this.dragCursor = new JLabel();
                this.dragCursor.setVisible(false);
            }
            this.dragCursor.setIcon(new ImageIcon(this.makeDragImageCursorCommon(d, true, this.dragCursor, true)));
        }

        private List<Point> buildBoundingBox(double d, boolean bl) {
            GamePiece gamePiece;
            ArrayList<Point> arrayList = new ArrayList<Point>();
            PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
            GamePiece gamePiece2 = gamePiece = pieceIterator.nextPiece();
            this.currentPieceOffsetX = (int)((double)this.originalPieceOffsetX / this.dragPieceOffCenterZoom * d + 0.5);
            this.currentPieceOffsetY = (int)((double)this.originalPieceOffsetY / this.dragPieceOffCenterZoom * d + 0.5);
            this.boundingBox = gamePiece.getShape().getBounds();
            this.boundingBox.width = (int)((double)this.boundingBox.width * d);
            this.boundingBox.height = (int)((double)this.boundingBox.height * d);
            this.boundingBox.x = (int)((double)this.boundingBox.x * d);
            this.boundingBox.y = (int)((double)this.boundingBox.y * d);
            if (bl) {
                this.calcDrawOffset();
            }
            arrayList.add(new Point(0, 0));
            int n = 0;
            while (pieceIterator.hasMoreElements()) {
                GamePiece gamePiece3 = pieceIterator.nextPiece();
                Rectangle rectangle = gamePiece3.getShape().getBounds();
                rectangle.width = (int)((double)rectangle.width * d);
                rectangle.height = (int)((double)rectangle.height * d);
                rectangle.x = (int)((double)rectangle.x * d);
                rectangle.y = (int)((double)rectangle.y * d);
                Point point = new Point((int)Math.round(d * (double)(gamePiece3.getPosition().x - gamePiece.getPosition().x)), (int)Math.round(d * (double)(gamePiece3.getPosition().y - gamePiece.getPosition().y)));
                rectangle.translate(point.x, point.y);
                if (gamePiece3.getPosition().equals(gamePiece2.getPosition())) {
                    StackMetrics stackMetrics = this.getStackMetrics(gamePiece3);
                    rectangle.translate(stackMetrics.unexSepX * ++n, -stackMetrics.unexSepY * n);
                }
                this.boundingBox.add(rectangle);
                arrayList.add(point);
                gamePiece2 = gamePiece3;
            }
            return arrayList;
        }

        private void drawDragImage(BufferedImage bufferedImage, Component component, List<Point> list, double d) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n = 0;
            Point point = null;
            int n2 = 0;
            PieceIterator pieceIterator = DragBuffer.getBuffer().getIterator();
            while (pieceIterator.hasMoreElements()) {
                GamePiece gamePiece = pieceIterator.nextPiece();
                Point point2 = list.get(n++);
                Map map = gamePiece.getMap();
                if (gamePiece instanceof Stack) {
                    n2 = 0;
                    gamePiece.draw(graphics2D, 4 - this.boundingBox.x + point2.x, 4 - this.boundingBox.y + point2.y, map == null ? component : map.getView(), d);
                } else {
                    Point point3 = new Point(0, 0);
                    if (point2.equals(point)) {
                        StackMetrics stackMetrics = this.getStackMetrics(gamePiece);
                        point3.x = stackMetrics.unexSepX * ++n2;
                        point3.y = stackMetrics.unexSepY * n2;
                    } else {
                        n2 = 0;
                    }
                    int n3 = 4 - this.boundingBox.x + point2.x + point3.x;
                    int n4 = 4 - this.boundingBox.y + point2.y - point3.y;
                    gamePiece.draw(graphics2D, n3, n4, map == null ? component : map.getView(), d);
                    Highlighter highlighter = map == null ? BasicPiece.getHighlighter() : map.getHighlighter();
                    highlighter.draw(gamePiece, graphics2D, n3, n4, null, d);
                }
                point = point2;
            }
            graphics2D.dispose();
        }

        private StackMetrics getStackMetrics(GamePiece gamePiece) {
            StackMetrics stackMetrics = null;
            Map map = gamePiece.getMap();
            if (map != null) {
                stackMetrics = map.getStackMetrics();
            }
            if (stackMetrics == null) {
                stackMetrics = new StackMetrics();
            }
            return stackMetrics;
        }

        private BufferedImage featherDragImage(BufferedImage bufferedImage, int n, int n2, int n3) {
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleTranslucentImage(n, n2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(255, 255, 255, 127));
            graphics2D.fillRect(0, 0, n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = 127 * (i + 1) / n3;
                graphics2D.setColor(new Color(255, 255, 255, n4));
                graphics2D.drawRect(i, i, n - 2 * i, n2 - 2 * i);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(5));
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            try {
                this.beginDragging(dragGestureEvent);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                // empty catch block
            }
        }

        protected Point dragGestureRecognizedPrep(DragGestureEvent dragGestureEvent) {
            Point point;
            GamePiece gamePiece2;
            DragBuffer dragBuffer = DragBuffer.getBuffer();
            if (dragBuffer.isEmpty()) {
                return null;
            }
            ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>();
            Object object = dragBuffer.getIterator();
            while (((PieceIterator)object).hasMoreElements()) {
                arrayList.add(((PieceIterator)object).nextPiece());
            }
            for (GamePiece gamePiece2 : arrayList) {
                if (gamePiece2.getMap() == null || !Boolean.TRUE.equals(gamePiece2.getProperty("cannotMove"))) continue;
                dragBuffer.remove(gamePiece2);
            }
            if (dragBuffer.isEmpty()) {
                return null;
            }
            object = dragBuffer.getIterator().nextPiece();
            gamePiece2 = dragGestureEvent.getComponent() instanceof Map.View ? ((Map.View)dragGestureEvent.getComponent()).getMap() : null;
            Point point2 = gamePiece2 == null ? dragGestureEvent.getDragOrigin() : ((Map)((Object)gamePiece2)).componentCoordinates(dragGestureEvent.getDragOrigin());
            Point point3 = point = gamePiece2 == null ? object.getPosition() : ((Map)((Object)gamePiece2)).componentCoordinates(object.getPosition());
            if (point.x <= 0 || point.y <= 0) {
                point = point2;
            }
            double d = this.dragPieceOffCenterZoom = gamePiece2 == null ? 1.0 : ((Map)((Object)gamePiece2)).getZoom();
            if (object.getParent() != null && gamePiece2 != null) {
                Point point4 = object.getParent().getStackMetrics().relativePosition(object.getParent(), (GamePiece)object);
                point.translate((int)Math.round((double)point4.x * this.dragPieceOffCenterZoom), (int)Math.round((double)point4.y * this.dragPieceOffCenterZoom));
            }
            this.originalPieceOffsetX = point.x - point2.x;
            this.originalPieceOffsetY = point.y - point2.y;
            this.dragWin = dragGestureEvent.getComponent();
            this.drawWin = null;
            this.dropWin = null;
            return point2;
        }

        protected void beginDragging(DragGestureEvent dragGestureEvent) {
            BufferedImage bufferedImage = this.makeDragImage(this.dragPieceOffCenterZoom);
            Point point = new Point(this.getOffsetMult() * (this.boundingBox.x + this.currentPieceOffsetX - 4), this.getOffsetMult() * (this.boundingBox.y + this.currentPieceOffsetY - 4));
            dragGestureEvent.startDrag(Cursor.getPredefinedCursor(12), bufferedImage, point, new StringSelection(""), this);
            dragGestureEvent.getDragSource().addDragSourceMotionListener(this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSource dragSource = dragSourceDropEvent.getDragSourceContext().getDragSource();
            dragSource.removeDragSourceMotionListener(this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public abstract void dragMouseMoved(DragSourceDragEvent var1);

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetDragEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dragEnter(dropTargetDragEvent);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.getLocation().translate(this.currentPieceOffsetX, this.currentPieceOffsetY);
            DropTargetListener dropTargetListener = this.getListener(dropTargetDropEvent);
            if (dropTargetListener != null) {
                dropTargetListener.drop(dropTargetDropEvent);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dragExit(dropTargetEvent);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetDragEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dragOver(dropTargetDragEvent);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            DropTargetListener dropTargetListener = this.getListener(dropTargetDragEvent);
            if (dropTargetListener != null) {
                dropTargetListener.dropActionChanged(dropTargetDragEvent);
            }
        }
    }
}

