/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Resources;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaveMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(SaveMetaData.class);
    public static final String ZIP_ENTRY_NAME = "savedata";
    public static final String DATA_VERSION = "1";
    public static final String PROMPT_LOG_COMMENT = "promptLogComment";
    protected ModuleMetaData moduleData;

    public SaveMetaData() {
        String string = "";
        if (((Boolean)GameModule.getGameModule().getPrefs().getValue(PROMPT_LOG_COMMENT)).booleanValue()) {
            string = (String)JOptionPane.showInputDialog(GameModule.getGameModule().getFrame(), Resources.getString("BasicLogger.enter_comments"), Resources.getString("BasicLogger.log_file_comments"), -1, null, null, "");
            this.setDescription(new AbstractMetaData.Attribute("description", string));
        }
    }

    public SaveMetaData(ZipFile zipFile) {
        this.read(zipFile);
    }

    public String getModuleName() {
        return this.moduleData == null ? "" : this.moduleData.getName();
    }

    public String getModuleVersion() {
        return this.moduleData == null ? "" : this.moduleData.getVersion();
    }

    public ModuleMetaData getModuleData() {
        return this.moduleData;
    }

    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    public void save(FileArchive fileArchive) throws IOException {
        super.save(fileArchive);
        this.copyModuleMetadata(fileArchive);
    }

    protected void addElements(Document document, Element element) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zipFile) {
        try {
            ZipEntry zipEntry = zipFile.getEntry(this.getZipEntryName());
            if (zipEntry == null) {
                return;
            }
            AbstractMetaData.XMLHandler xMLHandler = new AbstractMetaData.XMLHandler(this);
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                XMLReader xMLReader = parser;
                synchronized (xMLReader) {
                    parser.setContentHandler(xMLHandler);
                    parser.setDTDHandler(xMLHandler);
                    parser.setEntityResolver(xMLHandler);
                    parser.setErrorHandler(xMLHandler);
                    parser.parse(new InputSource(bufferedInputStream));
                }
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
            this.moduleData = new ModuleMetaData(zipFile);
            zipFile.close();
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            logger.error("", (Throwable)sAXException);
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
    }
}

