/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.swing.Dialogs;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class ServerAddressBook {
    public static final String CURRENT_SERVER = "currentServer";
    protected static final String ADDRESS_PREF = "ServerAddressBook";
    protected static final String LEGACY_TYPE = "node";
    protected static final String DYNAMIC_TYPE = "dynamic";
    protected static final String JABBER_TYPE = "jabber";
    protected static final String P2P_TYPE = "peer2peer";
    protected static final String P2P_MODE_KEY = "mode";
    protected static final String P2P_SERVER_MODE = "server";
    protected static final String P2P_CLIENT_MODE = "client";
    protected static final String TYPE_KEY = "type";
    protected static final String DESCRIPTION_KEY = "description";
    protected final int LEAF_ICON_SIZE = 1;
    protected final int CONTROLS_ICON_SIZE = 0;
    private boolean frozen;
    private JComponent controls;
    private StringConfigurer addressConfig;
    private JList myList;
    private DefaultListModel addressBook;
    private AddressBookEntry currentEntry;
    private boolean enabled = true;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static ServerAddressBook instance;
    private static String localIPAddress;
    private static String externalIPAddress;
    private JButton addButton;
    private JButton removeButton;
    private JButton editButton;
    private JButton setButton;

    public static ServerAddressBook getInstance() {
        return instance;
    }

    public static void editCurrentServer(boolean bl) {
        instance.editCurrent(bl);
    }

    public static void changeServerPopup(JComponent jComponent) {
        instance.showPopup(jComponent);
    }

    public static String getLocalAddress() {
        if (localIPAddress == null) {
            try {
                localIPAddress = ServerAddressBook.getLocalHostLANAddress().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                localIPAddress = "?";
            }
        }
        return localIPAddress;
    }

    public static String getExternalAddress() {
        return ServerAddressBook.getExternalAddress("?");
    }

    public static String getExternalAddress(String string) {
        if (externalIPAddress == null) {
            externalIPAddress = string;
            try {
                externalIPAddress = ServerAddressBook.discoverMyIpAddressFromRemote();
            }
            catch (IOException iOException) {
                externalIPAddress = "?";
            }
        }
        return externalIPAddress;
    }

    private static String discoverMyIpAddressFromRemote() throws IOException {
        String string = null;
        HttpRequestWrapper httpRequestWrapper = new HttpRequestWrapper("http://www.vassalengine.org/util/getMyAddress");
        List<String> list = httpRequestWrapper.doGet(null);
        if (list.isEmpty()) {
            throw new IOException(Resources.getString("Server.empty_response"));
        }
        string = list.get(0);
        return string;
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress inetAddress = null;
            Object object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                NetworkInterface networkInterface = object.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration.nextElement();
                    if (inetAddress2.isLoopbackAddress()) continue;
                    if (inetAddress2.isSiteLocalAddress()) {
                        return inetAddress2;
                    }
                    if (inetAddress != null) continue;
                    inetAddress = inetAddress2;
                }
            }
            if (inetAddress != null) {
                return inetAddress;
            }
            object = InetAddress.getLocalHost();
            if (object == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return object;
        }
        catch (Exception exception) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + exception);
            unknownHostException.initCause(exception);
            throw unknownHostException;
        }
    }

    public ServerAddressBook() {
        instance = this;
    }

    public JComponent getControls() {
        if (this.controls == null) {
            this.controls = new JPanel(new MigLayout());
            this.addressConfig = new StringConfigurer(ADDRESS_PREF, null, "");
            Prefs.getGlobalPrefs().addOption(null, this.addressConfig);
            this.addressBook = new DefaultListModel();
            this.loadAddressBook();
            this.myList = new JList(this.addressBook);
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(new MyRenderer());
            this.myList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ServerAddressBook.this.updateButtonVisibility();
                }
            });
            this.myList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (ServerAddressBook.this.editButton.isEnabled() && mouseEvent.getClickCount() == 2) {
                        int n = ServerAddressBook.this.myList.locationToIndex(mouseEvent.getPoint());
                        ServerAddressBook.this.editServer(n);
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.myList);
            this.myList.repaint();
            this.controls.add((Component)jScrollPane, "grow, push, w 500, h 400, wrap, span 4");
            this.setButton = new JButton(Resources.getString("ServerAddressBook.set_current"));
            this.setButton.setToolTipText(Resources.getString("ServerAddressBook.set_selected_server"));
            this.setButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerAddressBook.this.setCurrentServer(ServerAddressBook.this.myList.getSelectedIndex());
                }
            });
            this.addButton = new JButton(Resources.getString("General.add"));
            this.addButton.setToolTipText(Resources.getString("ServerAddressBook.add_jabber_server"));
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerAddressBook.this.addServer();
                }
            });
            this.removeButton = new JButton(Resources.getString("General.remove"));
            this.removeButton.setToolTipText(Resources.getString("ServerAddressBook.remove_selected_server"));
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerAddressBook.this.removeServer(ServerAddressBook.this.myList.getSelectedIndex());
                }
            });
            this.editButton = new JButton(Resources.getString("General.edit"));
            this.editButton.setToolTipText(Resources.getString("ServerAddressBook.edit_server"));
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerAddressBook.this.editServer(ServerAddressBook.this.myList.getSelectedIndex());
                }
            });
            this.controls.add((Component)this.addButton, "grow, push");
            this.controls.add((Component)this.editButton, "grow, push");
            this.controls.add((Component)this.removeButton, "grow, push");
            this.controls.add((Component)this.setButton, "grow, push");
            this.updateButtonVisibility();
        }
        return this.controls;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.updateButtonVisibility();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    private void updateButtonVisibility() {
        int n = this.myList.getSelectedIndex();
        if (n >= 0) {
            AddressBookEntry addressBookEntry = (AddressBookEntry)this.addressBook.get(n);
            this.editButton.setEnabled(addressBookEntry.isEditable() && (this.isEnabled() || !addressBookEntry.isCurrent()));
            this.removeButton.setEnabled(addressBookEntry.isRemovable() && !addressBookEntry.isCurrent());
            this.setButton.setEnabled(this.isEnabled() && !addressBookEntry.isCurrent());
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.setButton.setEnabled(false);
        }
    }

    public void setCurrentServer(Properties properties) {
        int n = 0;
        String string = properties.getProperty(TYPE_KEY);
        String string2 = properties.getProperty(DYNAMIC_TYPE);
        String string3 = properties.getProperty(P2P_MODE_KEY);
        Object object = this.addressBook.elements();
        while (object.hasMoreElements()) {
            AddressBookEntry addressBookEntry = (AddressBookEntry)object.nextElement();
            Properties properties2 = addressBookEntry.getProperties();
            if (properties2.equals(properties)) {
                this.setCurrentServer(n);
                return;
            }
            if (DYNAMIC_TYPE.equals(string) && DYNAMIC_TYPE.equals(properties2.getProperty(TYPE_KEY)) && properties2.getProperty(DYNAMIC_TYPE).equals(string2)) {
                this.setCurrentServer(n);
                return;
            }
            if (P2P_TYPE.equals(string) && P2P_TYPE.equals(properties2.getProperty(TYPE_KEY)) && properties2.getProperty(P2P_MODE_KEY).equals(string3)) {
                this.setCurrentServer(n);
            }
            ++n;
        }
        object = this.buildEntry(properties);
        if (object != null) {
            this.addressBook.addElement(object);
            this.setCurrentServer(this.addressBook.indexOf(object));
        }
        this.saveAddressBook();
    }

    private void setCurrentServer(AddressBookEntry addressBookEntry) {
        this.setCurrentServer(this.addressBook.indexOf(addressBookEntry));
    }

    private void setCurrentServer(int n) {
        AddressBookEntry addressBookEntry = (AddressBookEntry)this.addressBook.get(n);
        if (this.currentEntry != null) {
            this.currentEntry.setCurrent(false);
        }
        Properties properties = this.currentEntry == null ? null : this.currentEntry.getProperties();
        this.currentEntry = addressBookEntry;
        this.currentEntry.setCurrent(true);
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(CURRENT_SERVER, properties, addressBookEntry.getProperties());
        }
        this.updateButtonVisibility();
        this.myList.repaint();
    }

    protected Properties getCurrentServerProperties() {
        return this.currentEntry.getProperties();
    }

    public void showPopup(JComponent jComponent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Enumeration enumeration = this.addressBook.elements();
        while (enumeration.hasMoreElements()) {
            AddressBookEntry addressBookEntry = (AddressBookEntry)enumeration.nextElement();
            JMenuItem jMenuItem = new JMenuItem(addressBookEntry.toString());
            MenuAction menuAction = new MenuAction(addressBookEntry);
            jMenuItem.setAction(menuAction);
            jMenuItem.setIcon(addressBookEntry.getIcon(1));
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(jComponent, 0, 0);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Icon getCurrentIcon() {
        return this.currentEntry.getIcon(0);
    }

    public String getCurrentDescription() {
        return this.currentEntry.toString();
    }

    private void editCurrent(boolean bl) {
        if (this.currentEntry != null) {
            this.editServer(this.addressBook.indexOf(this.currentEntry), bl);
        }
    }

    private void editServer(int n) {
        this.editServer(n, true);
    }

    private void editServer(int n, boolean bl) {
        AddressBookEntry addressBookEntry = (AddressBookEntry)this.addressBook.get(n);
        boolean bl2 = addressBookEntry.equals(this.currentEntry);
        Properties properties = addressBookEntry.getProperties();
        if (addressBookEntry.edit(bl) && bl2) {
            this.changeSupport.firePropertyChange(CURRENT_SERVER, properties, addressBookEntry.getProperties());
        }
    }

    private void removeServer(int n) {
        AddressBookEntry addressBookEntry = (AddressBookEntry)this.addressBook.get(n);
        int n2 = JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("ServerAddressBook.remove_server", addressBookEntry.getDescription()));
        if (n2 == 0) {
            this.addressBook.remove(n);
            this.myList.setSelectedIndex(-1);
            this.myList.repaint();
            this.updateButtonVisibility();
            this.saveAddressBook();
        }
    }

    private void addServer() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Resources.getString("ServerAddressBook.peer_server"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerAddressBook.this.addEntry(new PeerServerEntry());
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Resources.getString("ServerAddressBook.jabber_server"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerAddressBook.this.addEntry(new JabberEntry());
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.show(this.addButton, 0, 0);
    }

    private void addEntry(AddressBookEntry addressBookEntry) {
        if (addressBookEntry.edit()) {
            this.addressBook.addElement(addressBookEntry);
            this.saveAddressBook();
        }
    }

    public Properties getDefaultServerProperties() {
        return new LegacyEntry().getProperties();
    }

    private void loadAddressBook() {
        this.decodeAddressBook(this.addressConfig.getValueString());
        DefaultListModel<AddressBookEntry> defaultListModel = new DefaultListModel<AddressBookEntry>();
        Enumeration enumeration = this.addressBook.elements();
        while (enumeration.hasMoreElements()) {
            AddressBookEntry addressBookEntry = (AddressBookEntry)enumeration.nextElement();
            if (addressBookEntry instanceof LegacyEntry) {
                defaultListModel.add(0, addressBookEntry);
                continue;
            }
            if (addressBookEntry instanceof PeerClientEntry) continue;
            defaultListModel.addElement(addressBookEntry);
        }
        this.addressBook = defaultListModel;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Object object = this.addressBook.elements();
        while (object.hasMoreElements()) {
            AddressBookEntry addressBookEntry = (AddressBookEntry)object.nextElement();
            if (addressBookEntry instanceof LegacyEntry) {
                bl = true;
                continue;
            }
            if (addressBookEntry instanceof VassalJabberEntry) {
                bl2 = true;
                continue;
            }
            if (!(addressBookEntry instanceof PeerServerEntry)) continue;
            bl3 = true;
        }
        if (!bl2) {
            object = new VassalJabberEntry();
            ((AddressBookEntry)object).setCurrent(true);
            this.currentEntry = object;
            this.addressBook.addElement(object);
            bl4 = true;
        }
        if (!bl) {
            this.addressBook.addElement(new LegacyEntry());
            bl4 = true;
        }
        if (!bl3) {
            this.addressBook.addElement(new PeerServerEntry());
            bl4 = true;
        }
        if (bl4) {
            this.saveAddressBook();
        }
    }

    private void saveAddressBook() {
        this.addressConfig.setValue(this.encodeAddressBook());
        if (this.myList != null) {
            this.myList.repaint();
        }
    }

    private String encodeAddressBook() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        Enumeration enumeration = this.addressBook.elements();
        while (enumeration.hasMoreElements()) {
            AddressBookEntry addressBookEntry = (AddressBookEntry)enumeration.nextElement();
            if (addressBookEntry == null) continue;
            sequenceEncoder.append(addressBookEntry.encode());
        }
        return sequenceEncoder.getValue();
    }

    private void decodeAddressBook(String string) {
        this.addressBook.clear();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        while (decoder.hasMoreTokens()) {
            AddressBookEntry addressBookEntry;
            String string2 = decoder.nextToken("");
            if (string2.length() <= 0 || (addressBookEntry = this.buildEntry(string2)) == null) continue;
            this.addressBook.addElement(this.buildEntry(string2));
        }
    }

    private AddressBookEntry buildEntry(String string) {
        Properties properties = new Properties();
        try {
            properties = new PropertiesEncoder(string).getProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildEntry(properties);
    }

    private AddressBookEntry buildEntry(Properties properties) {
        String string = properties.getProperty(TYPE_KEY);
        if (JABBER_TYPE.equals(string)) {
            return new JabberEntry(properties);
        }
        if (DYNAMIC_TYPE.equals(string)) {
            String string2 = properties.getProperty(DYNAMIC_TYPE);
            if (JABBER_TYPE.equals(string2)) {
                return new VassalJabberEntry(properties);
            }
            if (LEGACY_TYPE.equals(string2)) {
                return new LegacyEntry(properties);
            }
        } else if (P2P_TYPE.equals(string)) {
            String string3 = properties.getProperty(P2P_MODE_KEY);
            if (P2P_SERVER_MODE.equals(string3)) {
                return new PeerServerEntry(properties);
            }
            if (P2P_CLIENT_MODE.equals(string3)) {
                return new PeerClientEntry(properties);
            }
        }
        return null;
    }

    private class MyRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font standardFont;
        private Font highlightFont;

        private MyRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (this.standardFont == null) {
                this.standardFont = this.getFont();
                this.highlightFont = new Font(this.standardFont.getFamily(), 3, this.standardFont.getSize());
            }
            if (object instanceof AddressBookEntry) {
                AddressBookEntry addressBookEntry = (AddressBookEntry)object;
                this.setIcon(addressBookEntry.getIcon(1));
                if (addressBookEntry.isCurrent()) {
                    this.setFont(this.highlightFont);
                    this.setText(addressBookEntry.toString() + Resources.getString("ServerAddressBook.current"));
                } else {
                    this.setFont(this.standardFont);
                }
            }
            return this;
        }
    }

    @Deprecated
    private class PeerClientEntry
    extends AddressBookEntry {
        private JTextField listenPort;
        private JTextField serverName;
        private JTextField serverPort;
        private JTextField serverIp;

        public PeerClientEntry() {
            this.listenPort = new JTextField();
            this.serverName = new JTextField();
            this.serverPort = new JTextField();
            this.serverIp = new JTextField();
            this.setDescription(Resources.getString("ServerAddressBook.peer_client"));
            this.setType(ServerAddressBook.P2P_TYPE);
            this.setProperty(ServerAddressBook.P2P_MODE_KEY, ServerAddressBook.P2P_CLIENT_MODE);
            this.setProperty("listenPort", "5050");
            this.setProperty("serverName", "");
            this.setProperty("serverPort", "5050");
            this.setProperty("serverIp", "");
        }

        public PeerClientEntry(Properties properties) {
            super(properties);
            this.listenPort = new JTextField();
            this.serverName = new JTextField();
            this.serverPort = new JTextField();
            this.serverIp = new JTextField();
        }

        public String toString() {
            String string = this.getProperty("listenPort");
            String string2 = this.getProperty("serverName");
            String string3 = this.getProperty("serverIp");
            String string4 = this.getProperty("serverPort");
            StringBuffer stringBuffer = new StringBuffer(Resources.getString("ServerAddressBook.peer_client"));
            if (string3 == null || string3.length() == 0) {
                stringBuffer.append(" [");
                stringBuffer.append(Resources.getString("ServerAddressBook.listening", string));
                stringBuffer.append("]");
            } else {
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(" - ");
                    stringBuffer.append(string2);
                }
                if (string3 != null && string3.length() > 0) {
                    stringBuffer.append(" [");
                    stringBuffer.append(string3);
                    stringBuffer.append(":");
                    stringBuffer.append(string4);
                    stringBuffer.append("]");
                }
            }
            return stringBuffer.toString();
        }

        public boolean isRemovable() {
            return true;
        }

        protected boolean isDescriptionEditable() {
            return false;
        }

        protected String getIconName() {
            return "network-idle";
        }

        protected void setAdditionalProperties(Properties properties) {
            this.setType(ServerAddressBook.P2P_TYPE);
            this.setProperty(ServerAddressBook.P2P_MODE_KEY, ServerAddressBook.P2P_CLIENT_MODE);
            this.listenPort.setText(properties.getProperty("listenPort"));
            this.serverIp.setText(properties.getProperty("serverIp"));
            this.serverPort.setText(properties.getProperty("serverPort"));
            this.serverName.setText(properties.getProperty("serverName"));
            this.setDescription(this.toString());
        }

        protected void getAdditionalProperties(Properties properties) {
            properties.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.P2P_TYPE);
            properties.setProperty(ServerAddressBook.P2P_MODE_KEY, ServerAddressBook.P2P_CLIENT_MODE);
            properties.setProperty("listenPort", this.listenPort.getText());
            properties.setProperty("serverIp", this.serverIp.getText());
            properties.setProperty("serverPort", this.serverPort.getText());
            properties.setProperty("serverName", this.serverName.getText());
        }

        protected void addAdditionalControls(JComponent jComponent, boolean bl) {
            this.serverName.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.server_name")));
            jComponent.add((Component)this.serverName, "wrap, growx, push");
            this.serverIp.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.server_ip")));
            jComponent.add((Component)this.serverIp, "wrap, growx, push");
            this.serverPort.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.server_port")));
            jComponent.add((Component)this.serverPort, "wrap, growx, push");
            this.listenPort.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.invite_port")));
            jComponent.add((Component)this.listenPort, "wrap, growx, push");
            jComponent.add(new JLabel(Resources.getString("Peer2Peer.internet_address")));
            JTextField jTextField = new JTextField(ServerAddressBook.getExternalAddress());
            jTextField.setEditable(false);
            jComponent.add((Component)jTextField, "wrap, growx, push");
            if (!ServerAddressBook.getLocalAddress().equals(ServerAddressBook.getExternalAddress())) {
                jComponent.add(new JLabel(Resources.getString("Peer2Peer.local_address")));
                JTextField jTextField2 = new JTextField(ServerAddressBook.getLocalAddress());
                jTextField2.setEditable(false);
                jComponent.add((Component)jTextField2, "wrap, growx, push");
            }
        }
    }

    private class PeerServerEntry
    extends AddressBookEntry {
        private JTextField listenPort;
        private JTextField serverPw;

        public PeerServerEntry() {
            this.listenPort = new JTextField();
            this.serverPw = new JTextField();
            this.setDescription(Resources.getString("ServerAddressBook.peer_server"));
            this.setType(ServerAddressBook.P2P_TYPE);
            this.setProperty(ServerAddressBook.P2P_MODE_KEY, ServerAddressBook.P2P_SERVER_MODE);
            this.setProperty("listenPort", "5050");
            this.setProperty("serverPw", "xyzzy");
        }

        public PeerServerEntry(Properties properties) {
            super(properties);
            this.listenPort = new JTextField();
            this.serverPw = new JTextField();
        }

        public String toString() {
            return Resources.getString("ServerAddressBook.peer_server") + " [" + this.getProperty(ServerAddressBook.DESCRIPTION_KEY) + "]";
        }

        public boolean isRemovable() {
            return true;
        }

        protected boolean isDescriptionEditable() {
            return true;
        }

        protected String getIconName() {
            return "network-server";
        }

        protected void setAdditionalProperties(Properties properties) {
            this.setType(ServerAddressBook.P2P_TYPE);
            this.setProperty(ServerAddressBook.P2P_MODE_KEY, ServerAddressBook.P2P_SERVER_MODE);
            this.listenPort.setText(properties.getProperty("listenPort"));
            this.serverPw.setText(properties.getProperty("serverPw"));
        }

        protected void getAdditionalProperties(Properties properties) {
            properties.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.P2P_TYPE);
            properties.setProperty(ServerAddressBook.P2P_MODE_KEY, ServerAddressBook.P2P_SERVER_MODE);
            properties.setProperty("listenPort", this.listenPort.getText());
            properties.setProperty("serverPw", this.serverPw.getText());
        }

        protected void addAdditionalControls(JComponent jComponent, boolean bl) {
            this.listenPort.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.listen_port")));
            jComponent.add((Component)this.listenPort, "wrap, growx, push");
            this.serverPw.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.server_password")));
            jComponent.add((Component)this.serverPw, "wrap, growx, push");
            jComponent.add(new JLabel(Resources.getString("Peer2Peer.internet_address")));
            JTextField jTextField = new JTextField(ServerAddressBook.getExternalAddress());
            jTextField.setEditable(false);
            jComponent.add((Component)jTextField, "wrap, growx, push");
            if (!ServerAddressBook.getLocalAddress().equals(ServerAddressBook.getExternalAddress())) {
                jComponent.add(new JLabel(Resources.getString("Peer2Peer.local_address")));
                JTextField jTextField2 = new JTextField(ServerAddressBook.getLocalAddress());
                jTextField2.setEditable(false);
                jComponent.add((Component)jTextField2, "wrap, growx, push");
            }
        }
    }

    private class LegacyEntry
    extends AddressBookEntry {
        public LegacyEntry() {
            this(new Properties());
            this.setDescription(Resources.getString("ServerAddressBook.legacy_server"));
            this.setType(ServerAddressBook.DYNAMIC_TYPE);
            this.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.LEGACY_TYPE);
            this.setProperty("url", "http://www.vassalengine.org/util/getServerImpl");
        }

        public LegacyEntry(Properties properties) {
            super(properties);
        }

        public String toString() {
            return this.getDescription();
        }

        protected String getIconName() {
            return "VASSAL";
        }

        protected boolean isRemovable() {
            return false;
        }

        protected boolean isEditable() {
            return false;
        }

        protected boolean isDescriptionEditable() {
            return false;
        }

        protected void addAdditionalControls(JComponent jComponent, boolean bl) {
        }

        protected void getAdditionalProperties(Properties properties) {
        }

        protected void setAdditionalProperties(Properties properties) {
        }
    }

    private class VassalJabberEntry
    extends AddressBookEntry {
        protected JTextField jabberUser;
        protected JTextField jabberPw;

        public VassalJabberEntry() {
            this(new Properties());
            this.setDescription("VASSAL" + Resources.getString("ServerAddressBook.jabber_server"));
            this.setType(ServerAddressBook.DYNAMIC_TYPE);
            this.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.JABBER_TYPE);
            this.setProperty("jabberLogin", "");
            this.setProperty("jabberPassword", "");
            this.setProperty("url", "http://www.vassalengine.org/util/getJabberServerImpl");
        }

        public VassalJabberEntry(Properties properties) {
            super(properties);
            this.jabberUser = new JTextField();
            this.jabberPw = new JTextField();
        }

        public String toString() {
            String string = this.getProperty("jabberLogin");
            String string2 = this.getProperty("jabberPassword");
            String string3 = string == null || string.length() == 0 || string2 == null || string2.length() == 0 ? Resources.getString("ServerAddressBook.login_details_required") : this.getProperty("jabberLogin") + "/" + this.getProperty("jabberPassword");
            return this.getDescription() + " [" + string3 + "]";
        }

        protected boolean isRemovable() {
            return false;
        }

        protected boolean isDescriptionEditable() {
            return false;
        }

        protected String getIconName() {
            return "VASSAL-jabber";
        }

        protected void setAdditionalProperties(Properties properties) {
            this.jabberUser.setText(properties.getProperty("jabberLogin"));
            this.jabberPw.setText(properties.getProperty("jabberPassword"));
            this.setType(ServerAddressBook.DYNAMIC_TYPE);
            this.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.JABBER_TYPE);
        }

        protected void getAdditionalProperties(Properties properties) {
            properties.setProperty("jabberLogin", this.jabberUser.getText());
            properties.setProperty("jabberPassword", this.jabberPw.getText());
            properties.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.DYNAMIC_TYPE);
            properties.setProperty(ServerAddressBook.DYNAMIC_TYPE, ServerAddressBook.JABBER_TYPE);
        }

        protected void addAdditionalControls(JComponent jComponent, boolean bl) {
            this.jabberUser.setEditable(bl);
            this.jabberPw.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.user_name")));
            jComponent.add((Component)this.jabberUser, "wrap, grow, push");
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.password")));
            jComponent.add((Component)this.jabberPw, "wrap, grow, push");
        }
    }

    private class JabberEntry
    extends AddressBookEntry {
        private JTextField jabberHost;
        private JTextField jabberPort;
        private JTextField jabberUser;
        private JTextField jabberPw;
        private JButton testButton;

        public JabberEntry() {
            this(new Properties());
            this.setType(ServerAddressBook.JABBER_TYPE);
            this.setDescription("");
            this.setProperty("jabberPort", "5222");
        }

        public JabberEntry(Properties properties) {
            super(properties);
            this.jabberHost = new JTextField();
            this.jabberPort = new JTextField();
            this.jabberUser = new JTextField();
            this.jabberPw = new JTextField();
        }

        public String toString() {
            return Resources.getString("ServerAddressBook.jabber_server") + " " + this.getDescription() + " [" + this.getProperty("jabberHost") + ":" + this.getProperty("jabberPort") + " " + this.getProperty("jabberLogin") + "/" + this.getProperty("jabberPassword") + "]";
        }

        protected String getIconName() {
            return ServerAddressBook.JABBER_TYPE;
        }

        protected boolean isDescriptionEditable() {
            return true;
        }

        protected void setAdditionalProperties(Properties properties) {
            this.jabberHost.setText(properties.getProperty("jabberHost"));
            this.jabberPort.setText(properties.getProperty("jabberPort"));
            this.jabberUser.setText(properties.getProperty("jabberLogin"));
            this.jabberPw.setText(properties.getProperty("jabberPassword"));
        }

        protected void getAdditionalProperties(Properties properties) {
            properties.setProperty("jabberHost", this.jabberHost.getText());
            properties.setProperty("jabberPort", this.jabberPort.getText());
            properties.setProperty("jabberLogin", this.jabberUser.getText());
            properties.setProperty("jabberPassword", this.jabberPw.getText());
            properties.setProperty(ServerAddressBook.TYPE_KEY, ServerAddressBook.JABBER_TYPE);
        }

        protected void addAdditionalControls(JComponent jComponent, boolean bl) {
            this.jabberHost.setEditable(bl);
            this.jabberPort.setEditable(bl);
            this.jabberUser.setEditable(bl);
            this.jabberPw.setEditable(bl);
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.jabber_host")));
            jComponent.add((Component)this.jabberHost, "wrap, grow, push");
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.port")));
            jComponent.add((Component)this.jabberPort, "wrap, grow, push");
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.user_name")));
            jComponent.add((Component)this.jabberUser, "wrap, grow, push");
            jComponent.add(new JLabel(Resources.getString("ServerAddressBook.password")));
            jComponent.add((Component)this.jabberPw, "wrap, grow, push");
            this.testButton = new JButton(Resources.getString("ServerAddressBook.test_connection"));
            this.testButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JabberEntry.this.test();
                }
            });
            jComponent.add((Component)this.testButton, "span 2, align center, wrap");
        }

        protected void test() {
            JTextArea jTextArea = new JTextArea(10, 30);
            jTextArea.setText(JabberClient.testConnection(this.jabberHost.getText(), this.jabberPort.getText(), this.jabberUser.getText(), this.jabberPw.getText()));
            try {
                Dialogs.showDialog(null, Resources.getString("ServerAddressBook.connection_test"), jTextArea, 1, null, 2, null, null, null, null);
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AddressBookEntry
    implements Comparable<AddressBookEntry> {
        protected Properties properties = new Properties();
        protected boolean current;

        protected AddressBookEntry() {
            this(new Properties());
        }

        protected AddressBookEntry(Properties properties) {
            this.properties = properties;
        }

        protected String getDescription() {
            return this.getProperty(ServerAddressBook.DESCRIPTION_KEY);
        }

        protected void setDescription(String string) {
            this.properties.setProperty(ServerAddressBook.DESCRIPTION_KEY, string);
        }

        public String getProperty(String string) {
            return this.properties.getProperty(string);
        }

        public void setProperty(String string, String string2) {
            this.properties.setProperty(string, string2);
        }

        protected boolean isRemovable() {
            return true;
        }

        protected boolean isEditable() {
            return true;
        }

        protected abstract String getIconName();

        protected Icon getIcon(int n) {
            return IconFactory.getIcon(this.getIconName(), n);
        }

        public String getType() {
            return this.properties.getProperty(ServerAddressBook.TYPE_KEY);
        }

        public void setType(String string) {
            this.properties.setProperty(ServerAddressBook.TYPE_KEY, string);
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public String encode() {
            return new PropertiesEncoder(this.properties).getStringValue();
        }

        @Override
        public int compareTo(AddressBookEntry addressBookEntry) {
            if (this.getType().equals(addressBookEntry.getType())) {
                return this.getDescription().compareTo(addressBookEntry.getDescription());
            }
            return this.getType().compareTo(addressBookEntry.getType());
        }

        public boolean isCurrent() {
            return this.current;
        }

        public void setCurrent(boolean bl) {
            this.current = bl;
        }

        protected boolean isDescriptionEditable() {
            return true;
        }

        public boolean edit() {
            return this.edit(true);
        }

        public boolean edit(boolean bl) {
            if (this.isEditable()) {
                ServerConfig serverConfig = this.getEditor(this.getProperties(), bl);
                Integer n = (Integer)Dialogs.showDialog(null, Resources.getString("ServerAddressBook.edit_server_configuration"), serverConfig.getControls(), -1, null, 2, null, null, null, null);
                if (n != null && n == 0) {
                    if (bl) {
                        this.setProperties(serverConfig.getProperties());
                        ServerAddressBook.this.saveAddressBook();
                    }
                    return true;
                }
            }
            return false;
        }

        protected abstract void setAdditionalProperties(Properties var1);

        protected abstract void getAdditionalProperties(Properties var1);

        protected abstract void addAdditionalControls(JComponent var1, boolean var2);

        public ServerConfig getEditor(Properties properties, boolean bl) {
            return new ServerConfig(properties, this, bl);
        }

        class ServerConfig {
            protected JComponent configControls;
            protected JTextField description = new JTextField();
            protected AddressBookEntry entry;
            boolean enabled;

            public ServerConfig() {
            }

            public ServerConfig(Properties properties, AddressBookEntry addressBookEntry2, boolean bl) {
                this();
                this.entry = addressBookEntry2;
                this.enabled = bl;
                this.description.setText(properties.getProperty(ServerAddressBook.DESCRIPTION_KEY));
                addressBookEntry.setAdditionalProperties(properties);
            }

            protected boolean isEnabled() {
                return this.enabled;
            }

            public JComponent getControls() {
                if (this.configControls == null) {
                    this.configControls = new JPanel();
                    this.configControls.setLayout(new MigLayout("", "[align right]rel[]", ""));
                    this.configControls.add((Component)new JLabel(IconFactory.getIcon(this.entry.getIconName(), 3)), "span 2, align center, wrap");
                    this.configControls.add(new JLabel(Resources.getString("Editor.description_label")));
                    this.configControls.add((Component)this.description, "wrap, grow, push");
                    this.entry.addAdditionalControls(this.configControls, this.enabled);
                    this.description.setEditable(AddressBookEntry.this.isDescriptionEditable() && this.isEnabled());
                }
                return this.configControls;
            }

            public Properties getProperties() {
                Properties properties = new Properties();
                properties.setProperty(ServerAddressBook.DESCRIPTION_KEY, this.description.getText());
                AddressBookEntry.this.getAdditionalProperties(properties);
                return properties;
            }
        }
    }

    private class MenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private AddressBookEntry entry;

        public MenuAction(AddressBookEntry addressBookEntry) {
            super(addressBookEntry.toString());
            this.entry = addressBookEntry;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServerAddressBook.getInstance().setCurrentServer(this.entry);
        }
    }
}

