/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.ModuleAccountInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabberClientFactory
extends ChatServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(JabberClientFactory.class);
    public static final String JABBER_SERVER_TYPE = "jabber";
    public static final String JABBER_PWD = "jabberPassword";
    public static final String JABBER_LOGIN = "jabberLogin";
    public static final String JABBER_PORT = "jabberPort";
    public static final String JABBER_HOST = "jabberHost";
    public static final String DEFAULT_JABBER_PORT = "5222";
    public static final String DEFAULT_JABBER_HOST = "localhost";

    public ChatServerConnection buildServer(Properties properties) {
        String string = properties.getProperty(JABBER_HOST, DEFAULT_JABBER_HOST);
        int n = 5222;
        try {
            n = Integer.parseInt(properties.getProperty(JABBER_PORT, DEFAULT_JABBER_PORT));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        ModuleAccountInfo moduleAccountInfo = new ModuleAccountInfo(properties.getProperty(JABBER_LOGIN), properties.getProperty(JABBER_PWD));
        JabberClient jabberClient = new JabberClient(GameModule.getGameModule(), string, n, moduleAccountInfo);
        jabberClient.addPropertyChangeListener("Status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = (String)propertyChangeEvent.getNewValue();
                GameModule.getGameModule().warn(string);
                logger.error("", (Object)string);
            }
        });
        jabberClient.addPropertyChangeListener("Msg", new CommandDecoder());
        return jabberClient;
    }
}

