/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Box;
import javax.swing.KeyStroke;

public class GlobalHotKey
extends Decorator
implements TranslatablePiece {
    public static final String ID = "globalhotkey;";
    protected NamedKeyStroke commandKey;
    protected NamedKeyStroke globalHotKey;
    protected String commandName = "Hotkey";
    protected KeyCommand[] commands;
    protected KeyCommand command;
    protected String description = "";

    public GlobalHotKey() {
        this(ID, null);
    }

    public GlobalHotKey(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.command = new KeyCommand(this.commandName, this.commandKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command.setEnabled(this.getMap() != null);
            this.commands = this.commandName != null && this.commandName.length() > 0 && this.commandKey != null && !this.commandKey.isNull() ? new KeyCommand[]{this.command} : new KeyCommand[0];
        }
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.commandName).append(this.commandKey).append(this.globalHotKey).append(this.description);
        return ID + sequenceEncoder.getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.command.matches(keyStroke)) {
            GameModule gameModule = GameModule.getGameModule();
            boolean bl = gameModule.pauseLogging();
            GameModule.getGameModule().fireKeyStroke(this.globalHotKey);
            if (bl) {
                return gameModule.resumeLogging();
            }
        }
        return null;
    }

    public void mySetState(String string) {
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        return this.description == null || this.description.length() == 0 ? "Global Hotkey" : "Global Hotkey:  " + this.description;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalHotKey.htm");
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(ID.length()), ';');
        this.commandName = decoder.nextToken();
        this.commandKey = decoder.nextNamedKeyStroke('H');
        this.globalHotKey = decoder.nextNamedKeyStroke(null);
        this.description = decoder.nextToken("");
        this.commands = null;
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getDescription() + " command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer commandConfig;
        private NamedHotKeyConfigurer commandKeyConfig;
        private NamedHotKeyConfigurer hotKeyConfig;
        protected StringConfigurer descConfig;
        private Box controls = Box.createVerticalBox();

        public Ed(GlobalHotKey globalHotKey) {
            this.descConfig = new StringConfigurer(null, "Description:  ", globalHotKey.description);
            this.controls.add(this.descConfig.getControls());
            this.commandConfig = new StringConfigurer(null, "Menu text:  ", globalHotKey.commandName);
            this.controls.add(this.commandConfig.getControls());
            this.commandKeyConfig = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", globalHotKey.commandKey);
            this.controls.add(this.commandKeyConfig.getControls());
            this.hotKeyConfig = new NamedHotKeyConfigurer(null, "Global Hotkey:  ", globalHotKey.globalHotKey);
            this.controls.add(this.hotKeyConfig.getControls());
        }

        public Component getControls() {
            return this.controls;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.commandConfig.getValueString()).append(this.commandKeyConfig.getValueString()).append(this.hotKeyConfig.getValueString()).append(this.descConfig.getValueString());
            return GlobalHotKey.ID + sequenceEncoder.getValue();
        }
    }
}

