/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameRefresher;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PluginsLoader;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.gamepieceimage.GamePieceImageDefinitions;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.chat.AddressBookServerConfigurer;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClient;
import VASSAL.chat.DynamicClientFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.jabber.JabberClientFactory;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Language;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.menu.MenuManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicModule
extends GameModule {
    private static final Logger log = LoggerFactory.getLogger(BasicModule.class);
    private static char COMMAND_SEPARATOR = (char)27;
    protected ChatServerControls serverControls;
    protected GameRefresher gameRefresher;

    public BasicModule(DataArchive dataArchive) {
        super(dataArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void build() throws IOException {
        DataArchive dataArchive = this.getDataArchive();
        File file = new File(dataArchive.getName());
        if (!file.exists() || file.length() == 0L) {
            this.build(null);
        } else {
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(dataArchive.getInputStream("buildFile"));
                }
                catch (IOException iOException) {
                    throw (IOException)new IOException(Resources.getString("BasicModule.not_a_module")).initCause(iOException);
                }
                Document document = Builder.createDocument(bufferedInputStream);
                this.build(document.getDocumentElement());
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
        }
        MenuManager.getInstance().addAction("Prefs.edit_preferences", this.getPrefs().getEditor().getEditAction());
        this.gameRefresher = new GameRefresher(this);
        this.gameRefresher.addTo(this);
        MenuManager.getInstance().addAction("GameRefresher.refresh_counters", this.gameRefresher.getRefreshAction());
    }

    @Override
    public void build(Element element) {
        if (element != null) {
            this.gameName = element.getAttribute("name");
            if (element.getAttribute("VassalVersion").length() > 0) {
                this.vassalVersionCreated = element.getAttribute("VassalVersion");
            }
        }
        this.initIdentityPreferences();
        this.initImagePreferences();
        Prefs.initSharedGlobalPrefs();
        this.initGameState();
        this.initLogger();
        this.initServer();
        new PluginsLoader().addTo(this);
        if (element != null) {
            super.build(element);
            this.ensureComponent(GamePieceImageDefinitions.class);
            this.ensureComponent(GlobalProperties.class);
            this.ensureComponent(Language.class);
        } else {
            this.buildDefaultComponents();
        }
        this.initFrame();
    }

    protected void initIdentityPreferences() {
        this.idChangeSupport = new PropertyChangeSupport(this);
        StringConfigurer stringConfigurer = new StringConfigurer("RealName", Resources.getString("Prefs.name_label"), Resources.getString("Prefs.newbie"));
        stringConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicModule.this.idChangeSupport.firePropertyChange(propertyChangeEvent);
            }
        });
        TextConfigurer textConfigurer = new TextConfigurer("Profile", Resources.getString("Prefs.personal_info"), "");
        textConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicModule.this.idChangeSupport.firePropertyChange(propertyChangeEvent);
            }
        });
        PasswordConfigurer passwordConfigurer = new PasswordConfigurer("SecretName", Resources.getString("Prefs.password_label"), Resources.getString("Prefs.password_prompt", System.getProperty("user.name")));
        passwordConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GameModule.setUserId((String)propertyChangeEvent.getNewValue());
            }
        });
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), stringConfigurer);
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), passwordConfigurer);
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), textConfigurer);
        GameModule.setUserId(passwordConfigurer.getValueString());
    }

    protected void initImagePreferences() {
    }

    protected void initServer() {
        ChatServerFactory.register("node", new NodeClientFactory());
        ChatServerFactory.register("dynamic", new DynamicClientFactory());
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        ChatServerFactory.register("jabber", new JabberClientFactory());
        this.server = new DynamicClient();
        AddressBookServerConfigurer addressBookServerConfigurer = new AddressBookServerConfigurer("ServerImpl", "Server", (HybridClient)this.server);
        Prefs.getGlobalPrefs().addOption(Resources.getString("Chat.server"), addressBookServerConfigurer);
        this.serverControls = new ChatServerControls();
        this.serverControls.addTo(this);
    }

    protected void initLogger() {
        this.logger = new BasicLogger();
        ((BasicLogger)this.logger).build(null);
        ((BasicLogger)this.logger).addTo(this);
    }

    protected void initGameState() {
        this.theState = new GameState();
        this.theState.addTo(this);
        this.addCommandEncoder(this.theState);
    }

    @Override
    public Command decode(String string) {
        if (string == null) {
            return null;
        }
        Command command = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, COMMAND_SEPARATOR);
        String string2 = decoder.nextToken();
        if (string.equals(string2)) {
            command = this.decodeSubCommand(string2);
        } else {
            Command command2 = null;
            command = this.decode(string2);
            while (decoder.hasMoreTokens()) {
                command2 = this.decode(decoder.nextToken());
                command = command == null ? command2 : command.append(command2);
            }
        }
        return command;
    }

    private Command decodeSubCommand(String string) {
        Command command = null;
        for (int i = 0; i < this.commandEncoders.length && command == null; ++i) {
            command = this.commandEncoders[i].decode(string);
        }
        return command;
    }

    @Override
    public String encode(Command command) {
        if (command == null) {
            return null;
        }
        String string = this.encodeSubCommand(command);
        Command[] commandArray = command.getSubCommands();
        if (commandArray.length > 0) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(string, COMMAND_SEPARATOR);
            for (int i = 0; i < commandArray.length; ++i) {
                String string2 = this.encode(commandArray[i]);
                if (string2 == null) continue;
                sequenceEncoder.append(string2);
            }
            string = sequenceEncoder.getValue();
        }
        return string;
    }

    private String encodeSubCommand(Command command) {
        String string = null;
        for (int i = 0; i < this.commandEncoders.length && string == null; ++i) {
            string = this.commandEncoders[i].encode(command);
        }
        return string;
    }

    protected void buildDefaultComponents() {
        this.addComponent(BasicCommandEncoder.class);
        this.addComponent(Documentation.class);
        this.addComponent(PlayerRoster.class);
        this.addComponent(GlobalOptions.class);
        this.addComponent(Map.class);
        this.addComponent(GamePieceImageDefinitions.class);
        this.addComponent(GlobalProperties.class);
        this.addComponent(PrototypesContainer.class);
        this.addComponent(PieceWindow.class);
        this.addComponent(Chatter.class);
        this.addComponent(Language.class);
    }

    protected void initFrame() {
        Rectangle rectangle = Info.getScreenBounds(this.frame);
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            this.frame.setLocation(rectangle.getLocation());
            this.frame.setSize(rectangle.width, rectangle.height / 3);
        } else {
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height / 4);
            this.getPrefs().addOption(new PositionOption("BoundsOfGameModule", this.frame, rectangle2));
        }
        String string = Resources.getString("BasicModule.version_message", this.getLocalizedGameName(), this.moduleVersion);
        this.warn(string);
        log.warn(string);
        this.initFrameTitle();
    }

    protected void ensureComponent(Class<? extends Buildable> clazz) {
        if (this.getComponentsOf(clazz).isEmpty()) {
            this.addComponent(clazz);
        }
    }

    protected void addComponent(Class<? extends Buildable> clazz) {
        Buildable buildable = null;
        try {
            buildable = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
        }
        if (buildable != null) {
            buildable.build(null);
            buildable.addTo(this);
            this.add(buildable);
        }
    }

    public ChatServerControls getServerControls() {
        return this.serverControls;
    }

    @Override
    public String getI18nPrefix() {
        return "";
    }
}

