/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.module.Documentation;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.launch.LaunchTourAction;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstTimeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FirstTimeDialog.class);

    public FirstTimeDialog(Frame frame) {
        super(frame, true);
        Serializable serializable;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JLabel jLabel = new JLabel();
        final JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("SansSerif", 1, 40));
        jLabel2.setText(Resources.getString("Main.welcome"));
        jLabel2.setForeground(Color.black);
        final JButton jButton = new JButton(new LaunchTourAction(frame));
        final JButton jButton2 = new JButton(Resources.getString("Main.jump_right_in"));
        final JButton jButton3 = new JButton(Resources.getString("General.help"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FirstTimeDialog.this.dispose();
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        try {
            serializable = new File(Documentation.getDocumentationBaseDir(), "README.html");
            jButton3.addActionListener(new ShowHelpAction(serializable.toURI().toURL(), null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        serializable = new JLabel(Resources.getString("Prefs.language") + ":");
        final JComboBox<Object> jComboBox = new JComboBox<Object>(Resources.getSupportedLocales().toArray());
        jComboBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setText(((Locale)object).getDisplayName(Resources.getLocale()));
                return this;
            }
        });
        jComboBox.setSelectedItem(Resources.getLocale());
        jComboBox.addActionListener(new ActionListener((JLabel)serializable){
            final /* synthetic */ JLabel val$lang;
            {
                this.val$lang = jLabel22;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Resources.setLocale((Locale)jComboBox.getSelectedItem());
                jLabel2.setText(Resources.getString("Main.welcome"));
                jButton.setText(Resources.getString("Main.tour"));
                jButton2.setText(Resources.getString("Main.jump_right_in"));
                jButton3.setText(Resources.getString("General.help"));
                this.val$lang.setText(Resources.getString("Prefs.language") + ":");
                FirstTimeDialog.this.pack();
            }
        });
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutocreateGaps(true);
        groupLayout.setAutocreateContainerGaps(true);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(4, true).add((Component)jLabel).add((Component)jLabel2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jButton).add((Component)jButton2).add((Component)jButton3)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, Integer.MAX_VALUE).add((Component)serializable).add(jComboBox).add(0, 0, Integer.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel).addPreferredGap(1, -1, Integer.MAX_VALUE).add((Component)jLabel2).addPreferredGap(1, -1, Integer.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3, false).add((Component)jButton).add((Component)jButton2).add((Component)jButton3)).addPreferredGap(1, -1, Integer.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3, false).add((Component)serializable).add(jComboBox)));
        groupLayout.linkSize(new Component[]{jButton, jButton2, jButton3});
        this.add(jPanel);
        this.pack();
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageUtils.getImageResource("/images/Splash.png");
        }
        catch (ImageIOException imageIOException) {
            logger.error("", (Throwable)imageIOException);
        }
        if (bufferedImage != null) {
            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension dimension = this.getSize();
            Dimension dimension2 = new Dimension(Math.max(rectangle.width - dimension.width, 0), Math.max(rectangle.height - dimension.height, 0));
            if (dimension2.width != 0 && dimension2.height != 0) {
                if (dimension2.width >= bufferedImage.getWidth() && dimension2.height >= bufferedImage.getHeight()) {
                    jLabel.setIcon(new ImageIcon(bufferedImage));
                } else {
                    double d = Math.min((double)dimension2.width / (double)bufferedImage.getWidth(), (double)dimension2.height / (double)bufferedImage.getHeight());
                    jLabel.setIcon(new ImageIcon(ImageUtils.transform(bufferedImage, d, 0.0)));
                }
            }
            this.pack();
        }
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
    }
}

