/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.tools.HTTPPostBuilder;
import VASSAL.tools.io.IOUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BugUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBugReport(String string, String string2, String string3, Throwable throwable) throws IOException {
        HTTPPostBuilder hTTPPostBuilder = new HTTPPostBuilder();
        InputStream inputStream = null;
        try {
            hTTPPostBuilder.setParameter("version", Info.getVersion());
            hTTPPostBuilder.setParameter("email", string);
            hTTPPostBuilder.setParameter("summary", BugUtils.getSummary(throwable));
            hTTPPostBuilder.setParameter("description", string2);
            hTTPPostBuilder.setParameter("log", "errorLog", string3);
            inputStream = hTTPPostBuilder.post("http://www.vassalengine.org/util/bug.php");
            String string4 = IOUtils.toString((InputStream)inputStream);
            try {
                if (Integer.parseInt(string4) != 0) {
                    throw new NumberFormatException("Bad result: " + string4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw (IOException)new IOException().initCause(numberFormatException);
            }
            inputStream.close();
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly(inputStream);
            throw throwable2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    private static String getSummary(Throwable throwable) {
        String string;
        if (throwable == null) {
            string = "Automated Bug Report";
        } else {
            String string2 = throwable.getClass().getName();
            string = string2.substring(string2.lastIndexOf(46) + 1);
            if (throwable.getMessage() != null) {
                string = string + ": " + throwable.getMessage();
            }
        }
        return string;
    }

    public static String getErrorLog() {
        String string = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(new File(Info.getConfDir(), "errorLog"));
            string = IOUtils.toString((Reader)fileReader);
            fileReader.close();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(fileReader);
        }
        return string;
    }
}

