/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public final class GeneralFilter {
    public static final int OPAQUE = 0;
    public static final int TRANS_PREMULT = 1;
    public static final int TRANS_UNPREMULT = 2;

    private GeneralFilter() {
    }

    public static BufferedImage zoom(Rectangle rectangle, BufferedImage bufferedImage, Filter filter) {
        WritableRaster writableRaster = bufferedImage.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
        GeneralFilter.zoom(writableRaster, writableRaster.getBounds(), bufferedImage, filter);
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster, bufferedImage.isAlphaPremultiplied(), null);
    }

    public static void zoom(WritableRaster writableRaster, Rectangle rectangle, BufferedImage bufferedImage, Filter filter) {
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = bufferedImage.getTransparency() == 1 ? 0 : (bufferedImage.isAlphaPremultiplied() ? 1 : 2);
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = n2 + writableRaster.getWidth() - 1;
        int n5 = n3 + writableRaster.getHeight() - 1;
        int n6 = writableRaster.getWidth();
        int n7 = writableRaster.getHeight();
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = bufferedImage.getWidth();
        int n11 = bufferedImage.getHeight();
        float f = n10 == 1 ? (float)n8 : (float)(n8 - 1) / (float)(n10 - 1);
        float f2 = n11 == 1 ? (float)n9 : (float)(n9 - 1) / (float)(n11 - 1);
        float f3 = filter.getSamplingRadius();
        int n12 = Math.max(0, (int)Math.floor(((float)n2 - f3) / f));
        int n13 = Math.max(0, (int)Math.floor(((float)n3 - f3) / f2));
        int n14 = Math.min(n10 - 1, (int)Math.ceil(((float)n4 + f3) / f));
        int n15 = Math.min(n11 - 1, (int)Math.ceil(((float)n5 + f3) / f2));
        int n16 = n14 - n12 + 1;
        int n17 = n15 - n13 + 1;
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        GeneralFilter.resample(nArray2, false, n12, n13, n14, n15, n16, n17, n, n10, n11, nArray, n2, n3, n4, n5, n6, n7, n8, n9, f, f2, filter);
    }

    public static void resample(int[] nArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray2, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, float f, float f2, Filter filter) {
        int[] nArray3 = new int[n6];
        float f3 = filter.getSamplingRadius();
        CList[] cListArray = GeneralFilter.calc_contrib(n15, f3, f2, n11, n2, n6, filter);
        CList[] cListArray2 = GeneralFilter.calc_contrib(n14, f3, f, n10, n, n5, filter);
        switch (n7) {
            case 0: {
                if (bl) {
                    for (int i = 0; i < n14; ++i) {
                        GeneralFilter.apply_h_opaque(0, 0, n6, n5, cListArray2[i], nArray, nArray3);
                        GeneralFilter.apply_v_opaque(n15, cListArray, nArray3, nArray2, i, n14);
                    }
                } else {
                    for (int i = 0; i < n14; ++i) {
                        GeneralFilter.apply_h_opaque(n, n2, n6, n8, cListArray2[i], nArray, nArray3);
                        GeneralFilter.apply_v_opaque(n15, cListArray, nArray3, nArray2, i, n14);
                    }
                }
                break;
            }
            case 1: {
                if (bl) {
                    for (int i = 0; i < n14; ++i) {
                        GeneralFilter.apply_h(0, 0, n6, n5, cListArray2[i], nArray, nArray3);
                        GeneralFilter.apply_v(n15, cListArray, nArray3, nArray2, i, n14);
                    }
                } else {
                    for (int i = 0; i < n14; ++i) {
                        GeneralFilter.apply_h(n, n2, n6, n8, cListArray2[i], nArray, nArray3);
                        GeneralFilter.apply_v(n15, cListArray, nArray3, nArray2, i, n14);
                    }
                }
                break;
            }
            case 2: {
                float f4;
                int n18;
                int n19;
                int n20;
                int[] nArray4 = new int[nArray.length];
                for (n20 = 0; n20 < nArray.length; ++n20) {
                    n19 = nArray[n20];
                    n18 = n19 >>> 24 & 0xFF;
                    if (n18 == 255) {
                        nArray4[n20] = n19;
                        continue;
                    }
                    f4 = (float)n18 / 255.0f;
                    nArray4[n20] = n18 << 24 | (int)((float)(n19 >>> 16 & 0xFF) * f4 + 0.5f) << 16 | (int)((float)(n19 >>> 8 & 0xFF) * f4 + 0.5f) << 8 | (int)((float)(n19 & 0xFF) * f4 + 0.5f);
                }
                if (bl) {
                    for (n20 = 0; n20 < n14; ++n20) {
                        GeneralFilter.apply_h(0, 0, n6, n5, cListArray2[n20], nArray4, nArray3);
                        GeneralFilter.apply_v(n15, cListArray, nArray3, nArray2, n20, n14);
                    }
                } else {
                    for (n20 = 0; n20 < n14; ++n20) {
                        GeneralFilter.apply_h(n, n2, n6, n8, cListArray2[n20], nArray4, nArray3);
                        GeneralFilter.apply_v(n15, cListArray, nArray3, nArray2, n20, n14);
                    }
                }
                for (n20 = 0; n20 < nArray2.length; ++n20) {
                    n19 = nArray2[n20];
                    n18 = n19 >>> 24 & 0xFF;
                    if (n18 == 255) continue;
                    f4 = 255.0f / (float)n18;
                    nArray2[n20] = n18 << 24 | (int)((float)(n19 >>> 16 & 0xFF) * f4 + 0.5f) << 16 | (int)((float)(n19 >>> 8 & 0xFF) * f4 + 0.5f) << 8 | (int)((float)(n19 & 0xFF) * f4 + 0.5f);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static CList[] calc_contrib(int n, float f, float f2, int n2, int n3, int n4, Filter filter) {
        CList[] cListArray = new CList[n];
        for (int i = 0; i < cListArray.length; ++i) {
            cListArray[i] = new CList();
        }
        float f3 = 1.0f / (1.0f * Math.max(1.0f / f2, 1.0f));
        float f4 = f / f3;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6;
            float f5 = ((float)(i + n2) + 0.5f) / f2;
            int n7 = (int)Math.max(f5 - f4 + 0.5f, (float)n3);
            int n8 = (int)Math.min(f5 + f4 + 0.5f, (float)(n3 + n4));
            cListArray[i].n = n6 = n8 - n7;
            cListArray[i].pixel = n7 - n3;
            cListArray[i].weight = new float[n6];
            float f6 = 0.0f;
            for (n5 = 0; n5 < n6; ++n5) {
                cListArray[i].weight[n5] = filter.apply(f3 * ((float)(n7 + n5) - f5 + 0.5f));
                f6 += cListArray[i].weight[n5];
            }
            if (f6 == 0.0f || f6 == 1.0f) continue;
            n5 = 0;
            while (n5 < n6) {
                int n9 = n5++;
                cListArray[i].weight[n9] = cListArray[i].weight[n9] / f6;
            }
        }
        return cListArray;
    }

    private static void apply_h(int n, int n2, int n3, int n4, CList cList, int[] nArray, int[] nArray2) {
        CList cList2 = cList;
        int n5 = cList2.n;
        int n6 = n + cList2.pixel + n2 * n4;
        for (int i = 0; i < n3; ++i) {
            int n7;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n8 = n6 + i * n4;
            int n9 = nArray[n8];
            boolean bl = false;
            for (n7 = 0; n7 < n5; ++n7) {
                if (cList2.weight[n7] == 0.0f || nArray[n8 + n7] == n9) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n7 = 0; n7 < n5; ++n7) {
                    float f5 = cList2.weight[n7];
                    int n10 = nArray[n8 + n7];
                    f += (float)(n10 >>> 24 & 0xFF) * f5;
                    f2 += (float)(n10 >>> 16 & 0xFF) * f5;
                    f3 += (float)(n10 >>> 8 & 0xFF) * f5;
                    f4 += (float)(n10 & 0xFF) * f5;
                }
                nArray2[i] = (f > 255.0f ? 255 : (f < 0.0f ? 0 : (int)(f + 0.5f))) << 24 | (f2 > 255.0f ? 255 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 16 | (f3 > 255.0f ? 255 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f))) << 8 | (f4 > 255.0f ? 255 : (f4 < 0.0f ? 0 : (int)(f4 + 0.5f)));
                continue;
            }
            nArray2[i] = n9;
        }
    }

    private static void apply_h_opaque(int n, int n2, int n3, int n4, CList cList, int[] nArray, int[] nArray2) {
        CList cList2 = cList;
        int n5 = cList2.n;
        int n6 = n + cList2.pixel + n2 * n4;
        for (int i = 0; i < n3; ++i) {
            int n7;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n8 = n6 + i * n4;
            int n9 = nArray[n8];
            boolean bl = false;
            for (n7 = 0; n7 < n5; ++n7) {
                if (cList2.weight[n7] == 0.0f || nArray[n8 + n7] == n9) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n7 = 0; n7 < n5; ++n7) {
                    float f4 = cList2.weight[n7];
                    int n10 = nArray[n8 + n7];
                    f += (float)(n10 >>> 16 & 0xFF) * f4;
                    f2 += (float)(n10 >>> 8 & 0xFF) * f4;
                    f3 += (float)(n10 & 0xFF) * f4;
                }
                nArray2[i] = (f > 255.0f ? 255 : (f < 0.0f ? 0 : (int)(f + 0.5f))) << 16 | (f2 > 255.0f ? 255 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 8 | (f3 > 255.0f ? 255 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f)));
                continue;
            }
            nArray2[i] = n9;
        }
    }

    private static void apply_v(int n, CList[] cListArray, int[] nArray, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            CList cList = cListArray[i];
            int n6 = cList.n;
            int n7 = nArray[cList.pixel];
            boolean bl = false;
            for (n5 = 0; n5 < n6; ++n5) {
                if (cList.weight[n5] == 0.0f || nArray[cList.pixel + n5] == n7) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n5 = 0; n5 < n6; ++n5) {
                    float f5 = cList.weight[n5];
                    n4 = nArray[cList.pixel + n5];
                    f += (float)(n4 >>> 24 & 0xFF) * f5;
                    f2 += (float)(n4 >>> 16 & 0xFF) * f5;
                    f3 += (float)(n4 >>> 8 & 0xFF) * f5;
                    f4 += (float)(n4 & 0xFF) * f5;
                }
                int n8 = f > 255.0f ? 255 : (n5 = f < 0.0f ? 0 : (int)(f + 0.5f));
                nArray2[n2 + i * n3] = n5 << 24 | (f2 > (float)n5 ? n5 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 16 | (f3 > (float)n5 ? n5 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f))) << 8 | (f4 > (float)n5 ? n5 : (f4 < 0.0f ? 0 : (int)(f4 + 0.5f)));
                continue;
            }
            n5 = n7 >>> 24 & 0xFF;
            int n9 = n7 >>> 16 & 0xFF;
            n4 = n7 >>> 8 & 0xFF;
            int n10 = n7 & 0xFF;
            nArray2[n2 + i * n3] = n5 << 24 | (n9 > n5 ? n5 : n9) << 16 | (n4 > n5 ? n5 : n4) << 8 | (n10 > n5 ? n5 : n10);
        }
    }

    private static void apply_v_opaque(int n, CList[] cListArray, int[] nArray, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            CList cList = cListArray[i];
            int n5 = cList.n;
            int n6 = nArray[cList.pixel];
            boolean bl = false;
            for (n4 = 0; n4 < n5; ++n4) {
                if (cList.weight[n4] == 0.0f || nArray[cList.pixel + n4] == n6) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n4 = 0; n4 < n5; ++n4) {
                    float f4 = cList.weight[n4];
                    int n7 = nArray[cList.pixel + n4];
                    f += (float)(n7 >>> 16 & 0xFF) * f4;
                    f2 += (float)(n7 >>> 8 & 0xFF) * f4;
                    f3 += (float)(n7 & 0xFF) * f4;
                }
                nArray2[n2 + i * n3] = (f > 255.0f ? 255 : (f < 0.0f ? 0 : (int)(f + 0.5f))) << 16 | (f2 > 255.0f ? 255 : (f2 < 0.0f ? 0 : (int)(f2 + 0.5f))) << 8 | (f3 > 255.0f ? 255 : (f3 < 0.0f ? 0 : (int)(f3 + 0.5f)));
                continue;
            }
            nArray2[n2 + i * n3] = n6;
        }
    }

    public static final class BSplineFilter
    extends Filter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 1.0f) {
                float f2 = f * f;
                return 0.5f * f2 * f - f2 + 0.6666667f;
            }
            if (f < 2.0f) {
                f = 2.0f - f;
                return 0.16666667f * (f * f * f);
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 2.0f;
        }
    }

    public static final class BellFilter
    extends Filter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 0.5f) {
                return 0.75f - f * f;
            }
            if (f < 1.5f) {
                return 0.5f * ((f -= 1.5f) * f);
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.5f;
        }
    }

    public static final class MitchellFilter
    extends Filter {
        private static final float B = 0.33333334f;
        private static final float C = 0.33333334f;
        private static final float P0 = 0.8888889f;
        private static final float P2 = -2.0f;
        private static final float P3 = 1.1666666f;
        private static final float Q0 = 1.7777778f;
        private static final float Q1 = -3.3333333f;
        private static final float Q2 = 2.0f;
        private static final float Q3 = -0.38888887f;

        public float apply(float f) {
            if (f < -2.0f) {
                return 0.0f;
            }
            if (f < -1.0f) {
                return 1.7777778f - f * (-3.3333333f - f * (2.0f - f * -0.38888887f));
            }
            if (f < 0.0f) {
                return 0.8888889f + f * f * (-2.0f - f * 1.1666666f);
            }
            if (f < 1.0f) {
                return 0.8888889f + f * f * (-2.0f + f * 1.1666666f);
            }
            if (f < 2.0f) {
                return 1.7777778f + f * (-3.3333333f + f * (2.0f + f * -0.38888887f));
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 2.0f;
        }
    }

    public static final class Lanczos3Filter
    extends Filter {
        private float sinc(float f) {
            if (f == 0.0f) {
                return 1.0f;
            }
            f = (float)((double)f * Math.PI);
            return (float)(Math.sin(f) / (double)f);
        }

        public float apply(float f) {
            if (f < -3.0f) {
                return 0.0f;
            }
            if (f < 0.0f) {
                return this.sinc(-f) * this.sinc(-f / 3.0f);
            }
            if (f < 3.0f) {
                return this.sinc(f) * this.sinc(f / 3.0f);
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 3.0f;
        }
    }

    public static final class TriangleFilter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 1.0f) {
                return 1.0f - f;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.0f;
        }
    }

    public static final class BoxFilter
    extends Filter {
        public float apply(float f) {
            if (f > -0.5f && f <= 0.5f) {
                return 1.0f;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 0.5f;
        }
    }

    public static final class HermiteFilter
    extends Filter {
        public float apply(float f) {
            if (f < 0.0f) {
                f = -f;
            }
            if (f < 1.0f) {
                return (2.0f * f - 3.0f) * f * f + 1.0f;
            }
            return 0.0f;
        }

        public float getSamplingRadius() {
            return 1.0f;
        }
    }

    public static abstract class Filter {
        public abstract float getSamplingRadius();

        public abstract float apply(float var1);
    }

    private static final class CList {
        public int n;
        public int pixel;
        public float[] weight;

        private CList() {
        }
    }
}

