/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.spi.wizard.WizardPage;

final class GenericListener
implements ActionListener,
PropertyChangeListener,
ItemListener,
ContainerListener,
DocumentListener,
ChangeListener,
ListSelectionListener,
TreeSelectionListener,
TableModelListener {
    private static final Logger logger = Logger.getLogger(GenericListener.class.getName());
    private final WizardPage wizardPage;
    private boolean ignoreEvents;
    private Set listenedTo = new HashSet();
    private final WizardPage.CustomComponentListener extListener;
    private final WizardPage.CustomComponentNotifier extNotifier;

    public GenericListener(WizardPage wizardPage, WizardPage.CustomComponentListener customComponentListener, WizardPage.CustomComponentNotifier customComponentNotifier) {
        this.extListener = customComponentListener;
        this.extNotifier = customComponentNotifier;
        if (this.extListener == null != (this.extNotifier == null)) {
            throw new RuntimeException();
        }
        if (wizardPage == null) {
            throw new IllegalArgumentException("WizardPage may not be null");
        }
        this.wizardPage = wizardPage;
        wizardPage.addContainerListener((ContainerListener)this);
    }

    public GenericListener(WizardPage wizardPage) {
        this(wizardPage, null, null);
    }

    protected boolean isProbablyAContainer(Component component) {
        boolean bl;
        boolean bl2 = bl = this.extListener != null ? this.extListener.isContainer(component) : false;
        if (!bl) {
            boolean bl3 = this.isSwingClass(component);
            bl = bl3 ? component instanceof JPanel || component instanceof JSplitPane || component instanceof JToolBar || component instanceof JViewport || component instanceof JScrollPane || component instanceof JFrame || component instanceof JRootPane || component instanceof Window || component instanceof Frame || component instanceof Dialog || component instanceof JTabbedPane || component instanceof JInternalFrame || component instanceof JDesktopPane || component instanceof JLayeredPane : component instanceof Container;
        }
        return bl;
    }

    protected boolean isSwingClass(Component component) {
        String string = component.getClass().getName();
        boolean bl = string.startsWith("javax.swing.");
        return bl;
    }

    protected void attachTo(Component component) {
        if (this.extListener != null && this.extListener.accept(component)) {
            this.extListener.startListeningTo(component, this.extNotifier);
            this.listenedTo.add(component);
            if (this.wizardPage.getMapKeyFor(component) != null) {
                this.wizardPage.maybeUpdateMap(component);
            }
            return;
        }
        if (this.isProbablyAContainer(component)) {
            this.attachToHierarchyOf((Container)component);
        } else if (component instanceof JList) {
            this.listenedTo.add(component);
            ((JList)component).addListSelectionListener(this);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(this);
        } else if (component instanceof JTree) {
            this.listenedTo.add(component);
            ((JTree)component).getSelectionModel().addTreeSelectionListener(this);
        } else if (component instanceof JToggleButton) {
            ((AbstractButton)component).addItemListener(this);
        } else if (component instanceof JTextComponent) {
            this.listenedTo.add(component);
            ((JTextComponent)component).getDocument().addDocumentListener(this);
        } else if (component instanceof JColorChooser) {
            this.listenedTo.add(component);
            ((JColorChooser)component).getSelectionModel().addChangeListener(this);
        } else if (component instanceof JSpinner) {
            ((JSpinner)component).addChangeListener(this);
        } else if (component instanceof JSlider) {
            ((JSlider)component).addChangeListener(this);
        } else if (component instanceof JTable) {
            this.listenedTo.add(component);
            ((JTable)component).getSelectionModel().addListSelectionListener(this);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Don't know how to listen to a " + component.getClass().getName());
        }
        if (this.accept(component) && !(component instanceof JPanel)) {
            component.addPropertyChangeListener("name", this);
            if (this.wizardPage.getMapKeyFor(component) != null) {
                this.wizardPage.maybeUpdateMap(component);
            }
        }
        if (logger.isLoggable(Level.FINE) && this.accept(component)) {
            logger.fine("Begin listening to " + component);
        }
    }

    protected void detachFrom(Component component) {
        this.listenedTo.remove(component);
        if (this.extListener != null && this.extListener.accept(component)) {
            this.extListener.stopListeningTo(component);
        }
        if (this.isProbablyAContainer(component)) {
            this.detachFromHierarchyOf((Container)component);
        } else if (component instanceof JList) {
            ((JList)component).removeListSelectionListener(this);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).removeActionListener(this);
        } else if (component instanceof JTree) {
            ((JTree)component).getSelectionModel().removeTreeSelectionListener(this);
        } else if (component instanceof JToggleButton) {
            ((AbstractButton)component).removeActionListener(this);
        } else if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().removeDocumentListener(this);
        } else if (component instanceof JColorChooser) {
            ((JColorChooser)component).getSelectionModel().removeChangeListener(this);
        } else if (component instanceof JSpinner) {
            ((JSpinner)component).removeChangeListener(this);
        } else if (component instanceof JSlider) {
            ((JSlider)component).removeChangeListener(this);
        } else if (component instanceof JTable) {
            ((JTable)component).getSelectionModel().removeListSelectionListener(this);
        }
        if (this.accept(component) && !(component instanceof JPanel)) {
            component.removePropertyChangeListener("name", this);
            Object object = this.wizardPage.getMapKeyFor(component);
            if (object != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Named component removed from hierarchy: " + object + ".  Removing any corresponding value from the wizard settings map.");
                }
                this.wizardPage.removeFromMap(object);
            }
        }
        if (logger.isLoggable(Level.FINE) && this.accept(component)) {
            logger.fine("Stop listening to " + component);
        }
    }

    private void detachFromHierarchyOf(Container container) {
        container.removeContainerListener(this);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.detachFrom(componentArray[i]);
        }
    }

    private void attachToHierarchyOf(Container container) {
        container.addContainerListener(this);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.attachTo(componentArray[i]);
        }
    }

    protected boolean accept(Component component) {
        if (this.extListener != null && this.extListener.accept(component)) {
            return true;
        }
        if (!(component instanceof JComponent)) {
            return false;
        }
        return this.isProbablyAContainer(component) || component instanceof JList || component instanceof JComboBox || component instanceof JTree || component instanceof JToggleButton || component instanceof JTextComponent || component instanceof JColorChooser || component instanceof JSpinner || component instanceof JSlider;
    }

    void setIgnoreEvents(boolean bl) {
        this.ignoreEvents = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Object object) {
        block18: {
            if (!this.ignoreEvents) {
                this.setIgnoreEvents(true);
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Event received: " + object);
                    }
                    if (object instanceof EventObject && ((EventObject)object).getSource() instanceof Component) {
                        this.wizardPage.userInputReceived((Component)((EventObject)object).getSource(), object);
                        break block18;
                    }
                    if (object instanceof TreeSelectionEvent) {
                        logger.fine("Looking for a tree for a tree selection event");
                        TreeSelectionModel treeSelectionModel = (TreeSelectionModel)((TreeSelectionEvent)object).getSource();
                        for (Object e : this.listenedTo) {
                            if (!(e instanceof JTree) || ((JTree)e).getSelectionModel() != treeSelectionModel) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("  found it: " + e);
                            }
                            this.wizardPage.userInputReceived((Component)e, object);
                            break block18;
                        }
                        break block18;
                    }
                    if (object instanceof DocumentEvent) {
                        logger.fine("Looking for a JTextComponent for a DocumentEvent");
                        Document document = ((DocumentEvent)object).getDocument();
                        for (Object e : this.listenedTo) {
                            if (!(e instanceof JTextComponent) || ((JTextComponent)e).getDocument() != document) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("  found it: " + e);
                            }
                            this.wizardPage.userInputReceived((Component)e, object);
                            break block18;
                        }
                        break block18;
                    }
                    if (object instanceof ListSelectionEvent) {
                        logger.fine("Looking for a JList or JTable for a ListSelectionEvent");
                        ListSelectionModel listSelectionModel = (ListSelectionModel)((ListSelectionEvent)object).getSource();
                        for (Object e : this.listenedTo) {
                            if (e instanceof JList && ((JList)e).getSelectionModel() == listSelectionModel) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine("  found it: " + e);
                                }
                                this.wizardPage.userInputReceived((Component)e, object);
                            } else {
                                if (!(e instanceof JTable) || ((JTable)e).getSelectionModel() != listSelectionModel) continue;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine("  found it: " + e);
                                }
                                this.wizardPage.userInputReceived((Component)e, object);
                            }
                            break block18;
                        }
                        break block18;
                    }
                    this.wizardPage.userInputReceived(null, object);
                }
                finally {
                    this.setIgnoreEvents(false);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fire(actionEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof JComponent && "name".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getOldValue() instanceof String) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Name of component changed from " + propertyChangeEvent.getOldValue() + " to " + propertyChangeEvent.getNewValue() + ".  Removing any values for " + propertyChangeEvent.getOldValue() + " from the wizard data map");
                }
                this.wizardPage.removeFromMap(propertyChangeEvent.getOldValue());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Possibly update map for renamed component " + propertyChangeEvent.getSource());
            }
            this.wizardPage.maybeUpdateMap((Component)((JComponent)propertyChangeEvent.getSource()));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fire(itemEvent);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (this.accept(containerEvent.getChild())) {
            this.attachTo(containerEvent.getChild());
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.extListener != null && this.extListener.accept(containerEvent.getChild())) {
            this.extListener.stopListeningTo(containerEvent.getChild());
            this.listenedTo.remove(containerEvent.getChild());
        } else if (this.accept(containerEvent.getChild())) {
            this.detachFrom(containerEvent.getChild());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fire(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fire(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fire(documentEvent);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fire(changeEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fire(listSelectionEvent);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.fire(treeSelectionEvent);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fire(tableModelEvent);
    }
}

