/*
 * Decompiled with CFR 0.152.
 */
package arcus.gui;

import arcus.gui.ext.XCaret;
import arcus.model.CubeInstance;
import arcus.model.Parser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class Console
extends JPanel
implements CaretListener,
Cloneable,
FocusListener {
    private static String PROMPT = "arcus> ";
    private int protectionBoundary = PROMPT.length();
    private JTextArea textArea = new JTextArea(PROMPT);
    private JScrollPane scrollPane = null;
    private CommandLineFilter filter = new CommandLineFilter();
    private Vector<String> commands = new Vector();
    private int commandIndex = 0;
    private CubeInstance instance = null;

    public Console(String string) {
        super(new BorderLayout());
        if (string != null) {
            this.textArea.setText(string);
        }
        ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(this.filter);
        this.textArea.addCaretListener(this);
        this.textArea.addFocusListener(this);
        this.textArea.setEditable(true);
        this.textArea.setForeground(new Color(0.75f, 0.75f, 0.75f));
        this.textArea.setBackground(new Color(0.0f, 0.0f, 0.0f));
        this.textArea.setFont(new Font("Monospaced", 0, 15));
        this.textArea.setCaret(new XCaret());
        this.textArea.setCaretColor(new Color(0.75f, 0.75f, 0.75f));
        this.textArea.getCaret().setBlinkRate(0);
        if (string != null) {
            this.textArea.setCaretPosition(string.length());
        } else {
            this.textArea.setCaretPosition(PROMPT.length());
        }
        this.commands.addElement(new String());
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "parse");
        this.textArea.getActionMap().put("parse", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Console.this.getCommand();
                if (string.length() > 0) {
                    Console.this.commands.set(Console.this.commands.size() - 1, string);
                    Console.this.commands.addElement(new String());
                    Console.this.commandIndex = Console.this.commands.size() - 1;
                    Console.this.textArea.append("\n");
                    Parser parser = new Parser();
                    Console.this.textArea.append(parser.parse(string, Console.this.instance));
                    Console.this.textArea.append(PROMPT);
                } else {
                    Console.this.textArea.append("\n" + PROMPT);
                }
                Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                Console.this.protectionBoundary = Console.this.textArea.getText().length();
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.textArea.getActionMap().put("up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Console.this.commandIndex > 0) {
                    Console.this.commands.set(Console.this.commandIndex, Console.this.popCommand());
                    Console.this.commandIndex--;
                    Console.this.textArea.append((String)Console.this.commands.get(Console.this.commandIndex));
                }
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.textArea.getActionMap().put("down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Console.this.commandIndex < Console.this.commands.size() - 1) {
                    Console.this.commands.set(Console.this.commandIndex, Console.this.popCommand());
                    Console.this.commandIndex++;
                    Console.this.textArea.append((String)Console.this.commands.get(Console.this.commandIndex));
                }
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(38, 1), "scroll_inc_up");
        this.textArea.getActionMap().put("scroll_inc_up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = Console.this.scrollPane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(1));
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(40, 1), "scroll_inc_down");
        this.textArea.getActionMap().put("scroll_inc_down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = Console.this.scrollPane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(33, 1), "scroll_block_up");
        this.textArea.getActionMap().put("scroll_block_up", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = Console.this.scrollPane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getBlockIncrement(1));
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(34, 1), "scroll_block_down");
        this.textArea.getActionMap().put("scroll_block_down", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar jScrollBar = Console.this.scrollPane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getBlockIncrement(1));
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(76, 2), "clear");
        this.textArea.getActionMap().put("clear", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.protectionBoundary = 0;
                Console.this.textArea.setText(PROMPT);
                Console.this.protectionBoundary = PROMPT.length();
            }
        });
        this.scrollPane = new JScrollPane(this.textArea);
        this.setPreferredSize(new Dimension(400, 200));
        this.add((Component)this.scrollPane, "Center");
    }

    public Object clone() {
        Console console = new Console(this.textArea.getText());
        console.protectionBoundary = this.protectionBoundary;
        try {
            console.commands = (Vector)this.commands.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        console.commandIndex = this.commandIndex;
        return console;
    }

    public void setInstance(CubeInstance cubeInstance) {
        this.instance = cubeInstance;
    }

    private String getCommand() {
        String string = new String();
        try {
            string = this.textArea.getText(this.protectionBoundary, this.textArea.getDocument().getLength() - this.protectionBoundary);
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        return string;
    }

    private String popCommand() {
        String string = new String();
        try {
            string = this.textArea.getText(this.protectionBoundary, this.textArea.getDocument().getLength() - this.protectionBoundary);
            this.textArea.setCaretPosition(this.protectionBoundary);
            this.textArea.moveCaretPosition(this.textArea.getDocument().getLength());
            this.textArea.cut();
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        return string;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getDot() < this.protectionBoundary) {
            this.textArea.setCaretPosition(this.protectionBoundary);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        ((XCaret)this.textArea.getCaret()).setFocused(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        ((XCaret)this.textArea.getCaret()).setFocused(false);
    }

    public void save(XMLEncoder xMLEncoder) {
        xMLEncoder.writeObject(this.textArea.getText());
        xMLEncoder.writeObject(new Integer(this.protectionBoundary));
        xMLEncoder.writeObject(this.commands);
        xMLEncoder.writeObject(new Integer(this.commandIndex));
    }

    public void load(XMLDecoder xMLDecoder) {
        this.protectionBoundary = 0;
        this.textArea.setText((String)xMLDecoder.readObject());
        this.textArea.setCaretPosition(this.textArea.getText().length());
        this.protectionBoundary = (Integer)xMLDecoder.readObject();
        this.commands = (Vector)xMLDecoder.readObject();
        this.commandIndex = (Integer)xMLDecoder.readObject();
    }

    private class CommandLineFilter
    extends DocumentFilter {
        private CommandLineFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n >= Console.this.protectionBoundary) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            if (n >= Console.this.protectionBoundary) {
                super.remove(filterBypass, n, n2);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n >= Console.this.protectionBoundary) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }
    }
}

